/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.integration.rei.category;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;
import org.gtreimagined.gtlib.Data;
import org.gtreimagined.gtlib.gui.BarDir;
import org.gtreimagined.gtlib.gui.GuiData;
import org.gtreimagined.gtlib.gui.SlotData;
import org.gtreimagined.gtlib.gui.SlotType;
import org.gtreimagined.gtlib.gui.slot.AbstractSlot;
import org.gtreimagined.gtlib.integration.rei.category.RecipeMapDisplay;
import org.gtreimagined.gtlib.integration.xei.renderer.IRecipeInfoRenderer;
import org.gtreimagined.gtlib.item.ScannerItem;
import org.gtreimagined.gtlib.machine.Tier;
import org.gtreimagined.gtlib.recipe.map.IRecipeMap;
import org.gtreimagined.gtlib.util.RegistryUtils;
import org.gtreimagined.gtlib.util.int4;

public class RecipeMapCategory
implements DisplayCategory<RecipeMapDisplay> {
    protected static int JEI_OFFSET_X = 1;
    protected static int JEI_OFFSET_Y = 1;
    protected Component title;
    protected final CategoryIdentifier<RecipeMapDisplay> loc;
    protected Renderer icon;
    protected Parameters progressBar;
    protected GuiData gui;
    protected Tier guiTier;
    private final IRecipeInfoRenderer infoRenderer;

    public RecipeMapCategory(IRecipeMap map, GuiData gui, Tier defaultTier, ResourceLocation iconId) {
        this.loc = CategoryIdentifier.of((ResourceLocation)map.getLoc());
        this.guiTier = map.getGuiTier() == null ? defaultTier : map.getGuiTier();
        this.title = map.getDisplayName();
        int4 progress = new int4(0, gui.getMachineData().getProgressSize().y, gui.getMachineData().getProgressSize().x, gui.getMachineData().getProgressSize().y);
        this.progressBar = new Parameters(gui.getMachineData().getProgressTexture(this.guiTier), gui.getMachineData().getProgressPos().x + 6, gui.getMachineData().getProgressPos().y + 6, progress.z, progress.w, progress.x, progress.y, gui.getMachineData().getDir(), gui.getMachineData().doesBarFill());
        Object icon = map.getIcon();
        if (icon != null) {
            if (icon instanceof ItemStack) {
                ItemStack stack = (ItemStack)icon;
                this.icon = EntryStacks.of((ItemStack)stack);
            }
            if (icon instanceof ItemLike) {
                ItemLike itemLike = (ItemLike)icon;
                this.icon = EntryStacks.of((ItemLike)itemLike);
            }
        } else {
            ScannerItem item;
            ScannerItem scannerItem = item = iconId == null ? Data.DEBUG_SCANNER : RegistryUtils.getItemFromID(iconId);
            if (item == Items.f_41852_) {
                item = Data.DEBUG_SCANNER;
            }
            this.icon = EntryStacks.of((ItemLike)item);
        }
        this.gui = gui;
        this.infoRenderer = map.getInfoRenderer();
    }

    public int getDisplayHeight() {
        return this.gui.getArea().w + 4 + 10 * this.infoRenderer.getRows();
    }

    public int getDisplayWidth(RecipeMapDisplay display) {
        return this.gui.getArea().z + 4;
    }

    public List<Widget> setupDisplay(RecipeMapDisplay display, Rectangle bounds) {
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        widgets.add((Widget)Widgets.createRecipeBase((Rectangle)bounds));
        widgets.add(Widgets.createDrawableWidget((graphics, mouseX, mouseY, delta) -> {
            int ySize = Math.min(bounds.getHeight() - 6, 79);
            int extraPixels = bounds.getHeight() - 6 - ySize;
            RecipeMapCategory.drawTexture(graphics, this.gui.getTexture(this.guiTier, "machine"), bounds.x + 3, bounds.y + 3, this.gui.getArea().x + 1, this.gui.getArea().y + 1, bounds.getWidth() - 6, ySize, 256, 256);
            if (extraPixels > 0) {
                for (int i = 0; i < extraPixels; ++i) {
                    RecipeMapCategory.drawTexture(graphics, this.gui.getTexture(this.guiTier, ""), bounds.x + 3, bounds.y + 3 + ySize + i, this.gui.getArea().x + 1, this.gui.getArea().y + 1, bounds.getWidth() - 6, 1, 256, 256);
                }
            }
        }));
        widgets.addAll(this.setupSlots(display, bounds));
        double recipeMillis = (double)display.getRecipe().getDuration() * 50.0;
        if (recipeMillis < 250.0) {
            recipeMillis = 250.0;
        }
        double finalRecipeMillis = recipeMillis;
        widgets.add(Widgets.createDrawableWidget((graphics, mouseX, mouseY, delta) -> RecipeMapCategory.renderProgress(graphics, bounds, this.progressBar, (float)((double)System.currentTimeMillis() / finalRecipeMillis % 1.0))));
        widgets.add(Widgets.createDrawableWidget((graphics, mouseX, mouseY, delta) -> this.infoRenderer.render(graphics, display.getRecipe(), Minecraft.m_91087_().f_91062_, bounds.x + 1, bounds.y + bounds.getHeight() - 3 - this.infoRenderer.getRows() * 10)));
        return widgets;
    }

    private List<Widget> setupSlots(RecipeMapDisplay display, Rectangle bounds) {
        Point point;
        int s;
        Point point2;
        int finalSlot;
        int s2;
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        List inputs = display.getRecipe().hasInputItems() ? display.getRecipe().getInputItems().stream().map(t -> Arrays.asList(t.m_43908_())).toList() : Collections.emptyList();
        List outputs = display.getRecipe().hasOutputItems() ? Arrays.stream(display.getRecipe().getOutputItems(false)).toList() : Collections.emptyList();
        int inputFluidOffset = 0;
        int outputFluidOffset = 0;
        int offsetX = this.gui.getArea().x - 2;
        int offsetY = this.gui.getArea().y - 2;
        int inputItems = 0;
        int inputFluids = 0;
        List<SlotData<AbstractSlot>> slots = this.gui.getSlots().getSlots(SlotType.IT_IN, this.guiTier);
        int slotCount = slots.size();
        List<SlotData<AbstractSlot>> finalSlots = slots;
        if (slotCount > 0) {
            for (s2 = 0; s2 < slotCount; ++s2) {
                finalSlot = s2;
                widgets.add(Widgets.createDrawableWidget((graphics, mouseX, mouseY, delta) -> RecipeMapCategory.drawTexture(graphics, ((SlotData)finalSlots.get(finalSlot)).getTexture(), ((SlotData)finalSlots.get(finalSlot)).getX() - offsetX + bounds.x - 1, ((SlotData)finalSlots.get(finalSlot)).getY() - offsetY + bounds.y - 1, 0, 0, 18, 18, 18, 18)));
                if (inputs.size() <= 0 || s2 >= inputs.size()) continue;
                point2 = new Point(slots.get(s2).getX() - offsetX + bounds.x, slots.get(s2).getY() - offsetY + bounds.y);
                Slot slot = Widgets.createSlot((Point)point2).disableBackground();
                List input = (List)inputs.get(s2);
                if (input.size() == 0) {
                    slot.entries((Collection)EntryIngredients.of((ItemLike)Data.DEBUG_SCANNER));
                } else {
                    slot.entries((Collection)this.getInput(display, s2));
                    ++inputItems;
                }
                widgets.add((Widget)slot.markInput());
            }
            inputFluidOffset = Math.min(slotCount, inputs.size());
        }
        slots = this.gui.getSlots().getSlots(SlotType.IT_OUT, this.guiTier);
        slotCount = slots.size();
        finalSlots = slots;
        if (slotCount > 0) {
            for (s2 = 0; s2 < slotCount; ++s2) {
                finalSlot = s2;
                widgets.add(Widgets.createDrawableWidget((graphics, mouseX, mouseY, delta) -> RecipeMapCategory.drawTexture(graphics, ((SlotData)finalSlots.get(finalSlot)).getTexture(), ((SlotData)finalSlots.get(finalSlot)).getX() - offsetX + bounds.x - 1, ((SlotData)finalSlots.get(finalSlot)).getY() - offsetY + bounds.y - 1, 0, 0, 18, 18, 18, 18)));
                if (outputs.size() <= 0 || s2 >= outputs.size()) continue;
                point2 = new Point(slots.get(s2).getX() - offsetX + bounds.x, slots.get(s2).getY() - offsetY + bounds.y);
                widgets.add((Widget)Widgets.createSlot((Point)point2).entries((Collection)this.getOutput(display, s2)).disableBackground().markOutput());
            }
            outputFluidOffset = Math.min(slotCount, outputs.size());
        }
        slots = this.gui.getSlots().getSlots(SlotType.FL_IN, this.guiTier);
        finalSlots = slots;
        slotCount = slots.size();
        if (slotCount > 0) {
            List fluids = display.getRecipe().hasInputFluids() ? display.getRecipe().getInputFluids() : List.of();
            for (s = 0; s < slotCount; ++s) {
                int finalSlot2 = s;
                widgets.add(Widgets.createDrawableWidget((graphics, mouseX, mouseY, delta) -> RecipeMapCategory.drawTexture(graphics, ((SlotData)finalSlots.get(finalSlot2)).getTexture(), ((SlotData)finalSlots.get(finalSlot2)).getX() - offsetX + bounds.x - 1, ((SlotData)finalSlots.get(finalSlot2)).getY() - offsetY + bounds.y - 1, 0, 0, 18, 18, 18, 18)));
                if (fluids.size() <= 0 || s >= fluids.size()) continue;
                point = new Point(slots.get(s).getX() - offsetX + bounds.x, slots.get(s).getY() - offsetY + bounds.y);
                widgets.add((Widget)Widgets.createSlot((Point)point).entries((Collection)this.getInput(display, s + inputFluidOffset)).disableBackground().markInput());
                ++inputFluids;
            }
        }
        slots = this.gui.getSlots().getSlots(SlotType.FL_OUT, this.guiTier);
        finalSlots = slots;
        slotCount = slots.size();
        if (slotCount > 0) {
            FluidStack[] fluids = display.getRecipe().hasOutputFluids() ? display.getRecipe().getOutputFluids() : null;
            for (s = 0; s < slotCount; ++s) {
                int finalSlot3 = s;
                widgets.add(Widgets.createDrawableWidget((graphics, mouseX, mouseY, delta) -> RecipeMapCategory.drawTexture(graphics, ((SlotData)finalSlots.get(finalSlot3)).getTexture(), ((SlotData)finalSlots.get(finalSlot3)).getX() - offsetX + bounds.x - 1, ((SlotData)finalSlots.get(finalSlot3)).getY() - offsetY + bounds.y - 1, 0, 0, 18, 18, 18, 18)));
                if (fluids == null || fluids.length <= 0 || s >= fluids.length) continue;
                point = new Point(slots.get(s).getX() - offsetX + bounds.x, slots.get(s).getY() - offsetY + bounds.y);
                widgets.add((Widget)Widgets.createSlot((Point)point).entries((Collection)this.getOutput(display, s + outputFluidOffset)).disableBackground().markOutput());
                ++inputFluids;
            }
        }
        return widgets;
    }

    public static void renderProgress(GuiGraphics graphics, Rectangle bounds, Parameters params, float percent) {
        int realX = bounds.x + params.x - 1;
        int realY = bounds.y + params.y - 1;
        int x = realX;
        int y = realY;
        int xLocation = params.posX;
        int yLocation = params.posY;
        int length = params.length;
        int width = params.width;
        switch (params.dir) {
            case TOP: {
                int progressTime = (int)((float)params.width * percent);
                if (!params.fill) {
                    progressTime = width - progressTime;
                }
                y = y + width - progressTime;
                yLocation = yLocation + width - progressTime;
                width = progressTime;
                break;
            }
            case LEFT: {
                int progressTime = (int)((float)params.length * percent);
                if (params.fill) {
                    length = progressTime;
                    break;
                }
                length -= progressTime;
                break;
            }
            case BOTTOM: {
                int progressTime = (int)((float)params.width * percent);
                if (params.fill) {
                    width = progressTime;
                    break;
                }
                width -= progressTime;
                break;
            }
            default: {
                int progressTime = (int)((float)params.length * percent);
                if (!params.fill) {
                    progressTime = length - progressTime;
                }
                x = x + length - progressTime;
                xLocation = xLocation + length - progressTime;
                length = progressTime;
            }
        }
        RecipeMapCategory.drawTexture(graphics, params.texture, realX, realY, 0, 0, params.length, params.width, params.length, params.width * 2);
        if (percent > 0.0f) {
            RecipeMapCategory.drawTexture(graphics, params.texture, realX, realY, xLocation, yLocation, length, width, params.length, params.width * 2);
        }
    }

    private static void drawTexture(GuiGraphics stack, ResourceLocation loc, int left, int top, int x, int y, int sizeX, int sizeY, int textureHeight, int textureWidth) {
        stack.m_280398_(loc, left, top, 0, (float)x, (float)y, sizeX, sizeY, textureHeight, textureWidth);
    }

    public Renderer getIcon() {
        return this.icon;
    }

    public Component getTitle() {
        return this.title;
    }

    public CategoryIdentifier<? extends RecipeMapDisplay> getCategoryIdentifier() {
        return this.loc;
    }

    public EntryIngredient getInput(RecipeMapDisplay recipeDisplay, int index) {
        List<EntryIngredient> inputs = recipeDisplay.getInputEntries();
        return inputs.size() > index ? inputs.get(index) : EntryIngredient.empty();
    }

    public EntryIngredient getOutput(RecipeMapDisplay recipeDisplay, int index) {
        List<EntryIngredient> outputs = recipeDisplay.getOutputEntries();
        return outputs.size() > index ? outputs.get(index) : EntryIngredient.empty();
    }

    public record Parameters(ResourceLocation texture, int x, int y, int length, int width, int posX, int posY, BarDir dir, boolean fill) {
    }
}

