/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.gui.widget;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.gtreimagined.gtlib.gui.GuiInstance;
import org.gtreimagined.gtlib.gui.IGuiElement;
import org.gtreimagined.gtlib.gui.Widget;
import org.gtreimagined.gtlib.gui.widget.WidgetSupplier;

public class BackgroundWidget
extends Widget {
    private final int xSize;
    private final int ySize;
    private final int guiXSize;
    private final int guiYSize;
    private final ResourceLocation loc;

    protected BackgroundWidget(GuiInstance instance, IGuiElement parent, ResourceLocation loc, int xSize, int ySize, int guiXSize, int guiYSize) {
        super(instance, parent);
        this.xSize = xSize;
        this.ySize = ySize;
        this.guiXSize = guiXSize;
        this.guiYSize = guiYSize;
        this.loc = loc;
        this.setDepth(-2);
    }

    @Override
    public void setParent(IGuiElement parent) {
        super.setParent(parent);
        this.setDepth(parent.depth() - 1);
    }

    public static WidgetSupplier build(ResourceLocation loc, int w, int h) {
        return BackgroundWidget.builder((a, b) -> new BackgroundWidget((GuiInstance)a, (IGuiElement)b, loc, w, h, 256, 256)).clientSide();
    }

    public static WidgetSupplier build(ResourceLocation loc, int w, int h, int guiW, int guiH) {
        return BackgroundWidget.builder((a, b) -> new BackgroundWidget((GuiInstance)a, (IGuiElement)b, loc, w, h, guiW, guiH)).clientSide();
    }

    @Override
    public void render(GuiGraphics graphics, double mouseX, double mouseY, float partialTicks) {
        this.drawTexture(graphics, this.loc, this.realX(), this.realY(), 0, 0, this.xSize, this.ySize);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void drawTexture(GuiGraphics graphics, ResourceLocation loc, int left, int top, int x, int y, int sizeX, int sizeY) {
        graphics.m_280163_(loc, left, top, (float)x, (float)y, sizeX, sizeY, this.guiXSize, this.guiYSize);
    }
}

