/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.datagen.providers;

import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.devtech.arrp.json.tags.JTag;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagBuilder;
import net.minecraft.tags.TagKey;
import org.gtreimagined.gtlib.datagen.GTLibDynamics;
import org.gtreimagined.gtlib.datagen.IGTLibProvider;
import org.gtreimagined.gtlib.datagen.builder.GTTagBuilder;

public abstract class GTTagProvider<T>
implements IGTLibProvider {
    private final String providerDomain;
    private final String providerName;
    private final String prefix;
    protected final Map<ResourceLocation, GTTagBuilder<T>> builders;
    protected final ResourceKey<Registry<T>> registry;
    private Function<T, ResourceKey<T>> keyExtractor;
    public Object2ObjectMap<ResourceLocation, JsonObject> TAGS = new Object2ObjectOpenHashMap();
    public static Object2ObjectOpenHashMap<ResourceLocation, JsonObject> TAGS_GLOBAL = new Object2ObjectOpenHashMap();
    public Object2ObjectMap<ResourceLocation, List<T>> TAGS_TO_REMOVE = new Object2ObjectOpenHashMap();
    public static Object2ObjectOpenHashMap<ResourceKey<?>, Map<ResourceLocation, List<Object>>> TAGS_TO_REMOVE_GLOBAL = new Object2ObjectOpenHashMap();

    public GTTagProvider(ResourceKey<Registry<T>> registry, String providerDomain, String providerName, String prefix, Function<T, ResourceKey<T>> keyExtractor) {
        this.builders = Maps.newLinkedHashMap();
        this.registry = registry;
        this.providerDomain = providerDomain;
        this.providerName = providerName;
        this.prefix = prefix;
        TAGS_TO_REMOVE_GLOBAL.computeIfAbsent(registry, r -> new Object2ObjectOpenHashMap());
        this.keyExtractor = keyExtractor;
    }

    @Override
    public void run() {
        HashMap<ResourceLocation, GTTagBuilder<T>> b = new HashMap<ResourceLocation, GTTagBuilder<T>>(this.builders);
        this.builders.clear();
        this.processTags(this.providerDomain);
        this.builders.forEach(this::addTag);
        this.builders.forEach((r, builder) -> {
            if (builder.removeElements.isEmpty()) {
                return;
            }
            List list = (List)this.TAGS_TO_REMOVE.computeIfAbsent(r, r2 -> new ArrayList());
            list.addAll(builder.removeElements);
        });
        this.builders.putAll(b);
    }

    protected abstract void processTags(String var1);

    @Override
    public boolean async() {
        return false;
    }

    public String m_6055_() {
        return this.providerName;
    }

    protected GTTagBuilder<T> tag(TagKey<T> tag) {
        return this.getOrCreateRawBuilder(tag);
    }

    protected GTTagBuilder<T> getOrCreateRawBuilder(TagKey<T> tag) {
        return this.builders.computeIfAbsent(tag.f_203868_(), location -> new GTTagBuilder<T>(new TagBuilder(), this.registry, this.providerDomain, this.keyExtractor));
    }

    public void addTag(ResourceLocation loc, JsonObject obj) {
        this.TAGS.put((Object)loc, (Object)obj);
    }

    public static JTag fromJson(JsonObject obj) {
        JTag tag = JTag.tag();
        if (obj.getAsJsonPrimitive("replace").getAsBoolean()) {
            tag.replace();
        }
        JsonArray array = obj.getAsJsonArray("values");
        array.forEach(e -> {
            if (e.isJsonPrimitive()) {
                String s = e.getAsString();
                if (s.contains("#")) {
                    tag.tag(new ResourceLocation(s.replace("#", "")));
                } else {
                    tag.add(new ResourceLocation(s));
                }
            }
        });
        return tag;
    }

    public void addTag(ResourceLocation loc, GTTagBuilder<T> obj) {
        JsonObject json = (JsonObject)this.TAGS.get((Object)loc);
        if (json == null) {
            this.addTag(loc, obj.serializeToJson());
        } else {
            obj = obj.addFromJson(json, "GTLib - Dynamic Data");
            this.addTag(loc, obj.serializeToJson());
        }
    }

    @Override
    public void onCompletion() {
        this.TAGS.forEach((k, v) -> {
            ResourceLocation fixed = GTLibDynamics.getTagLoc(this.prefix, k);
            JsonObject json = (JsonObject)TAGS_GLOBAL.get((Object)fixed);
            if (json != null) {
                JsonArray local = v.getAsJsonArray("values");
                JsonArray global = json.getAsJsonArray("values");
                global.forEach(arg_0 -> ((JsonArray)local).add(arg_0));
            }
            TAGS_GLOBAL.put((Object)fixed, v);
        });
        this.TAGS_TO_REMOVE.forEach((k, v) -> {
            Map map = (Map)TAGS_TO_REMOVE_GLOBAL.computeIfAbsent(this.registry, r -> new Object2ObjectOpenHashMap());
            List list = map.computeIfAbsent(k, k2 -> new ArrayList());
            list.addAll(v);
        });
    }

    public static void afterCompletion() {
        TAGS_GLOBAL.forEach((k, v) -> GTLibDynamics.RUNTIME_DATA_PACK.addTag(k, GTTagProvider.fromJson(v)));
    }
}

