/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.datagen.builder;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import net.devtech.arrp.json.blockstate.JBlockModel;
import net.devtech.arrp.json.blockstate.JMultipart;
import net.devtech.arrp.json.blockstate.JState;
import net.devtech.arrp.json.blockstate.JWhen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import org.gtreimagined.gtlib.datagen.builder.IModelLocation;
import org.gtreimagined.gtlib.datagen.builder.IStateBuilder;

public class MultiPartBlockStateBuilder
implements IStateBuilder {
    JState state = new JState();
    final Block owner;

    public MultiPartBlockStateBuilder(Block owner) {
        this.owner = owner;
    }

    @Override
    public JState toState() {
        return this.state;
    }

    public PartBuilder part() {
        PartBuilder builder = new PartBuilder(this);
        this.state.add(builder.multipart);
        return builder;
    }

    public static class PartBuilder {
        JMultipart multipart = new JMultipart();
        public MultiPartBlockStateBuilder owner;

        PartBuilder(MultiPartBlockStateBuilder owner) {
            this.owner = owner;
        }

        public ModelBuilder modelFile(IModelLocation model) {
            ModelBuilder builder = new ModelBuilder(this);
            builder.modelFile(model);
            return builder;
        }

        public ModelBuilder modelFile(ResourceLocation model) {
            ModelBuilder builder = new ModelBuilder(this);
            builder.modelFile(model);
            return builder;
        }

        public ModelBuilder model() {
            return new ModelBuilder(this);
        }

        public <T extends Comparable<T>> PartBuilder condition(Property<T> prop, T ... values) {
            JWhen when = new JWhen();
            ArrayList<String> valueList = new ArrayList<String>();
            for (T value : values) {
                valueList.add(prop.m_6940_(value));
            }
            when.add(prop.m_61708_(), valueList.toArray(new String[0]));
            this.multipart.when(when);
            return this;
        }

        public MultiPartBlockStateBuilder end() {
            return this.owner;
        }

        public static class ModelBuilder {
            JBlockModel model = null;
            final PartBuilder owner;

            public ModelBuilder(PartBuilder owner) {
                this.owner = owner;
            }

            public ModelBuilder modelFile(IModelLocation model) {
                Preconditions.checkNotNull((Object)model, (Object)"Model must not be null");
                this.model = new JBlockModel(model.getLocation());
                return this;
            }

            public ModelBuilder modelFile(ResourceLocation location) {
                Preconditions.checkNotNull((Object)location, (Object)"Model must not be null");
                this.model = new JBlockModel(location);
                return this;
            }

            public ModelBuilder rotationX(int value) {
                Preconditions.checkNotNull((Object)this.model, (Object)"modelFile must be called first");
                this.model.x(value);
                return this;
            }

            public ModelBuilder rotationY(int value) {
                Preconditions.checkNotNull((Object)this.model, (Object)"modelFile must be called first");
                this.model.y(value);
                return this;
            }

            public ModelBuilder uvLock() {
                Preconditions.checkNotNull((Object)this.model, (Object)"modelFile must be called first");
                this.model.uvlock();
                return this;
            }

            public ModelBuilder weight(int value) {
                Preconditions.checkNotNull((Object)this.model, (Object)"modelFile must be called first");
                this.model.weight(value);
                return this;
            }

            public PartBuilder addModel() {
                Preconditions.checkNotNull((Object)this.model, (Object)"modelFile must be called first");
                this.owner.multipart.addModel(this.model);
                return this.owner;
            }
        }
    }
}

