/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.datagen.builder;

import com.google.common.collect.ImmutableMap;
import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import org.gtreimagined.gtlib.datagen.builder.GTBlockModelBuilder;
import org.gtreimagined.gtlib.texture.Texture;
import org.jetbrains.annotations.Nullable;

public class DynamicConfigBuilder {
    protected String parent;
    protected ImmutableMap<String, String> textures = ImmutableMap.of();
    protected int[] rotations = new int[0];
    protected ResourceLocation loader;

    public DynamicConfigBuilder() {
    }

    public DynamicConfigBuilder(String parent) {
        this.parent = parent;
    }

    public DynamicConfigBuilder setTextures(ImmutableMap<String, String> map) {
        this.textures = map;
        return this;
    }

    public DynamicConfigBuilder[] list(DynamicConfigBuilder ... builders) {
        return builders;
    }

    public DynamicConfigBuilder of(ResourceLocation loc) {
        return this.of(loc.toString());
    }

    public DynamicConfigBuilder of(String parent) {
        return new DynamicConfigBuilder(parent);
    }

    public DynamicConfigBuilder tex(Texture ... textures) {
        this.textures = GTBlockModelBuilder.buildTextures(textures);
        return this;
    }

    @Nullable
    public ResourceLocation getLoader() {
        return this.loader;
    }

    public DynamicConfigBuilder tex(Function<ImmutableMap.Builder<String, Texture>, ImmutableMap.Builder<String, Texture>> func) {
        this.textures = GTBlockModelBuilder.buildTextures((ImmutableMap<String, Texture>)func.apply((ImmutableMap.Builder<String, Texture>)new ImmutableMap.Builder()).build());
        return this;
    }

    public DynamicConfigBuilder tex(ImmutableMap<String, Texture> map) {
        this.textures = GTBlockModelBuilder.buildTextures(map);
        return this;
    }

    public DynamicConfigBuilder rot(int x, int y, int z) {
        this.rotations = new int[]{x, y, z};
        return this;
    }

    public DynamicConfigBuilder loader(ResourceLocation loader) {
        this.loader = loader;
        return this;
    }

    public DynamicConfigBuilder rot(Direction dir) {
        switch (dir) {
            case NORTH: {
                this.rotations = new int[]{0, 180, 0};
                break;
            }
            case WEST: {
                this.rotations = new int[]{0, 270, 0};
                break;
            }
            case SOUTH: {
                this.rotations = new int[]{0, 0, 0};
                break;
            }
            case EAST: {
                this.rotations = new int[]{0, 90, 0};
            }
        }
        return this;
    }

    public boolean hasRots() {
        return this.rotations != null && this.rotations.length > 0;
    }
}

