/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.client.model;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import org.gtreimagined.gtlib.client.IGTModel;
import org.gtreimagined.gtlib.client.baked.BakedMachineSide;
import org.gtreimagined.gtlib.client.baked.CoverBakedModel;
import org.gtreimagined.gtlib.client.baked.GroupedBakedModel;

public class GTGroupedModel
implements IGTModel<GTGroupedModel> {
    final Map<String, IGTModel<?>> models;
    final ResourceLocation particle;

    public GTGroupedModel(ResourceLocation particle, Map<String, IGTModel<?>> models) {
        this.models = models;
        this.particle = particle;
    }

    @Override
    public BakedModel bakeModel(IGeometryBakingContext configuration, ModelBaker bakery, Function<Material, TextureAtlasSprite> getter, ModelState transform, ItemOverrides overrides, ResourceLocation loc) {
        ImmutableMap.Builder<String, BakedModel> builder = GTGroupedModel.buildParts(configuration, bakery, getter, transform, overrides, loc, this.models.entrySet());
        return new GroupedBakedModel(getter.apply(new Material(InventoryMenu.f_39692_, MissingTextureAtlasSprite.m_118071_())), (Map<String, BakedModel>)builder.build());
    }

    public void resolveParents(Function<ResourceLocation, UnbakedModel> modelGetter, IGeometryBakingContext context) {
        this.models.forEach((state, models) -> models.resolveParents(modelGetter, context));
    }

    protected static ImmutableMap.Builder<String, BakedModel> buildParts(IGeometryBakingContext configuration, ModelBaker bakery, Function<Material, TextureAtlasSprite> getter, ModelState transform, ItemOverrides overrides, ResourceLocation loc, Set<Map.Entry<String, IGTModel<?>>> entries) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<String, IGTModel<?>> entry : entries) {
            builder.put((Object)entry.getKey(), (Object)entry.getValue().bake(configuration, bakery, getter, transform, overrides, loc));
        }
        return builder;
    }

    public static class MachineSideModel
    extends GTGroupedModel {
        public MachineSideModel(GTGroupedModel model) {
            super(model.particle, model.models);
        }

        @Override
        public BakedModel bakeModel(IGeometryBakingContext configuration, ModelBaker bakery, Function<Material, TextureAtlasSprite> getter, ModelState transform, ItemOverrides overrides, ResourceLocation loc) {
            ImmutableMap.Builder<String, BakedModel> builder = MachineSideModel.buildParts(configuration, bakery, getter, transform, overrides, loc, this.models.entrySet());
            return new BakedMachineSide(getter.apply(new Material(InventoryMenu.f_39692_, MissingTextureAtlasSprite.m_118071_())), (Map<String, BakedModel>)builder.build());
        }
    }

    public static class CoverModel
    extends GTGroupedModel {
        public CoverModel(GTGroupedModel model) {
            super(model.particle, model.models);
        }

        @Override
        public BakedModel bakeModel(IGeometryBakingContext configuration, ModelBaker bakery, Function<Material, TextureAtlasSprite> getter, ModelState transform, ItemOverrides overrides, ResourceLocation loc) {
            ImmutableMap.Builder<String, BakedModel> builder = CoverModel.buildParts(configuration, bakery, getter, transform, overrides, loc, this.models.entrySet());
            return new CoverBakedModel(getter.apply(new Material(InventoryMenu.f_39692_, MissingTextureAtlasSprite.m_118071_())), (Map<String, BakedModel>)builder.build());
        }
    }
}

