/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.client.baked;

import com.google.common.collect.ImmutableMap;
import com.mojang.math.Transformation;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.gtreimagined.gtlib.GTLibProperties;
import org.gtreimagined.gtlib.Ref;
import org.gtreimagined.gtlib.blockentity.BlockEntityMachine;
import org.gtreimagined.gtlib.capability.CoverHandler;
import org.gtreimagined.gtlib.client.DirectionalQuadTransformer;
import org.gtreimagined.gtlib.client.ModelUtils;
import org.gtreimagined.gtlib.client.RenderHelper;
import org.gtreimagined.gtlib.client.baked.GTBakedModel;
import org.gtreimagined.gtlib.client.dynamic.DynamicTexturer;
import org.gtreimagined.gtlib.client.quad.ITextureReferenceBakedQuad;
import org.gtreimagined.gtlib.client.quad.RetexturedBakedQuad;
import org.gtreimagined.gtlib.cover.ICover;
import org.gtreimagined.gtlib.machine.MachineState;
import org.gtreimagined.gtlib.machine.types.Machine;
import org.gtreimagined.gtlib.texture.Texture;
import org.gtreimagined.gtlib.util.Utils;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class MachineBakedModel
extends GTBakedModel<MachineBakedModel> {
    private final ImmutableMap<MachineState, BakedModel[]> sides;

    public MachineBakedModel(TextureAtlasSprite particle, ImmutableMap<MachineState, BakedModel[]> sides) {
        super(particle);
        this.sides = sides;
    }

    protected List<BakedQuad> getCoverQuads(BlockState state, Direction side, RandomSource rand, GTLibProperties.MachineProperties data, BlockEntityMachine<?> machine, BlockAndTintGetter level, BlockPos pos) {
        ICover cover = data.covers[side.m_122411_()];
        if (cover.isEmpty()) {
            return Collections.emptyList();
        }
        Texture tex = machine.getMultiTexture() != null ? machine.getMultiTexture().apply(side) : data.machTexture.apply(side);
        Object list = new ObjectArrayList();
        list = data.coverTexturer.apply(side).getQuads("cover", (List<BakedQuad>)list, state, cover, new ICover.DynamicKey(state, tex, cover.getId()), side.m_122411_(), level, pos);
        return list;
    }

    @Override
    public List<BakedQuad> getBlockQuads(BlockState state, Direction side, RandomSource rand, BlockAndTintGetter level, @NotNull BlockPos pos) {
        if (side == null) {
            return Collections.emptyList();
        }
        BlockEntity tile = level.m_7702_(pos);
        if (!(tile instanceof BlockEntityMachine)) {
            return Collections.emptyList();
        }
        BlockEntityMachine machine = (BlockEntityMachine)tile;
        GTLibProperties.MachineProperties props = this.getMachineProperty(machine);
        if (props == null) {
            return Collections.emptyList();
        }
        ObjectArrayList quads = new ObjectArrayList(20);
        List<BakedQuad> coverQuads = this.getCoverQuads(state, side, rand, props, machine, level, pos);
        if (!coverQuads.isEmpty()) {
            return coverQuads;
        }
        BakedModel model = this.getModel(state, side, props.state, props.type);
        for (Direction dir : Ref.DIRS) {
            quads.addAll(ModelUtils.getQuadsFromBaked(model, state, dir, rand, level, pos));
        }
        quads.addAll(ModelUtils.getQuadsFromBaked(model, state, null, rand, level, pos));
        if (machine.getMultiTexture() != null) {
            for (int i = 0; i < quads.size(); ++i) {
                ITextureReferenceBakedQuad textureReferenceBakedQuad;
                BakedQuad quad = (BakedQuad)quads.get(i);
                if (!(quad instanceof ITextureReferenceBakedQuad) || !(textureReferenceBakedQuad = (ITextureReferenceBakedQuad)quad).gtLib$getTextureId().equals("#base")) continue;
                TextureAtlasSprite sprite = ModelUtils.getDefaultTextureGetter().apply(ModelUtils.getBlockMaterial(machine.getMultiTexture().apply(side)));
                quads.set(i, new RetexturedBakedQuad(quad, sprite));
            }
        }
        if (props.type.isNoFacing() || props.type.isNoTextureRotation()) {
            return quads;
        }
        Matrix4f f = new Matrix4f();
        f.identity();
        Transformation mat = new Transformation(f);
        mat = mat.blockCornerToCenter();
        mat = mat.m_121096_(RenderHelper.faceRotation(state));
        mat = mat.blockCenterToCorner();
        DirectionalQuadTransformer transformer = new DirectionalQuadTransformer(mat);
        return transformer.processMany((List<BakedQuad>)quads, side);
    }

    public BakedModel getModel(BlockState state, Direction dir, MachineState m, Machine<?> type) {
        if (type.isNoFacing() || type.isNoTextureRotation()) {
            return ((BakedModel[])this.sides.get((Object)m))[dir.m_122411_()];
        }
        Direction facing = RenderHelper.directionFromState(state);
        return ((BakedModel[])this.sides.get((Object)m))[Utils.rotateModel(facing, dir).m_122411_()];
    }

    public GTLibProperties.MachineProperties getMachineProperty(BlockEntityMachine<?> machine) {
        ICover[] covers = machine.coverHandler.map(CoverHandler::getAllRendered).orElse(new ICover[]{ICover.empty, ICover.empty, ICover.empty, ICover.empty, ICover.empty, ICover.empty});
        Machine<?> m = machine.getMachineType();
        Function<Direction, Texture> mText = a -> {
            Texture[] tex = machine.getMachineType().getBaseTexture(machine.getMachineTier(), machine.getMachineState().getTextureState());
            if (tex.length == 1) {
                return tex[0];
            }
            return tex[a.m_122411_()];
        };
        MachineState st = machine.getMachineState().getTextureState();
        Function<Direction, DynamicTexturer<ICover, ICover.DynamicKey>> tx = a -> machine.coverHandler.map(t -> t.getTexturer((Direction)a)).orElse(null);
        GTLibProperties.MachineProperties mh = new GTLibProperties.MachineProperties(m, machine.getMachineTier(), covers, st, mText, tx);
        return mh;
    }

    public boolean m_7541_() {
        return false;
    }

    public boolean m_7539_() {
        return true;
    }

    public boolean m_7547_() {
        return true;
    }

    public boolean m_7521_() {
        return true;
    }

    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }
}

