/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.client;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import org.gtreimagined.gtlib.client.RenderHelper;
import org.gtreimagined.gtlib.mixin.client.VertexFormatAccessor;

public class VertexTransformer {
    private static final int UV = VertexTransformer.findUVOffset(DefaultVertexFormat.f_85811_);
    private static final int COLOR = VertexTransformer.findColorOffset(DefaultVertexFormat.f_85811_);

    public static void processVertices(int[] inData, int[] outData, BakedQuad old, int color, TextureAtlasSprite sprite) {
        int stride = DefaultVertexFormat.f_85811_.m_86020_();
        int count = inData.length * 4 / stride;
        for (int i = 0; i < count; ++i) {
            float u_old = Float.intBitsToFloat(inData[i * stride / 4 + UV]);
            float v_old = Float.intBitsToFloat(inData[i * stride / 4 + UV + 1]);
            float u = (u_old - old.m_173410_().m_118409_()) * 16.0f / (old.m_173410_().m_118410_() - old.m_173410_().m_118409_());
            float v = (v_old - old.m_173410_().m_118411_()) * 16.0f / (old.m_173410_().m_118412_() - old.m_173410_().m_118411_());
            outData[i * stride / 4 + VertexTransformer.UV] = Float.floatToIntBits(sprite.m_118367_((double)u));
            outData[i * stride / 4 + VertexTransformer.UV + 1] = Float.floatToIntBits(sprite.m_118393_((double)v));
            outData[i * stride / 4 + VertexTransformer.COLOR] = RenderHelper.convertRGB2ABGR(color);
        }
    }

    private static int findUVOffset(VertexFormat fmt) {
        int index;
        VertexFormatElement element = null;
        for (index = 0; index < fmt.m_86023_().size(); ++index) {
            VertexFormatElement el = (VertexFormatElement)fmt.m_86023_().get(index);
            if (el.m_86048_() != VertexFormatElement.Usage.UV) continue;
            element = el;
            break;
        }
        if (index == fmt.m_86023_().size() || element == null) {
            throw new IllegalStateException("BLOCK format does not have normals?");
        }
        return ((VertexFormatAccessor)fmt).getOffsets().getInt(index) / 4;
    }

    private static int findColorOffset(VertexFormat fmt) {
        int index;
        VertexFormatElement element = null;
        for (index = 0; index < fmt.m_86023_().size(); ++index) {
            VertexFormatElement el = (VertexFormatElement)fmt.m_86023_().get(index);
            if (el.m_86048_() != VertexFormatElement.Usage.COLOR) continue;
            element = el;
            break;
        }
        if (index == fmt.m_86023_().size() || element == null) {
            throw new IllegalStateException("BLOCK format does not have normals?");
        }
        return ((VertexFormatAccessor)fmt).getOffsets().getInt(index) / 4;
    }

    public static List<BakedQuad> processMany(List<BakedQuad> inputs, int color, TextureAtlasSprite sprite) {
        if (inputs.size() == 0) {
            return Collections.emptyList();
        }
        ObjectArrayList outputs = new ObjectArrayList(inputs.size());
        for (BakedQuad input : inputs) {
            int[] inData = input.m_111303_();
            int[] outData = Arrays.copyOf(inData, inData.length);
            VertexTransformer.processVertices(inData, outData, input, color, sprite);
            outputs.add(new BakedQuad(outData, input.m_111305_(), input.m_111306_(), sprite, false));
        }
        return outputs;
    }
}

