/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.blockentity.single;

import java.util.List;
import java.util.function.LongFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.gtreimagined.gtlib.blockentity.BlockEntityMachine;
import org.gtreimagined.gtlib.capability.machine.MachineEnergyHandler;
import org.gtreimagined.gtlib.data.GTTools;
import org.gtreimagined.gtlib.machine.MachineState;
import org.gtreimagined.gtlib.machine.types.Machine;
import org.gtreimagined.gtlib.tool.GTToolType;
import org.gtreimagined.gtlib.util.Utils;
import org.gtreimagined.tesseract.api.eu.IEnergyHandler;

public class BlockEntityTransformer<T extends BlockEntityTransformer<T>>
extends BlockEntityMachine<T> {
    protected long voltage;
    protected int amperage;
    protected LongFunction<Long> capFunc;

    public BlockEntityTransformer(Machine<?> type, BlockPos pos, BlockState state, int amps) {
        this(type, pos, state, amps, v -> 512L + v * 8L);
    }

    public BlockEntityTransformer(Machine<?> type, BlockPos pos, BlockState state, int amps, LongFunction<Long> capFunc) {
        super(type, pos, state);
        this.amperage = amps;
        this.capFunc = capFunc;
        this.energyHandler.set(() -> new MachineEnergyHandler<T>(this, 0L, (Long)capFunc.apply(this.getMachineTier().getVoltage()), this.getMachineTier().getVoltage() * 4L, this.getMachineTier().getVoltage(), this.amperage, this.amperage * 4){

            @Override
            public boolean canOutput(Direction direction) {
                return BlockEntityTransformer.this.isDefaultMachineState() == (((BlockEntityTransformer)this.tile).getFacing().m_122411_() != direction.m_122411_());
            }

            @Override
            public boolean canInput(Direction direction) {
                return !this.canOutput(direction);
            }
        });
    }

    @Override
    public InteractionResult onInteractServer(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit, GTToolType type) {
        if (type == GTTools.SOFT_HAMMER && hand == InteractionHand.MAIN_HAND) {
            this.toggleMachine();
            this.energyHandler.ifPresent(h -> {
                long temp = h.getOutputAmperage();
                h.setOutputAmperage(h.getInputAmperage());
                h.setInputAmperage(temp);
                temp = h.getOutputVoltage();
                h.setOutputVoltage(h.getInputVoltage());
                h.setInputVoltage(temp);
                this.invalidateCap(IEnergyHandler.class);
                player.m_5661_((Component)Utils.literal((this.isDefaultMachineState() ? "Step Down, In: " : "Step Up, In") + h.getInputVoltage() + "V@" + h.getInputAmperage() + "Amp, Out: " + h.getOutputVoltage() + "V@" + h.getOutputAmperage() + "Amp"), false);
            });
            return InteractionResult.SUCCESS;
        }
        return super.onInteractServer(state, world, pos, player, hand, hit, type);
    }

    @Override
    public void onFirstTickServer(Level level, BlockPos pos, BlockState state) {
        super.onFirstTickServer(level, pos, state);
        this.voltage = this.getMachineTier().getVoltage();
    }

    @Override
    public MachineState getDefaultMachineState() {
        return MachineState.ACTIVE;
    }

    @Override
    public List<String> getInfo(boolean simple) {
        List<String> info = super.getInfo(simple);
        this.energyHandler.ifPresent(h -> {
            info.add("Voltage In: " + h.getInputVoltage());
            info.add("Voltage Out: " + h.getOutputVoltage());
            info.add("Amperage In: " + h.getInputAmperage());
            info.add("Amperage Out: " + h.getOutputAmperage());
        });
        return info;
    }
}

