/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.blockentity.single;

import it.unimi.dsi.fastutil.Pair;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import org.gtreimagined.gtlib.blockentity.BlockEntityMachine;
import org.gtreimagined.gtlib.capability.item.TrackedItemHandler;
import org.gtreimagined.gtlib.capability.machine.MachineEnergyHandler;
import org.gtreimagined.gtlib.capability.machine.MachineItemHandler;
import org.gtreimagined.gtlib.gui.SlotType;
import org.gtreimagined.gtlib.machine.event.IMachineEvent;
import org.gtreimagined.gtlib.machine.types.Machine;
import org.gtreimagined.gtlib.util.Utils;
import org.gtreimagined.tesseract.api.eu.IEnergyHandler;
import org.gtreimagined.tesseract.api.eu.IEnergyHandlerItem;

public class BlockEntityBatteryBuffer<T extends BlockEntityBatteryBuffer<T>>
extends BlockEntityMachine<T> {
    public BlockEntityBatteryBuffer(Machine<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.energyHandler.set(() -> new MachineEnergyHandler<T>(this, 0L, this.getMachineTier().getVoltage() * (long)this.itemHandler.map(m -> m.getChargeHandler().getSlots()).orElse(1).intValue(), this.getMachineTier().getVoltage(), this.getMachineTier().getVoltage(), 1, 0){

            @Override
            public boolean canOutput(Direction direction) {
                Direction dir = ((BlockEntityBatteryBuffer)this.tile).getFacing();
                return dir != null && dir.m_122411_() == direction.m_122411_();
            }

            @Override
            public void onMachineEvent(IMachineEvent event, Object ... data) {
                super.onMachineEvent(event, data);
            }

            @Override
            public void onUpdate() {
                super.onUpdate();
                if (this.energy > 0L && this.getEnergy() > this.voltageOut * 2L && !this.cachedItems.isEmpty()) {
                    long energyToInsert = this.energy % (long)this.cachedItems.size() == 0L ? this.energy / (long)this.cachedItems.size() : this.energy;
                    this.cachedItems.forEach(h -> {
                        long toAdd = Math.min(this.energy, Math.min(energyToInsert, ((IEnergyHandlerItem)h.right()).getCapacity() - ((IEnergyHandlerItem)h.right()).getEnergy()));
                        if (toAdd > 0L && Utils.addEnergy((IEnergyHandler)h.right(), toAdd)) {
                            ((ItemStack)h.left()).m_41751_(((IEnergyHandlerItem)h.right()).getContainer().getTag());
                            this.energy -= toAdd;
                        }
                    });
                }
                if (this.energy < this.voltageOut && this.getBatteryEnergy() < this.voltageOut) {
                    this.cachedItems.forEach(h -> {
                        long toRemove = Math.min(this.capacty - this.energy, ((IEnergyHandlerItem)h.right()).getEnergy());
                        if (toRemove > 0L && Utils.removeEnergy((IEnergyHandler)h.right(), toRemove)) {
                            ((ItemStack)h.left()).m_41751_(((IEnergyHandlerItem)h.right()).getContainer().getTag());
                            this.energy += toRemove;
                        }
                    });
                }
            }

            @Override
            public long getInputAmperage() {
                if (this.cachedItems != null && !this.cachedItems.isEmpty()) {
                    return this.cachedItems.stream().map(Pair::right).mapToLong(IEnergyHandler::getInputAmperage).sum();
                }
                return 0L;
            }

            @Override
            public long getOutputAmperage() {
                if (this.cachedItems != null && !this.cachedItems.isEmpty()) {
                    return this.cachedItems.stream().map(Pair::right).mapToLong(IEnergyHandler::getOutputAmperage).sum();
                }
                return super.getOutputAmperage();
            }
        });
        this.itemHandler.set(() -> new MachineItemHandler<T>(this){

            @Override
            protected TrackedItemHandler<T> createTrackedHandler(SlotType<?> type, T tile) {
                int count = ((BlockEntityMachine)tile).getMachineType().getCount(((BlockEntityMachine)tile).getMachineTier(), type);
                if (type == SlotType.ENERGY) {
                    return new TrackedItemHandler(tile, type, count, true, type.input, type.tester);
                }
                return super.createTrackedHandler(type, tile);
            }
        });
    }

    @Override
    public List<String> getInfo(boolean simple) {
        List<String> info = super.getInfo(simple);
        this.energyHandler.ifPresent(h -> {
            info.add("Amperage In: " + h.availableAmpsInput(this.getMaxInputVoltage()));
            info.add("Amperage Out: " + h.availableAmpsOutput());
        });
        return info;
    }
}

