/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.blockentity;

import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.gtreimagined.gtlib.blockentity.BlockEntityMachine;
import org.gtreimagined.gtlib.capability.fluid.FluidTanks;
import org.gtreimagined.gtlib.capability.machine.MachineFluidHandler;
import org.gtreimagined.gtlib.cover.CoverOutput;
import org.gtreimagined.gtlib.cover.ICover;
import org.gtreimagined.gtlib.integration.xei.renderer.IInfoRenderer;
import org.gtreimagined.gtlib.machine.types.Machine;
import org.gtreimagined.gtlib.machine.types.TankMachine;
import org.gtreimagined.gtlib.util.FluidUtils;
import org.jetbrains.annotations.Nullable;

public class BlockEntityTank<T extends BlockEntityMachine<T>>
extends BlockEntityMachine<T>
implements IInfoRenderer<TankMachine.TankRenderWidget> {
    public BlockEntityTank(Machine<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        int n;
        if (type instanceof TankMachine) {
            TankMachine tankMachine = (TankMachine)type;
            n = tankMachine.getCapacityPerTier().apply(this.tier);
        } else {
            n = 8000 * (1 + this.tier.getIntegerId());
        }
        int capacity = n;
        this.fluidHandler.set(() -> new MachineFluidHandler<T>(this, capacity){

            @Override
            @Nullable
            public FluidTanks getOutputTanks() {
                return super.getInputTanks();
            }

            @Override
            protected FluidTank getTank(int tank) {
                return this.getInputTanks().getTank(tank);
            }

            @Override
            public FluidTanks getTanks(int tank) {
                return this.getInputTanks();
            }
        });
    }

    @Override
    public int drawInfo(TankMachine.TankRenderWidget instance, GuiGraphics graphics, Font font, int left, int top) {
        left += 55;
        top += 24;
        if (instance.stack.isEmpty()) {
            graphics.m_280488_(font, "Empty", left, top, 0xFAFAFF);
            return 8;
        }
        graphics.m_280488_(font, FluidUtils.getFluidDisplayName(instance.stack).getString(), left, top, 0xFAFAFF);
        String fluidAmount = String.valueOf(instance.stack.getAmount());
        graphics.m_280488_(font, fluidAmount + " mb", left, top + 8, 0xFAFAFF);
        return 16;
    }

    private String intToSuperScript(int i) {
        String intString = String.valueOf(i);
        StringBuilder builder = new StringBuilder();
        for (char c : intString.toCharArray()) {
            builder.append(this.charToSuperScript(c));
        }
        return builder.toString();
    }

    private String charToSuperScript(char c) {
        return switch (c) {
            case '0' -> "\u2070";
            case '1' -> "\u00b9";
            case '2' -> "\u00b2";
            case '3' -> "\u00b3";
            case '4' -> "\u2074";
            case '5' -> "\u2075";
            case '6' -> "\u2076";
            case '7' -> "\u2077";
            case '8' -> "\u2078";
            case '9' -> "\u2079";
            default -> String.valueOf(c);
        };
    }

    @Override
    public void onFirstTickServer(Level level, BlockPos pos, BlockState state) {
        super.onFirstTickServer(level, pos, state);
        this.setAutoOutput();
    }

    protected void setAutoOutput() {
        this.coverHandler.ifPresent(t -> {
            ICover cover = t.getOutputCover();
            if (!(cover instanceof CoverOutput)) {
                return;
            }
            CoverOutput output = (CoverOutput)cover;
            output.setEjects(this.has("fluid"), this.has("item"));
        });
    }
}

