/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.block;

import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.gtreimagined.gtlib.block.BlockBasic;
import org.gtreimagined.gtlib.material.IMaterialObject;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.material.MaterialType;
import org.gtreimagined.gtlib.registration.IColorHandler;
import org.gtreimagined.gtlib.texture.Texture;
import org.jetbrains.annotations.Nullable;

public class BlockMaterialType
extends BlockBasic
implements IColorHandler,
IMaterialObject {
    protected Material material;
    protected MaterialType<?> type;
    protected String textureFolder = "";

    public BlockMaterialType(String domain, Material material, MaterialType<?> type, BlockBehaviour.Properties properties) {
        super(domain, type.getIdGetter().apply(material), properties);
        this.material = material;
        this.type = type;
    }

    public BlockMaterialType instancedTextures(String folder) {
        this.textureFolder = folder;
        return this;
    }

    @Override
    public int getBlockColor(BlockState state, @Nullable BlockGetter world, @Nullable BlockPos pos, int i) {
        return i == 0 ? this.material.getRGB() : -1;
    }

    @Override
    public int getItemColor(ItemStack stack, @Nullable Block block, int i) {
        return i == 0 ? this.material.getRGB() : -1;
    }

    @Override
    public Texture[] getTextures() {
        Texture[] textureArray;
        if (!this.textureFolder.isEmpty()) {
            Texture[] textureArray2 = new Texture[1];
            textureArray = textureArray2;
            textureArray2[0] = new Texture(this.domain, "block/" + this.textureFolder + "/" + this.material.getId());
        } else {
            textureArray = this.material.getSet().getTextures(this.type);
        }
        return textureArray;
    }

    @Override
    @Generated
    public Material getMaterial() {
        return this.material;
    }

    @Generated
    public MaterialType<?> getType() {
        return this.type;
    }
}

