/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import org.gtreimagined.gtlib.machine.Tier;
import org.gtreimagined.gtlib.machine.types.Machine;

public class GTRemapping {
    private static final Map<String, Map<String, ResourceLocation>> REMAPPING_MAP = new Object2ObjectArrayMap();
    private static final Map<ResourceLocation, ResourceLocation> BE_REMAPPING_MAP = new Object2ObjectArrayMap();
    private static final List<Function<ResourceLocation, ResourceLocation>> BE_REMAPPING_LIST = new ArrayList<Function<ResourceLocation, ResourceLocation>>();
    private static final Map<ResourceLocation, ResourceLocation> COVER_REMAPPING_MAP = new Object2ObjectArrayMap();

    public static void remapMachine(ResourceLocation old, Machine<?> machine) {
        BE_REMAPPING_MAP.put(old, machine.getLoc());
        machine.getTiers().forEach(t -> {
            String suffix = t == Tier.NONE ? "" : "_" + t.getId();
            REMAPPING_MAP.computeIfAbsent(old.m_135827_(), o -> new Object2ObjectArrayMap()).put(old.m_135815_() + suffix, new ResourceLocation(machine.getDomain(), machine.getIdFromTier((Tier)t)));
        });
    }

    public static void remapMachine(String old, Machine<?> machine) {
        BE_REMAPPING_MAP.put(new ResourceLocation(machine.getDomain(), old), machine.getLoc());
        machine.getTiers().forEach(t -> {
            String suffix = t == Tier.NONE ? "" : "_" + t.getId();
            REMAPPING_MAP.computeIfAbsent(machine.getDomain(), o -> new Object2ObjectArrayMap()).put(old + suffix, new ResourceLocation(machine.getDomain(), machine.getIdFromTier((Tier)t)));
        });
    }

    public static void remap(String modid, String oldId, String newId) {
        REMAPPING_MAP.computeIfAbsent(modid, o -> new Object2ObjectArrayMap()).put(oldId, new ResourceLocation(modid, newId));
    }

    public static void remap(ResourceLocation oldId, ResourceLocation newId) {
        REMAPPING_MAP.computeIfAbsent(oldId.m_135827_(), o -> new Object2ObjectArrayMap()).put(oldId.m_135815_(), newId);
    }

    public static void remapBlockEntity(ResourceLocation oldId, ResourceLocation newId) {
        BE_REMAPPING_MAP.put(oldId, newId);
    }

    public static void remapCover(ResourceLocation oldId, ResourceLocation newId) {
        COVER_REMAPPING_MAP.put(oldId, newId);
    }

    public static Map<ResourceLocation, ResourceLocation> getBeRemappingMap() {
        return BE_REMAPPING_MAP;
    }

    public static Map<ResourceLocation, ResourceLocation> getCoverRemappingMap() {
        return COVER_REMAPPING_MAP;
    }

    public static Map<String, Map<String, ResourceLocation>> getRemappingMap() {
        return REMAPPING_MAP;
    }

    public static List<Function<ResourceLocation, ResourceLocation>> getBeRemappingFunctionList() {
        return BE_REMAPPING_LIST;
    }

    static {
        BE_REMAPPING_LIST.add(r -> {
            if (BE_REMAPPING_MAP.containsKey(r)) {
                return BE_REMAPPING_MAP.get(r);
            }
            return null;
        });
    }
}

