/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.worldgen.feature;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import org.gtreimagined.gtlib.GTLibConfig;
import org.gtreimagined.gtlib.block.BlockSurfaceRock;
import org.gtreimagined.gtlib.data.GTMaterialTypes;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.material.MaterialTypeBlock;
import org.gtreimagined.gtlib.ore.BlockOreStone;
import org.gtreimagined.gtlib.ore.StoneType;
import org.gtreimagined.gtlib.worldgen.GTLibConfiguredFeatures;
import org.gtreimagined.gtlib.worldgen.NoiseGenerator;
import org.gtreimagined.gtlib.worldgen.WorldGenHelper;
import org.gtreimagined.gtlib.worldgen.feature.GTFeature;
import org.gtreimagined.gtlib.worldgen.stonelayer.StoneLayer;
import org.gtreimagined.gtlib.worldgen.stonelayer.StoneLayerData;
import org.gtreimagined.gtlib.worldgen.stonelayer.StoneLayerOre;
import org.gtreimagined.gtlib.worldgen.stonelayer.StoneLayerRestrictions;

public class FeatureStoneLayer
extends GTFeature<NoneFeatureConfiguration> {
    public FeatureStoneLayer() {
        super(NoneFeatureConfiguration.f_67815_, StoneLayer.class);
    }

    @Override
    public String getId() {
        return "stone_layers";
    }

    @Override
    public boolean enabled() {
        return GTLibConfig.STONE_LAYERS.get() && !StoneLayerData.INSTANCE.getVeins().isEmpty();
    }

    @Override
    public void init() {
    }

    @Override
    public void build(ResourceLocation name, Biome.ClimateSettings climate, BiomeSpecialEffects effects, BiomeGenerationSettings.Builder gen, MobSpawnSettings.Builder spawns) {
        gen.m_204201_(GenerationStep.Decoration.RAW_GENERATION, GTLibConfiguredFeatures.STONE_LAYERS);
    }

    /*
     * Could not resolve type clashes
     */
    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> ctxt) {
        WorldGenLevel world = ctxt.m_159774_();
        BlockPos pos = ctxt.m_159777_();
        RandomSource rand = ctxt.m_225041_();
        List<StoneLayer> stones = StoneLayerData.INSTANCE.getFlat((Level)world.m_6018_());
        if (stones.isEmpty()) {
            return false;
        }
        StoneLayer[] layers = new StoneLayer[7];
        NoiseGenerator noise = new NoiseGenerator(world);
        int stonesSize = stones.size();
        int stonesMax = stonesSize - 1;
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                int tX = pos.m_123341_() + i;
                int tZ = pos.m_123343_() + j;
                layers[0] = stones.get(Math.min(stonesMax, (int)((noise.get(tX, -2.0f, tZ) + 1.0f) / 2.0f * (float)stonesSize)));
                layers[1] = stones.get(Math.min(stonesMax, (int)((noise.get(tX, -1.0f, tZ) + 1.0f) / 2.0f * (float)stonesSize)));
                layers[2] = stones.get(Math.min(stonesMax, (int)((noise.get(tX, 0.0f, tZ) + 1.0f) / 2.0f * (float)stonesSize)));
                layers[3] = stones.get(Math.min(stonesMax, (int)((noise.get(tX, 1.0f, tZ) + 1.0f) / 2.0f * (float)stonesSize)));
                layers[4] = stones.get(Math.min(stonesMax, (int)((noise.get(tX, 2.0f, tZ) + 1.0f) / 2.0f * (float)stonesSize)));
                layers[5] = stones.get(Math.min(stonesMax, (int)((noise.get(tX, 3.0f, tZ) + 1.0f) / 2.0f * (float)stonesSize)));
                layers[6] = stones.get(Math.min(stonesMax, (int)((noise.get(tX, 4.0f, tZ) + 1.0f) / 2.0f * (float)stonesSize)));
                StoneType topStoneType = null;
                boolean placedRock = false;
                int maxHeight = world.m_5452_(Heightmap.Types.OCEAN_FLOOR_WG, pos.m_7918_(i, 0, j)).m_123342_() + 1;
                int minHeight = world.m_141937_();
                for (int tY = -63; tY < maxHeight; ++tY) {
                    int offsetY = tY + 64;
                    Material lastMaterial = null;
                    BlockPos offset = pos.m_7918_(i, offsetY, j);
                    BlockState existing = world.m_8055_(offset);
                    boolean isAir = existing.m_60795_();
                    StoneType rockType = null;
                    boolean setStone = false;
                    if (!isAir && existing.m_60734_() != layers[3].block()) {
                        int y = offset.m_123342_();
                        StoneLayerRestrictions restrictions = layers[3].restrictions();
                        Block toPlace = layers[3].block();
                        StoneType type = layers[3].type();
                        if (y >= restrictions.maxY() && restrictions.maxY() < maxHeight && restrictions.topReplacement() != Blocks.f_50016_ && !this.placeReplacement(y, restrictions.maxY(), restrictions.maxY() + 8, rand)) {
                            toPlace = restrictions.topReplacement();
                            type = restrictions.topReplacementStone();
                        }
                        if (restrictions.minY() > minHeight && y <= restrictions.minY() + 8 && restrictions.bottomReplacement() != Blocks.f_50016_ && this.placeReplacement(y, restrictions.minY(), restrictions.minY() + 8, rand)) {
                            toPlace = restrictions.bottomReplacement();
                            type = restrictions.bottomReplacementStone();
                        }
                        if (WorldGenHelper.setStone((LevelAccessor)world, offset, existing, toPlace.m_49966_())) {
                            setStone = true;
                            if (toPlace instanceof BlockOreStone) {
                                BlockOreStone stone = (BlockOreStone)toPlace;
                                Block block = ((MaterialTypeBlock.IBlockGetter)GTMaterialTypes.ROCK.get()).get(stone.getMaterial()).asBlock();
                                if (block instanceof BlockSurfaceRock) {
                                    BlockSurfaceRock surfaceRock = (BlockSurfaceRock)block;
                                    topStoneType = rockType = surfaceRock.getStoneType();
                                }
                            } else {
                                Material material = lastMaterial = type != null ? type.getMaterial() : null;
                                if (type != null) {
                                    topStoneType = type;
                                }
                            }
                        }
                    }
                    if (setStone && GTLibConfig.STONE_LAYER_ORES.get()) {
                        if (layers[1] == layers[5]) {
                            for (Object ore : layers[3].ores()) {
                                if (!((StoneLayerOre)ore).canPlace(offset, rand, (LevelAccessor)world) || !WorldGenHelper.addOre((LevelAccessor)world, offset, ((StoneLayerOre)ore).material(), layers[0] == layers[6])) continue;
                                lastMaterial = ((StoneLayerOre)ore).material();
                                break;
                            }
                        } else {
                            StoneType type;
                            StoneType stoneType = type = layers[3].type() != null ? layers[3].type() : rockType;
                            if (type != null && type.doesGenerateOre()) {
                                Object ore;
                                ore = StoneLayer.getCollision(type, layers[5].block().m_49966_(), layers[1].block().m_49966_()).iterator();
                                while (ore.hasNext()) {
                                    StoneLayerOre ore2 = (StoneLayerOre)ore.next();
                                    if (!ore2.canPlace(offset, rand, (LevelAccessor)world) || !WorldGenHelper.addOre((LevelAccessor)world, offset, ore2.material(), true)) continue;
                                    lastMaterial = ore2.material();
                                    break;
                                }
                            }
                        }
                    }
                    if (!placedRock && lastMaterial != null && lastMaterial.has(GTMaterialTypes.ORE) && lastMaterial.has(GTMaterialTypes.BEARING_ROCK)) {
                        BlockState below = world.m_8055_(offset.m_7918_(0, -1, 0));
                        int y = Math.min(world.m_6924_(Heightmap.Types.OCEAN_FLOOR, offset.m_123341_(), offset.m_123343_()), world.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, offset.m_123341_(), offset.m_123343_()));
                        if (!below.m_60795_() && below != WorldGenHelper.WATER_STATE && GTLibConfig.STONE_LAYER_ORE_ROCKS.get() && GTLibConfig.SURFACE_ROCKS.get() && WorldGenHelper.setRock((LevelAccessor)world, offset.m_122032_().m_142448_(y).m_7949_(), lastMaterial, below, GTLibConfig.STONE_LAYER_ORE_ROCK_CHANCE.get())) {
                            placedRock = true;
                        }
                    }
                    if (!placedRock && rockType != null) {
                        BlockState below = world.m_8055_(offset.m_7918_(0, -1, 0));
                        int y = Math.min(world.m_6924_(Heightmap.Types.OCEAN_FLOOR, offset.m_123341_(), offset.m_123343_()), world.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, offset.m_123341_(), offset.m_123343_()));
                        if (!below.m_60795_() && below != WorldGenHelper.WATER_STATE && GTLibConfig.STONE_LAYER_DENSE_ORE_ROCKS.get() && GTLibConfig.SURFACE_ROCKS.get() && WorldGenHelper.setRock((LevelAccessor)world, offset.m_122032_().m_142448_(y).m_7949_(), Material.NULL, rockType.getState(), GTLibConfig.STONE_LAYER_DENSE_ORE_ROCK_CHANCE.get())) {
                            placedRock = true;
                        }
                    }
                    System.arraycopy(layers, 1, layers, 0, layers.length - 1);
                    layers[6] = stones.get(Math.min(stonesMax, (int)((noise.get(tX, offsetY + 4, tZ) + 1.0f) / 2.0f * (float)stonesSize)));
                }
                if (placedRock || topStoneType == null) continue;
                BlockPos offset = pos.m_7918_(i, 0, j);
                int y = Math.min(world.m_6924_(Heightmap.Types.OCEAN_FLOOR, offset.m_123341_(), offset.m_123343_()), world.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, offset.m_123341_(), offset.m_123343_()));
                BlockState below = world.m_8055_((BlockPos)offset.m_122032_().m_142448_(y - 1));
                if (below.m_60795_() || below == WorldGenHelper.WATER_STATE || !GTLibConfig.STONE_LAYER_ROCKS.get() || !GTLibConfig.SURFACE_ROCKS.get()) continue;
                WorldGenHelper.setRock((LevelAccessor)world, offset.m_122032_().m_142448_(y).m_7949_(), Material.NULL, topStoneType.getState(), GTLibConfig.STONE_LAYER_ROCK_CHANCE.get());
            }
        }
        return true;
    }

    public boolean placeReplacement(int y, int bottom, int top, RandomSource random) {
        if (y <= bottom) {
            return true;
        }
        if (y >= top) {
            return false;
        }
        double d0 = Mth.m_144914_((double)y, (double)bottom, (double)top, (double)1.0, (double)0.0);
        return (double)random.m_188501_() < d0;
    }
}

