/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.tool;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.Ref;
import org.gtreimagined.gtlib.behaviour.IBehaviour;
import org.gtreimagined.gtlib.behaviour.IDestroySpeed;
import org.gtreimagined.gtlib.capability.energy.ItemEnergyHandler;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.tool.GTItemTier;
import org.gtreimagined.gtlib.tool.GTToolType;
import org.gtreimagined.gtlib.tool.IGTTool;
import org.gtreimagined.tesseract.api.context.TesseractItemContext;
import org.gtreimagined.tesseract.api.eu.IEnergyHandlerItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
public class MaterialSword
extends SwordItem
implements IGTTool {
    protected String domain;
    protected GTToolType type;
    protected GTItemTier itemTier;
    protected int energyTier;
    protected long maxEnergy;

    public MaterialSword(String domain, GTToolType type, GTItemTier tier, Item.Properties properties) {
        super((Tier)GTItemTier.NULL, 0, type.getBaseAttackSpeed(), properties);
        this.domain = domain;
        this.type = type;
        this.itemTier = tier;
        this.energyTier = -1;
        this.maxEnergy = -1L;
        GTAPI.register(IGTTool.class, this);
    }

    public MaterialSword(String domain, GTToolType type, GTItemTier tier, Item.Properties properties, int energyTier) {
        super((Tier)GTItemTier.NULL, (int)type.getBaseAttackDamage(), type.getBaseAttackSpeed(), properties);
        this.domain = domain;
        this.type = type;
        this.itemTier = tier;
        this.energyTier = energyTier;
        this.maxEnergy = type.getBaseMaxEnergy() * (long)energyTier;
        GTAPI.register(IGTTool.class, this);
    }

    @Override
    public String getId() {
        if (this.type.isSimple()) {
            return this.type.isPowered() ? String.join((CharSequence)"_", this.itemTier.getPrimary().getId(), this.type.getId(), Ref.VN[this.energyTier].toLowerCase(Locale.ENGLISH)) : String.join((CharSequence)"_", this.itemTier.getPrimary().getId(), this.type.getId());
        }
        return this.type.isPowered() ? String.join((CharSequence)"_", this.type.getId(), Ref.VN[this.energyTier].toLowerCase(Locale.ENGLISH)) : this.type.getId();
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    @Override
    @NotNull
    public GTToolType getGTToolType() {
        return this.type;
    }

    @Override
    public GTItemTier getGTItemTier() {
        return this.itemTier;
    }

    @Override
    @NotNull
    public ItemStack asItemStack(@NotNull Material primary, @NotNull Material secondary) {
        return this.resolveStack(primary, secondary, 0L, this.maxEnergy);
    }

    public boolean doesSneakBypassUse(ItemStack stack, LevelReader world, BlockPos pos, Player player) {
        return false;
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> list) {
        this.onGenericFillItemGroup(group, list, this.maxEnergy);
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        this.onGenericAddInformation(stack, tooltip, flag);
        super.m_7373_(stack, world, tooltip, flag);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return this.type.getUseAction();
    }

    public int m_8105_(ItemStack stack) {
        return this.type.getUseAction() == UseAnim.NONE ? super.m_8105_(stack) : 72000;
    }

    @Override
    public int getMaxDamage(ItemStack stack) {
        return this.getTier(stack).m_6609_();
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        return this.onGenericHitEntity(stack, target, attacker, 0.75f, 0.75f);
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        float destroySpeed;
        float f = destroySpeed = this.genericIsCorrectToolForDrops(stack, state) ? this.getDefaultMiningSpeed(stack) : 1.0f;
        if (this.type.isPowered() && this.getCurrentEnergy(stack) == 0L) {
            destroySpeed = 0.0f;
        }
        for (Map.Entry e : this.getGTToolType().getBehaviours().entrySet()) {
            IDestroySpeed destroySpeed1;
            float i;
            IBehaviour b = (IBehaviour)e.getValue();
            if (!(b instanceof IDestroySpeed) || !((i = (destroySpeed1 = (IDestroySpeed)b).getDestroySpeed(this, destroySpeed, stack, state)) > 0.0f)) continue;
            destroySpeed = i;
            break;
        }
        return destroySpeed;
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        return this.genericIsCorrectToolForDrops(stack, state);
    }

    public boolean m_6813_(ItemStack stack, Level world, BlockState state, BlockPos pos, LivingEntity entity) {
        return this.onGenericBlockDestroyed(stack, world, state, pos, entity);
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        return this.onGenericItemUse(ctx);
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity interactionTarget, InteractionHand usedHand) {
        return this.genericInteractLivingEntity(stack, player, interactionTarget, usedHand);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        InteractionResultHolder result = this.onGenericRightclick(level, player, usedHand);
        if (result.m_19089_().m_146666_()) {
            return result;
        }
        return super.m_7203_(level, player, usedHand);
    }

    public boolean m_6777_(BlockState state, Level world, BlockPos pos, Player player) {
        return this.type.getBlockBreakability();
    }

    @Override
    public boolean canDisableShield(ItemStack stack, ItemStack shield, LivingEntity entity, LivingEntity attacker) {
        return this.type.getToolTypes().contains(BlockTags.f_144280_);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slotType, ItemStack stack) {
        HashMultimap modifiers = HashMultimap.create();
        if (slotType == EquipmentSlot.MAINHAND) {
            modifiers.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)(this.type.getBaseAttackDamage() + this.getTier(stack).m_6631_()), AttributeModifier.Operation.ADDITION));
            modifiers.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)this.type.getBaseAttackSpeed(), AttributeModifier.Operation.ADDITION));
        }
        return modifiers;
    }

    @Override
    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return entity instanceof Player && ((Player)entity).m_7500_() ? 0 : this.damage(stack, amount);
    }

    public int getEnchantmentValue(ItemStack stack) {
        return this.getTier(stack).m_6601_();
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return !this.type.isPowered() && this.getTier(toRepair).m_6282_().test(repair);
    }

    public boolean m_8120_(ItemStack stack) {
        return true;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (this.type.getBlacklistedEnchantments().contains(enchantment)) {
            return false;
        }
        return this.type.isPowered() ? enchantment != Enchantments.f_44986_ : enchantment.f_44672_.m_7454_(stack.m_41720_());
    }

    public boolean hasCraftingRemainingItem(ItemStack stack) {
        return this.type.hasContainer();
    }

    public ItemStack getCraftingRemainingItem(ItemStack oldStack) {
        return this.getGenericContainerItem(oldStack);
    }

    public IEnergyHandlerItem createEnergyHandler(TesseractItemContext context) {
        return new ItemEnergyHandler(context, this.maxEnergy, (long)(8 * (int)Math.pow(4.0, this.energyTier)), (long)(8 * (int)Math.pow(4.0, this.energyTier)), 1, 1);
    }

    @Override
    @Generated
    public int getEnergyTier() {
        return this.energyTier;
    }
}

