/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.material;

import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.material.MaterialItem;
import org.gtreimagined.gtlib.material.MaterialType;
import org.gtreimagined.gtlib.recipe.ingredient.RecipeIngredient;
import org.gtreimagined.gtlib.util.Utils;

public class MaterialTypeItem<T>
extends MaterialType<T> {
    private final ItemSupplier itemSupplier;

    public MaterialTypeItem(String id, int layers, boolean visible, long unitValue) {
        super(id, layers, visible, unitValue);
        GTAPI.register(MaterialTypeItem.class, this);
        this.itemSupplier = MaterialItem::new;
    }

    public MaterialTypeItem(String id, int layers, boolean visible, long unitValue, ItemSupplier itemSupplier) {
        super(id, layers, visible, unitValue);
        GTAPI.register(MaterialTypeItem.class, this);
        this.itemSupplier = itemSupplier;
    }

    @Override
    public MaterialTypeItem<T> unSplitName() {
        return (MaterialTypeItem)super.unSplitName();
    }

    public boolean allowItemGen(Material material) {
        return !this.replacements.containsKey((Object)material) && this.allowGen(material) && !this.blockType;
    }

    public Item get(Material material) {
        Item replacement = GTAPI.getReplacement(this, material, new String[0]);
        if (replacement == null) {
            if (!this.allowItemGen(material)) {
                Utils.onInvalidData(String.join((CharSequence)"", "GET ERROR - DOES NOT GENERATE: T(", this.id, ") M(", material.getId(), ")"));
            } else {
                return GTAPI.get(MaterialItem.class, (String)this.idGetter.apply(material));
            }
        }
        return replacement;
    }

    public ItemSupplier getSupplier() {
        return this.itemSupplier;
    }

    public ItemStack get(Material material, int count) {
        if (count < 1) {
            Utils.onInvalidData(String.join((CharSequence)"", "GET ERROR - MAT STACK EMPTY: T(", this.id, ") M(", material.getId(), ")"));
        }
        return new ItemStack((ItemLike)this.get(material), count);
    }

    public RecipeIngredient getIngredient(Material material, int count) {
        if (count < 1) {
            Utils.onInvalidData(String.join((CharSequence)"", "GET ERROR - MAT STACK EMPTY: T(", this.id, ") M(", material.getId(), ")"));
        }
        return RecipeIngredient.of(this.getMaterialTag(material), count);
    }

    @Override
    public void onRegistryBuild(ResourceKey<? extends Registry<?>> registry) {
        super.onRegistryBuild(registry);
        if (registry != ForgeRegistries.Keys.BLOCKS) {
            return;
        }
        if (this.doRegister()) {
            for (Material material : this.materials) {
                if (!material.enabled || !this.allowItemGen(material)) continue;
                this.getSupplier().createItems(material.materialDomain(), this, material);
            }
        }
    }

    public static interface ItemSupplier {
        public void createItems(String var1, MaterialType<?> var2, Material var3);
    }
}

