/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.item;

import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import lombok.Generated;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidStack;
import org.gtreimagined.gtlib.client.GTTextureStitcher;
import org.gtreimagined.gtlib.datagen.builder.GTItemModelBuilder;
import org.gtreimagined.gtlib.datagen.providers.GTItemModelProvider;
import org.gtreimagined.gtlib.item.IFluidItem;
import org.gtreimagined.gtlib.item.ItemBasic;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.material.MaterialTags;
import org.gtreimagined.gtlib.mixin.BucketItemAccessor;
import org.gtreimagined.gtlib.util.FluidUtils;
import org.gtreimagined.gtlib.util.TagUtils;
import org.gtreimagined.gtlib.util.Utils;
import org.jetbrains.annotations.Nullable;

public class ItemFluidCell
extends ItemBasic<ItemFluidCell>
implements IFluidItem {
    public final Material material;
    private final int capacity;
    private final Fluid stack;
    private static final String TAG_FLUID = "Fluid";

    public ItemFluidCell(String domain, Material material, int capacity) {
        super(domain, material.getId() + "_cell");
        GTTextureStitcher.addStitcher(t -> {
            t.accept(new ResourceLocation(domain, "item/other/" + this.getId() + "_cover"));
            t.accept(new ResourceLocation(domain, "item/other/" + this.getId() + "_fluid"));
        });
        this.material = material;
        this.capacity = capacity;
        this.stack = Fluids.f_76191_;
    }

    public int getMaxTemp() {
        return MaterialTags.MELTING_POINT.getInt(this.material);
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (worldIn == null) {
            return;
        }
        stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(x -> {
            FluidStack fluid = x.getFluidInTank(0);
            if (!fluid.isEmpty()) {
                MutableComponent fluidname = (MutableComponent)FluidUtils.getFluidDisplayName(fluid);
                fluidname.m_130946_(": ").m_7220_((Component)Utils.literal(NumberFormat.getNumberInstance(Locale.US).format(fluid.getAmount()) + " mB").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)fluidname);
            }
            tooltip.add((Component)Utils.literal("Max Temp: " + ((ItemFluidCell)stack.m_41720_()).getMaxTemp() + "K"));
        });
    }

    public static TagKey<Item> getTag() {
        return TagUtils.getItemTag(new ResourceLocation("gtlib", "cell"));
    }

    public Fluid getFluid() {
        return this.stack;
    }

    protected boolean hasFluid(ItemStack container) {
        return !this.getFluidStack(container).isEmpty();
    }

    public boolean hasCraftingRemainingItem(ItemStack stack) {
        return this.hasFluid(stack);
    }

    public ItemStack getCraftingRemainingItem(ItemStack itemStack) {
        return new ItemStack((ItemLike)this);
    }

    @Override
    public Predicate<FluidStack> getFilter() {
        return f -> FluidUtils.getFluidTemperature(f.getFluid()) <= this.getMaxTemp();
    }

    public InteractionResult m_6225_(UseOnContext ctxt) {
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack;
        FluidStack fluid = this.getFluidStack(stack = player.m_21120_(hand));
        BlockHitResult trace = ItemFluidCell.m_41435_((Level)world, (Player)player, (ClipContext.Fluid)(fluid.getAmount() + 1000 <= this.capacity ? ClipContext.Fluid.SOURCE_ONLY : ClipContext.Fluid.NONE));
        InteractionResultHolder ret = ForgeEventFactory.onBucketUse((Player)player, (Level)world, (ItemStack)stack, (HitResult)trace);
        if (ret != null) {
            return ret;
        }
        if (trace.m_6662_() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        BlockPos pos = trace.m_82425_();
        Direction direction = trace.m_82434_();
        BlockPos offset = pos.m_121945_(direction);
        if (world.m_7966_(player, pos) && player.m_36204_(offset, direction, stack)) {
            BlockState state = world.m_8055_(pos);
            Block block = state.m_60734_();
            if ((fluid.isEmpty() || fluid.getAmount() + 1000 <= this.capacity) && block instanceof BucketPickup) {
                ItemStack bucket = ((BucketPickup)block).m_142598_((LevelAccessor)world, pos, state);
                if (!bucket.m_41619_()) {
                    Fluid newFluid = ((BucketItemAccessor)bucket.m_41720_()).getContent();
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                    SoundEvent sound = FluidUtils.getFillSound(newFluid);
                    if (sound == null) {
                        sound = newFluid.m_205067_(FluidTags.f_13132_) ? SoundEvents.f_11783_ : SoundEvents.f_11781_;
                    }
                    player.m_5496_(sound, 1.0f, 1.0f);
                    ItemStack newStack = ItemFluidCell.updateCell(stack, player, this.fill(newFluid, fluid.getAmount() + 1000));
                    if (!world.m_5776_()) {
                        CriteriaTriggers.f_10576_.m_38772_((ServerPlayer)player, newStack.m_41777_());
                    }
                    return InteractionResultHolder.m_19090_((Object)newStack);
                }
            } else if (fluid.getAmount() >= 1000) {
                BlockPos fluidPos;
                BlockPos blockPos = fluidPos = state.m_60734_() instanceof LiquidBlockContainer && fluid.getFluid() == Fluids.f_76193_ ? pos : offset;
                if (this.tryPlaceContainedLiquid(player, world, fluidPos, stack, trace)) {
                    ItemFluidCell.onLiquidPlaced(player, fluid.getFluid(), world, stack, fluidPos);
                    if (player instanceof ServerPlayer) {
                        CriteriaTriggers.f_10591_.m_59469_((ServerPlayer)player, fluidPos, stack);
                    }
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                    ItemStack newStack = this.drain(Utils.ca(1, stack), new FluidStack(fluid.getFluid(), 1000));
                    if (stack.m_41613_() > 1) {
                        stack.m_41774_(1);
                        ItemFluidCell.addItem(player, newStack);
                        return InteractionResultHolder.m_19090_((Object)stack);
                    }
                    return InteractionResultHolder.m_19090_((Object)newStack);
                }
            }
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    private static void onLiquidPlaced(Player player, Fluid fluid, Level world, ItemStack stack, BlockPos pos) {
        Item item = fluid.m_6859_();
        if (item instanceof BucketItem) {
            ((BucketItem)item).m_142131_(player, world, stack, pos);
        }
    }

    private boolean tryPlaceContainedLiquid(@Nullable Player player, Level world, BlockPos pos, ItemStack stack, @Nullable BlockHitResult trace) {
        FluidStack fluidStack = this.getFluidStack(stack);
        Fluid fluid = fluidStack.getFluid();
        if (!(fluid instanceof FlowingFluid)) {
            return false;
        }
        BlockState state = world.m_8055_(pos);
        Block block = state.m_60734_();
        boolean replaceable = state.m_60722_(fluid);
        if (state.m_60795_() || replaceable || block instanceof LiquidBlockContainer && ((LiquidBlockContainer)block).m_6044_((BlockGetter)world, pos, state, fluid)) {
            if (world.m_6042_().f_63857_() && fluid.m_205067_(FluidTags.f_13131_)) {
                world.m_5594_(player, pos, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.5f, 2.6f + (world.f_46441_.m_188501_() - world.f_46441_.m_188501_()) * 0.8f);
                for (int l = 0; l < 8; ++l) {
                    world.m_7106_((ParticleOptions)ParticleTypes.f_123755_, (double)pos.m_123341_() + Math.random(), (double)pos.m_123342_() + Math.random(), (double)pos.m_123343_() + Math.random(), 0.0, 0.0, 0.0);
                }
            } else if (block instanceof LiquidBlockContainer && fluid == Fluids.f_76193_) {
                if (((LiquidBlockContainer)block).m_7361_((LevelAccessor)world, pos, state, ((FlowingFluid)fluid).m_76068_(false))) {
                    this.playEmptySound(fluid, player, (LevelAccessor)world, pos);
                }
            } else {
                if (!world.m_5776_() && replaceable && !state.m_60767_().m_76332_()) {
                    world.m_46961_(pos, true);
                }
                this.playEmptySound(fluid, player, (LevelAccessor)world, pos);
                world.m_7731_(pos, fluid.m_76145_().m_76188_(), 11);
            }
            return true;
        }
        if (trace == null) {
            return false;
        }
        return this.tryPlaceContainedLiquid(player, world, trace.m_82425_().m_121945_(trace.m_82434_()), stack, null);
    }

    private void playEmptySound(Fluid fluid, @Nullable Player player, LevelAccessor world, BlockPos pos) {
        SoundEvent sound = FluidUtils.getEmptySound(fluid);
        if (sound == null) {
            sound = fluid.m_205067_(FluidTags.f_13132_) ? SoundEvents.f_11780_ : SoundEvents.f_11778_;
        }
        world.m_5594_(player, pos, sound, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    public static InteractionResult interactWithCauldron(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, ItemStack stack) {
        if (world.f_46443_) {
            return InteractionResult.PASS;
        }
        ItemFluidCell cell = (ItemFluidCell)stack.m_41720_();
        FluidStack fluid = cell.getFluidStack(stack);
        int level = (Integer)state.m_61143_((Property)LayeredCauldronBlock.f_153514_);
        Block block = state.m_60734_();
        if (block instanceof AbstractCauldronBlock) {
            ItemStack newStack;
            AbstractCauldronBlock cauldron = (AbstractCauldronBlock)block;
            if (level < 3 && !cell.hasFluid(stack)) {
                if (player != null) {
                    player.m_36220_(Stats.f_12944_);
                }
                if (!world.m_5776_()) {
                    LayeredCauldronBlock.m_153559_((BlockState)state, (Level)world, (BlockPos)pos);
                }
                world.m_5594_(null, pos, SoundEvents.f_11781_, SoundSource.BLOCKS, 1.0f, 1.0f);
                newStack = cell.getCraftingRemainingItem(cell.fill((Fluid)Fluids.f_76193_, 1000));
                if (stack.m_41613_() > 1) {
                    stack.m_41774_(1);
                    ItemFluidCell.addItem(player, newStack);
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.SUCCESS;
            }
            if (fluid.getFluid().m_6212_((Fluid)Fluids.f_76193_)) {
                if (level < 3) {
                    if (player != null) {
                        player.m_36220_(Stats.f_12943_);
                    }
                    if (!world.f_46443_) {
                        world.m_46597_(pos, (BlockState)state.m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(level + 1)));
                    }
                    world.m_5594_(null, pos, SoundEvents.f_11778_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    newStack = cell.drain(Utils.ca(1, stack), new FluidStack(fluid.getFluid(), 1000));
                    if (stack.m_41613_() > 1) {
                        stack.m_41774_(1);
                        ItemFluidCell.addItem(player, newStack);
                        return InteractionResult.SUCCESS;
                    }
                    return InteractionResult.SUCCESS;
                }
            } else {
                return InteractionResult.PASS;
            }
        }
        return InteractionResult.PASS;
    }

    protected static ItemStack updateCell(ItemStack originalStack, Player player, ItemStack newCell) {
        if (player.m_7500_()) {
            return originalStack;
        }
        originalStack.m_41774_(1);
        if (originalStack.m_41619_()) {
            return newCell;
        }
        ItemFluidCell.addItem(player, newCell);
        return originalStack;
    }

    protected static void addItem(Player player, ItemStack stack) {
        if (!player.m_150109_().m_36054_(stack)) {
            player.m_36176_(stack, false);
        }
    }

    @Override
    public void onItemModelBuild(ItemLike item, GTItemModelProvider prov) {
        ((GTItemModelBuilder)prov.getGTBuilder(item).bucketProperties(this.stack, true, false).parent(new ResourceLocation("gtlib:item/bucket"))).tex(map -> {
            map.put("base", this.getDomain() + ":item/basic/" + this.getId());
            map.put("cover", this.getDomain() + ":item/other/" + this.getId() + "_cover");
            map.put("fluid", this.getDomain() + ":item/other/" + this.getId() + "_fluid");
        });
    }

    @Override
    @Generated
    public int getCapacity() {
        return this.capacity;
    }
}

