/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.item;

import java.util.List;
import java.util.Optional;
import lombok.Generated;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.gtreimagined.gtlib.capability.energy.ItemEnergyHandler;
import org.gtreimagined.gtlib.item.ItemBasic;
import org.gtreimagined.gtlib.machine.Tier;
import org.gtreimagined.gtlib.util.Utils;
import org.gtreimagined.tesseract.api.context.TesseractItemContext;
import org.gtreimagined.tesseract.api.eu.IEnergyHandler;
import org.gtreimagined.tesseract.api.eu.IEnergyHandlerItem;
import org.gtreimagined.tesseract.api.eu.IEnergyItem;
import org.gtreimagined.tesseract.api.forge.TesseractCaps;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemBattery
extends ItemBasic<ItemBattery>
implements IEnergyItem {
    protected Tier tier;
    protected final long cap;
    protected final int amps;
    protected final boolean reusable;

    public ItemBattery(String domain, String id, Tier tier, long cap, boolean reusable) {
        this(domain, id, tier, cap, 1, reusable);
    }

    public ItemBattery(String domain, String id, Tier tier, long cap, int amps, boolean reusable) {
        super(domain, id);
        this.tier = tier;
        this.cap = cap;
        this.amps = amps;
        this.reusable = reusable;
    }

    public long getCapacity() {
        return this.cap;
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (this.m_220152_(group)) {
            ItemStack stack = new ItemStack((ItemLike)this);
            items.add((Object)stack.m_41777_());
            items.add((Object)ItemBattery.getFilledBattery(this));
        }
    }

    public static ItemStack getFilledBattery(ItemBasic<?> item) {
        ItemStack stack = item.m_7968_();
        if (!(item instanceof ItemBattery)) {
            return stack;
        }
        ItemBattery battery = (ItemBattery)item;
        stack.m_41698_("ied").m_128356_("e", battery.cap);
        return stack;
    }

    public int m_142159_(ItemStack stack) {
        long energy = stack.m_41698_("ied").m_128454_("e");
        if (energy <= 0L) {
            return super.m_142159_(stack);
        }
        return 49151;
    }

    public boolean m_142522_(ItemStack stack) {
        return true;
    }

    public int m_142158_(ItemStack stack) {
        return (int)(13.0 * ((double)stack.m_41698_("ied").m_128454_("e") / (double)this.cap));
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!world.m_5776_() && player.m_6047_()) {
            boolean newMode = this.chargeModeSwitch(stack);
            player.m_5661_((Component)Utils.translatable(newMode ? "message.discharge.on" : "message.discharge.off", new Object[0]), false);
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    private boolean canDischarge(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt == null || !nbt.m_128441_("ied")) {
            return true;
        }
        CompoundTag energyTag = nbt.m_128469_("ied");
        if (!energyTag.m_128441_("idm")) {
            return true;
        }
        return energyTag.m_128471_("idm");
    }

    public boolean chargeModeSwitch(ItemStack stack) {
        boolean discharge = !this.canDischarge(stack);
        CompoundTag energyTag = stack.m_41698_("ied");
        energyTag.m_128379_("idm", discharge);
        return discharge;
    }

    private static Optional<ItemEnergyHandler> getCastedHandler(ItemStack stack) {
        Optional itemHandler = stack.getCapability(TesseractCaps.ENERGY_HANDLER_CAPABILITY_ITEM).resolve();
        return itemHandler.map(e -> (ItemEnergyHandler)e);
    }

    @Override
    public void m_7373_(@NotNull ItemStack stack, @Nullable Level worldIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        tooltip.add((Component)Utils.translatable("gtlib.tooltip.battery.tier", Utils.literal(this.tier.getId().toUpperCase()).m_130940_(this.tier.getRarityFormatting())));
        if (this.reusable) {
            tooltip.add((Component)Utils.translatable("item.reusable", new Object[0]));
        }
        if (this.amps > 1) {
            boolean red = worldIn == null || worldIn.m_46467_() % 20L < 10L;
            tooltip.add((Component)Utils.translatable("item.amps", this.amps).m_130940_(red ? ChatFormatting.DARK_RED : ChatFormatting.WHITE));
        }
        long energy = stack.getCapability(TesseractCaps.ENERGY_HANDLER_CAPABILITY_ITEM).map(IEnergyHandler::getEnergy).orElse(0L);
        tooltip.add((Component)Utils.translatable("item.charge", new Object[0]).m_130946_(": ").m_7220_((Component)Utils.literal(energy + "/" + this.cap).m_130940_(energy == 0L ? ChatFormatting.RED : ChatFormatting.GREEN)).m_130946_(" (" + this.tier.getId().toUpperCase() + ")"));
        super.m_7373_(stack, worldIn, tooltip, flag);
    }

    public IEnergyHandlerItem createEnergyHandler(TesseractItemContext context) {
        return new ItemEnergyHandler(context, this.cap, this.isReusable() ? this.tier.getVoltage() : 0L, this.tier.getVoltage(), this.reusable ? 2 : 0, this.amps);
    }

    public int getMaxStackSize(ItemStack stack) {
        long energy;
        if (stack.m_41783_() != null && (energy = stack.m_41698_("ied").m_128454_("e")) > 0L) {
            return 1;
        }
        return super.getMaxStackSize(stack);
    }

    @Generated
    public Tier getTier() {
        return this.tier;
    }

    @Generated
    public boolean isReusable() {
        return this.reusable;
    }
}

