/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.integration.rei.category;

import com.google.common.collect.ImmutableList;
import dev.architectury.fluid.FluidStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.gtreimagined.gtlib.integration.rei.REIUtils;
import org.gtreimagined.gtlib.integration.xei.GTLibXEIPlugin;
import org.gtreimagined.gtlib.recipe.IRecipe;
import org.gtreimagined.gtlib.recipe.ingredient.RecipeIngredient;
import org.gtreimagined.gtlib.recipe.map.RecipeMap;
import org.gtreimagined.gtlib.util.FluidUtils;
import org.gtreimagined.gtlib.util.Utils;
import org.jetbrains.annotations.Nullable;

public class RecipeMapDisplay
implements Display {
    private final CategoryIdentifier<RecipeMapDisplay> id;
    private final List<EntryIngredient> input;
    private final List<EntryIngredient> output;
    private final IRecipe recipe;

    public RecipeMapDisplay(IRecipe recipe) {
        this.id = CategoryIdentifier.of((String)"gt", (String)recipe.getMapId());
        this.recipe = recipe;
        List<EntryIngredient> fluidInputs = RecipeMapDisplay.createFluidInputEntries(recipe.getInputFluids().stream().map(fluidIngredient -> Arrays.stream(fluidIngredient.getStacks()).map(REIUtils::toREIFLuidStack).toList()).toList());
        List<EntryIngredient> itemInputs = RecipeMapDisplay.createInputEntries(recipe.getInputItems(), recipe);
        this.input = new ArrayList<EntryIngredient>(itemInputs);
        this.input.addAll(fluidInputs);
        ImmutableList.Builder builder = ImmutableList.builder();
        ItemStack[] stacks = recipe.getOutputItems(false);
        if (stacks != null) {
            builder.addAll(RecipeMapDisplay.createOutputEntries(Arrays.asList(stacks), recipe));
        }
        if (recipe.getOutputFluids() != null) {
            builder.addAll(RecipeMapDisplay.createFluidOutputEntries(Arrays.stream(recipe.getOutputFluids()).map(REIUtils::toREIFLuidStack).toList(), recipe));
        }
        this.output = builder.build();
    }

    public static List<EntryIngredient> createOutputEntries(List<ItemStack> input, IRecipe recipe) {
        AtomicInteger atomicInteger = new AtomicInteger(0);
        return input.stream().map(i -> {
            int chance = recipe.hasOutputChances() ? Objects.requireNonNull(recipe.getOutputChances())[atomicInteger.getAndIncrement()] : 10000;
            return EntryStacks.of((ItemStack)i).setting(EntryStack.Settings.TOOLTIP_APPEND_EXTRA, f -> {
                ArrayList<Object> components = new ArrayList<Object>();
                Component c = RecipeMapDisplay.getProbabilityTooltip(chance, false);
                if (c != null) {
                    components.add(c);
                }
                if (recipe.m_6423_() != null) {
                    boolean showAdvanced;
                    components.add(Utils.literal("Recipe by: ").m_7220_((Component)Utils.literal(Utils.getModName(recipe.m_6423_().m_135827_())).m_130944_(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.ITALIC})));
                    Minecraft minecraft = Minecraft.m_91087_();
                    boolean bl = showAdvanced = minecraft.f_91066_.f_92125_ || Screen.m_96638_();
                    if (showAdvanced) {
                        components.add(Utils.literal("Recipe Id: " + recipe.m_6423_().toString()).m_130940_(ChatFormatting.DARK_GRAY));
                    }
                }
                return components;
            });
        }).map(EntryIngredient::of).toList();
    }

    public static List<EntryIngredient> createFluidOutputEntries(List<FluidStack> input, IRecipe recipe) {
        return input.stream().map(i -> {
            EntryStack fluidStackEntryStack = EntryStacks.of((FluidStack)i);
            fluidStackEntryStack.setting(EntryStack.Settings.TOOLTIP_PROCESSOR, (entry, t) -> {
                RecipeMapDisplay.createFluidTooltip(t, (FluidStack)fluidStackEntryStack.getValue());
                if (recipe.m_6423_() != null) {
                    boolean showAdvanced;
                    t.add((Component)Utils.literal("Recipe by: ").m_7220_((Component)Utils.literal(Utils.getModName(recipe.m_6423_().m_135827_())).m_130944_(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.ITALIC})));
                    Minecraft minecraft = Minecraft.m_91087_();
                    boolean bl = showAdvanced = minecraft.f_91066_.f_92125_ || Screen.m_96638_();
                    if (showAdvanced) {
                        t.add((Component)Utils.literal("Recipe Id: " + recipe.m_6423_().toString()).m_130940_(ChatFormatting.DARK_GRAY));
                    }
                }
                return t;
            });
            return fluidStackEntryStack;
        }).map(EntryIngredient::of).toList();
    }

    public static List<EntryIngredient> createFluidInputEntries(List<List<FluidStack>> input) {
        return input.stream().map(i -> {
            List<EntryStack> fluidStackEntryStack = i.stream().map(EntryStacks::of).toList();
            fluidStackEntryStack.stream().forEach(e -> e.setting(EntryStack.Settings.TOOLTIP_PROCESSOR, (entry, t) -> {
                RecipeMapDisplay.createFluidTooltip(t, (FluidStack)e.getValue());
                return t;
            }));
            return fluidStackEntryStack;
        }).map(EntryIngredient::of).toList();
    }

    private static void createFluidTooltip(Tooltip tooltip, FluidStack stack) {
        Tooltip.Entry component = (Tooltip.Entry)tooltip.entries().get(2);
        tooltip.entries().remove(2);
        tooltip.entries().remove(1);
        long mb = stack.getAmount();
        tooltip.add((Component)Utils.translatable("gtlib.tooltip.fluid.amount", mb + " L").m_130940_(ChatFormatting.BLUE));
        tooltip.add((Component)Utils.translatable("gtlib.tooltip.fluid.temp", FluidUtils.getFluidTemperature(stack.getFluid())).m_130940_(ChatFormatting.RED));
        String liquid = !FluidUtils.isFluidGaseous(stack.getFluid()) ? "liquid" : "gas";
        tooltip.add((Component)Utils.translatable("gtlib.tooltip.fluid." + liquid, new Object[0]).m_130940_(ChatFormatting.GREEN));
        tooltip.add(component.getAsText());
    }

    public static List<EntryIngredient> createInputEntries(List<Ingredient> input, IRecipe recipe) {
        AtomicInteger atomicInteger = new AtomicInteger(0);
        return input.stream().map(i -> {
            int chance = recipe.hasOutputChances() ? Objects.requireNonNull(recipe.getOutputChances())[atomicInteger.getAndIncrement()] : 10000;
            List<EntryStack> entry = Arrays.stream(i.m_43908_()).map(EntryStacks::of).toList();
            if (i instanceof RecipeIngredient) {
                RecipeIngredient ri = (RecipeIngredient)((Object)i);
                entry.forEach(e -> e.setting(EntryStack.Settings.TOOLTIP_APPEND_EXTRA, f -> {
                    ArrayList<Object> components = new ArrayList<Object>();
                    Component c = RecipeMapDisplay.getProbabilityTooltip(chance, true);
                    if (c != null) {
                        components.add(c);
                    }
                    if (ri.ignoreConsume()) {
                        components.add(Utils.literal("Does not get consumed in the process.").m_130940_(ChatFormatting.WHITE));
                    }
                    if (ri.ignoreNbt()) {
                        components.add(Utils.literal("Ignores NBT.").m_130940_(ChatFormatting.WHITE));
                    }
                    if (RecipeMap.isIngredientSpecial(i)) {
                        components.add(Utils.literal("Special ingredient. Class name: ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Utils.literal(i.getClass().getSimpleName()).m_130940_(ChatFormatting.GOLD)));
                    }
                    return components;
                }));
            }
            return entry;
        }).map(EntryIngredient::of).toList();
    }

    public static Component getProbabilityTooltip(int probability, boolean input) {
        if (probability == 10000) {
            return null;
        }
        MutableComponent text = Utils.literal((input ? "Consumption" : "Output") + " Chance: " + (float)probability / 100.0f + "%");
        text.m_130940_(ChatFormatting.WHITE);
        return text;
    }

    private static Function<EntryStack<?>, List<Component>> getFluidSetting(FluidStack fluidStack) {
        @Nullable MutableComponent tooltip = Utils.literal(fluidStack.getAmount() / 81L + " " + GTLibXEIPlugin.intToSuperScript(fluidStack.getAmount() % 81L) + "/\u2088\u2081 mb");
        return arg_0 -> RecipeMapDisplay.lambda$getFluidSetting$11((Component)tooltip, arg_0);
    }

    public List<EntryIngredient> getInputEntries() {
        return this.input;
    }

    public List<EntryIngredient> getOutputEntries() {
        return this.output;
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return this.id;
    }

    public IRecipe getRecipe() {
        return this.recipe;
    }

    private static /* synthetic */ List lambda$getFluidSetting$11(Component tooltip, EntryStack es) {
        return List.of(tooltip);
    }
}

