/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.integration.ponder;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import net.createmod.ponder.api.registration.StoryBoardEntry;
import net.createmod.ponder.api.scene.Selection;
import net.createmod.ponder.foundation.PonderStoryBoardEntry;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.gtreimagined.gtlib.datagen.GTLibDynamics;
import org.gtreimagined.gtlib.machine.BlockMultiMachine;
import org.gtreimagined.gtlib.machine.Tier;
import org.gtreimagined.gtlib.machine.types.BasicMultiMachine;
import org.gtreimagined.gtlib.structure.BlockInfo;
import org.gtreimagined.gtlib.structure.Pattern;

public class PonderUtils {
    public static final List<StoryBoardEntry> SCENES = new ArrayList<StoryBoardEntry>();

    public static void registerMultiblock(BasicMultiMachine<?> machine, Tier t, List<Pattern> patterns) {
        for (int i = 0; i < patterns.size(); ++i) {
            Pattern pattern = patterns.get(i);
            if (pattern.getBlockInfos().length <= 0) continue;
            CompoundTag nbt = new CompoundTag();
            ListTag size = new ListTag();
            size.add((Object)IntTag.m_128679_((int)pattern.getBlockInfos()[0].length));
            size.add((Object)IntTag.m_128679_((int)(pattern.getBlockInfos().length + 1)));
            size.add((Object)IntTag.m_128679_((int)pattern.getBlockInfos()[0][0].length));
            nbt.m_128365_("size", (Tag)size);
            ListTag blockTags = new ListTag();
            ArrayList<BlockState> states = new ArrayList<BlockState>();
            ArrayList<BlockPos> controllerPositions = new ArrayList<BlockPos>();
            BlockInfo[][][] blocks = pattern.getBlockInfos();
            for (int y = 0; y < blocks.length + 1; ++y) {
                BlockInfo[][] aisle = blocks[y == 0 ? y : y - 1];
                for (int x = 0; x < aisle.length; ++x) {
                    BlockInfo[] column = aisle[x];
                    for (int z = 0; z < column.length; ++z) {
                        BlockState state;
                        BlockPos blockPos = new BlockPos(x, y, z);
                        BlockInfo info = column[z];
                        BlockState blockState = y == 0 ? ((x + z) % 2 == 0 ? Blocks.f_50542_.m_49966_() : Blocks.f_50127_.m_49966_()) : (state = info.getBlockState());
                        if (!states.contains(state)) {
                            states.add(state);
                        }
                        if (state.m_60734_() instanceof BlockMultiMachine) {
                            controllerPositions.add(blockPos);
                        }
                        int index = states.indexOf(state);
                        CompoundTag entry = new CompoundTag();
                        entry.m_128405_("state", index);
                        ListTag pos = new ListTag();
                        pos.add((Object)IntTag.m_128679_((int)blockPos.m_123341_()));
                        pos.add((Object)IntTag.m_128679_((int)blockPos.m_123342_()));
                        pos.add((Object)IntTag.m_128679_((int)blockPos.m_123343_()));
                        entry.m_128365_("pos", (Tag)pos);
                        blockTags.add((Object)entry);
                    }
                }
            }
            if (blockTags.isEmpty() || states.isEmpty()) {
                return;
            }
            nbt.m_128365_("blocks", (Tag)blockTags);
            ListTag palette = new ListTag();
            states.forEach(s -> palette.add((Object)NbtUtils.m_129202_((BlockState)s)));
            nbt.m_128365_("palette", (Tag)palette);
            nbt.m_128405_("DataVersion", SharedConstants.m_183709_().getWorldVersion());
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            try {
                NbtIo.m_128947_((CompoundTag)nbt, (OutputStream)stream);
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
            GTLibDynamics.DYNAMIC_RESOURCE_PACK.addAsset(new ResourceLocation(machine.getDomain(), "ponder/" + machine.getBlockState(t).getId() + "/" + i + ".nbt"), stream.toByteArray());
            GTLibDynamics.RUNTIME_DATA_PACK.addData(new ResourceLocation(machine.getDomain(), "structures/" + machine.getBlockState(t).getId() + "/" + i + ".nbt"), stream.toByteArray());
            PonderStoryBoardEntry storyBoardentry = new PonderStoryBoardEntry((scene, util) -> {
                scene.title(machine.getBlockState(t).getId(), machine.getLang("en_us") + " Multiblock");
                scene.rotateCameraY(180.0f);
                scene.configureBasePlate(0, 0, Math.max(pattern.getBlockInfos()[0].length, pattern.getBlockInfos()[0][0].length) + 1);
                scene.showBasePlate();
                scene.scaleSceneView(pattern.getScale());
                scene.idle(5);
                for (int y = 1; y < blocks.length + 1; ++y) {
                    Selection selection = util.select().fromTo(0, y, 0, pattern.getBlockInfos()[0].length - 1, y, pattern.getBlockInfos()[0][0].length - 1);
                    if (y == blocks.length) {
                        controllerPositions.forEach(pos -> {});
                    }
                    scene.world().showSection(selection, Direction.UP);
                    if (pattern.getPonderTooltipMap().containsKey(y - 1)) {
                        scene.idle(5);
                        int finalY = y;
                        ((List)pattern.getPonderTooltipMap().get(y - 1)).forEach(tip -> {
                            Vec3 centerTop = util.vector().topOf(util.grid().at(tip.x(), finalY, tip.z()));
                            scene.overlay().showText(40).attachKeyFrame().text(tip.tooltip()).pointAt(centerTop);
                            scene.idle(40);
                        });
                    }
                    scene.idleSeconds(4);
                }
                scene.markAsFinished();
            }, machine.getDomain(), new ResourceLocation(machine.getDomain(), machine.getBlockState(t).getId() + "/" + i), machine.getBlockState(t).getLoc());
            SCENES.add((StoryBoardEntry)storyBoardentry);
        }
    }
}

