/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.integration.jei.category;

import com.mojang.blaze3d.vertex.PoseStack;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.data.GTMaterialTypes;
import org.gtreimagined.gtlib.data.VanillaStoneTypes;
import org.gtreimagined.gtlib.integration.jei.GTLibJEIPlugin;
import org.gtreimagined.gtlib.integration.jei.category.RecipeMapCategory;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.material.MaterialTypeBlock;
import org.gtreimagined.gtlib.ore.StoneType;
import org.gtreimagined.gtlib.util.Utils;
import org.gtreimagined.gtlib.worldgen.vein.Vein;

public class VeinCategory
implements IRecipeCategory<Vein> {
    IDrawable icon = RecipeMapCategory.guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)Items.f_41834_.m_7968_());
    IDrawable background = RecipeMapCategory.guiHelper.drawableBuilder(new ResourceLocation("gtlib", "textures/gui/background/machine_basic.png"), 3, 3, 170, 60).addPadding(0, 60, 0, 0).build();
    public static final RecipeType<Vein> VEINS = new RecipeType(new ResourceLocation("gtlib", "veins"), Vein.class);

    public Component getTitle() {
        return Utils.translatable("jei.category.gtlib.veins", new Object[0]);
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public RecipeType<Vein> getRecipeType() {
        return VEINS;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, Vein recipe, IFocusGroup focuses) {
        for (int i = 0; i < 4; ++i) {
            Material material = i == 0 ? recipe.primary() : (i == 1 ? recipe.secondary() : (i == 2 ? recipe.between() : recipe.sporadic()));
            builder.addSlot(RecipeIngredientRole.OUTPUT, 1 + i * 18, 1).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, GTAPI.all(StoneType.class).stream().filter(s -> s.doesGenerateOre() && s != VanillaStoneTypes.BEDROCK).map(s -> ((MaterialTypeBlock.IOreGetter)GTMaterialTypes.ORE.get()).get(material, (StoneType)s).asBlock()).map(ItemStack::new).toList());
        }
        GTLibJEIPlugin.addDimensionSlots(builder, recipe.dimensions());
    }

    public void draw(Vein recipe, IRecipeSlotsView recipeSlotsView, PoseStack stack, double mouseX, double mouseY) {
        int x = RecipeMapCategory.JEI_OFFSET_X;
        int y = RecipeMapCategory.JEI_OFFSET_Y + 3;
        String fullId = recipe.getLoc().m_135815_();
        this.renderString(stack, "Vein Name: " + Utils.lowerUnderscoreToUpperSpaced(fullId), Minecraft.m_91087_().f_91062_, 0.0f, 18.0f, 0, x, y, false);
        this.renderString(stack, "Primary: " + recipe.primary().getDisplayNameString() + " Ore", Minecraft.m_91087_().f_91062_, 0.0f, 38.0f, 0, x, y, false);
        this.renderString(stack, "Secondary: " + recipe.secondary().getDisplayNameString() + " Ore", Minecraft.m_91087_().f_91062_, 0.0f, 48.0f, 0, x, y, false);
        this.renderString(stack, "Between: " + recipe.between().getDisplayNameString() + " Ore", Minecraft.m_91087_().f_91062_, 0.0f, 58.0f, 0, x, y, false);
        this.renderString(stack, "Sporadic: " + recipe.sporadic().getDisplayNameString() + " Ore", Minecraft.m_91087_().f_91062_, 0.0f, 68.0f, 0, x, y, false);
        this.renderString(stack, "MinY: " + recipe.minY() + " MaxY: " + recipe.maxY(), Minecraft.m_91087_().f_91062_, 0.0f, 78.0f, 0, x, y, false);
        this.renderString(stack, "Weight: " + recipe.weight(), Minecraft.m_91087_().f_91062_, 100.0f, 78.0f, 0, x, y, false);
        this.renderString(stack, "Generated world:", Minecraft.m_91087_().f_91062_, 0.0f, 88.0f, 0, x, y, false);
    }

    void renderString(PoseStack stack, String string, Font render, float x, float y, int color, int guiOffsetX, int guiOffsetY, boolean shadow) {
        if (shadow) {
            render.m_92750_(stack, string, (float)guiOffsetX + x, (float)guiOffsetY + y, color);
        } else {
            render.m_92883_(stack, string, (float)guiOffsetX + x, (float)guiOffsetY + y, color);
        }
    }
}

