/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.integration.jade;

import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.gtreimagined.gtlib.util.Utils;
import org.gtreimagined.tesseract.api.eu.IEnergyHandler;
import org.gtreimagined.tesseract.api.forge.TesseractCaps;
import org.gtreimagined.tesseract.api.hu.IHeatHandler;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.BoxStyle;
import snownee.jade.api.ui.IBoxStyle;
import snownee.jade.api.ui.IDisplayHelper;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.api.ui.IProgressStyle;

public class EUProvider
implements IBlockComponentProvider,
IServerDataProvider<BlockEntity> {
    private static final ResourceLocation ID = new ResourceLocation("gtlib", "eu_hu");
    public static EUProvider INSTANCE = new EUProvider();

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        IProgressStyle progressStyle;
        MutableComponent text;
        String maxText;
        String curText;
        long max;
        long cur;
        IElementHelper helper;
        BlockEntity blockEntity = accessor.getBlockEntity();
        if (blockEntity == null) {
            return;
        }
        if (Minecraft.m_91087_().f_91074_ == null) {
            return;
        }
        IEnergyHandler storage = (IEnergyHandler)blockEntity.getCapability(TesseractCaps.ENERGY_HANDLER_CAPABILITY).orElse(null);
        if (storage != null && (!accessor.isServerConnected() || accessor.getServerData().m_128441_("jadeEU"))) {
            helper = tooltip.getElementHelper();
            if (accessor.isServerConnected()) {
                cur = accessor.getServerData().m_128454_("jadeEU");
                max = accessor.getServerData().m_128454_("jadeMaxEU");
            } else {
                cur = storage.getEnergy();
                max = storage.getCapacity();
            }
            curText = ChatFormatting.WHITE + this.humanReadableNumber(cur, "EU", Minecraft.m_91087_().f_91074_.m_6047_()) + ChatFormatting.GRAY;
            maxText = this.humanReadableNumber(max, "EU", Minecraft.m_91087_().f_91074_.m_6047_());
            text = Utils.translatable("jade.fe", curText, maxText).m_130940_(ChatFormatting.WHITE);
            progressStyle = helper.progressStyle().color(-16711681, -16737895);
            tooltip.add(helper.progress((float)cur / (float)max, (Component)text, progressStyle, (IBoxStyle)BoxStyle.DEFAULT, true));
        }
        if ((storage = (IHeatHandler)blockEntity.getCapability(TesseractCaps.HEAT_CAPABILITY).orElse(null)) != null && (!accessor.isServerConnected() || accessor.getServerData().m_128441_("jadeHU"))) {
            helper = tooltip.getElementHelper();
            if (accessor.isServerConnected()) {
                cur = accessor.getServerData().m_128454_("jadeHU");
                max = accessor.getServerData().m_128454_("jadeMaxHU");
            } else {
                cur = storage.getHeat();
                max = storage.getHeatCap();
            }
            curText = ChatFormatting.WHITE + this.humanReadableNumber(cur, "HU", Minecraft.m_91087_().f_91074_.m_6047_()) + ChatFormatting.GRAY;
            maxText = this.humanReadableNumber(max, "HU", Minecraft.m_91087_().f_91074_.m_6047_());
            text = Utils.translatable("jade.fe", curText, maxText).m_130940_(ChatFormatting.WHITE);
            progressStyle = helper.progressStyle().color(-65536, -10092544);
            tooltip.add(helper.progress((float)cur / (float)max, (Component)text, progressStyle, (IBoxStyle)BoxStyle.DEFAULT, true));
        }
    }

    private String humanReadableNumber(double number, String unit, boolean shift) {
        return shift ? number + unit : IDisplayHelper.get().humanReadableNumber(number, unit, false);
    }

    public void appendServerData(CompoundTag compoundTag, ServerPlayer serverPlayer, Level level, BlockEntity blockEntity, boolean b) {
        IHeatHandler heatHandler;
        IEnergyHandler handler = (IEnergyHandler)blockEntity.getCapability(TesseractCaps.ENERGY_HANDLER_CAPABILITY).orElse(null);
        if (handler != null) {
            compoundTag.m_128356_("jadeEU", handler.getEnergy());
            compoundTag.m_128356_("jadeMaxEU", handler.getCapacity());
        }
        if ((heatHandler = (IHeatHandler)blockEntity.getCapability(TesseractCaps.HEAT_CAPABILITY).orElse(null)) != null) {
            compoundTag.m_128356_("jadeHU", (long)heatHandler.getHeat());
            compoundTag.m_128356_("jadeMaxHU", (long)heatHandler.getHeatCap());
        }
    }

    public ResourceLocation getUid() {
        return ID;
    }
}

