/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.integration.emi.recipe;

import dev.emi.emi.api.forge.ForgeEmiStack;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.fluids.FluidStack;
import org.gtreimagined.gtlib.integration.emi.GTEMIFluidIngredient;
import org.gtreimagined.gtlib.recipe.IRecipe;
import org.gtreimagined.gtlib.recipe.ingredient.FluidIngredient;
import org.jetbrains.annotations.Nullable;

public class RecipeMapRecipe
implements EmiRecipe {
    private final EmiRecipeCategory category;
    private final IRecipe recipe;
    private final List<EmiIngredient> inputs = new ArrayList<EmiIngredient>();
    private final List<EmiStack> outputs = new ArrayList<EmiStack>();

    public RecipeMapRecipe(EmiRecipeCategory category, IRecipe recipe) {
        this.category = category;
        this.recipe = recipe;
        this.recipe.getInputItems().forEach(i -> this.inputs.add(EmiIngredient.of((Ingredient)i)));
        this.recipe.getInputFluids().forEach(f -> this.inputs.add(new GTEMIFluidIngredient((FluidIngredient)f)));
        if (this.recipe.hasOutputItems()) {
            for (ItemStack itemStack : this.recipe.getOutputItems(false)) {
                this.outputs.add(EmiStack.of((ItemStack)itemStack));
            }
        }
        if (recipe.hasOutputFluids()) {
            for (ItemStack itemStack : recipe.getOutputFluids()) {
                this.outputs.add(ForgeEmiStack.of((FluidStack)itemStack));
            }
        }
    }

    public EmiRecipeCategory getCategory() {
        return this.category;
    }

    @Nullable
    public ResourceLocation getId() {
        return this.recipe.m_6423_();
    }

    public List<EmiIngredient> getInputs() {
        return this.inputs;
    }

    public List<EmiStack> getOutputs() {
        return this.outputs;
    }

    public int getDisplayWidth() {
        return 0;
    }

    public int getDisplayHeight() {
        return 0;
    }

    public void addWidgets(WidgetHolder widgetHolder) {
    }
}

