/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.dynamic;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import org.gtreimagined.gtlib.client.ModelUtils;
import org.gtreimagined.gtlib.dynamic.BlockDynamic;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModelConfig {
    protected int[] config = BlockDynamic.DEFAULT_CONFIG;
    protected int modelIndex = -1;

    public ModelConfig set(BlockPos pos, int[] config) {
        this.config = config;
        return this;
    }

    public int[] getConfig() {
        return this.config;
    }

    public boolean hasModelIndex() {
        return this.modelIndex != -1;
    }

    public void setModelIndex(int index) {
        this.modelIndex = index;
    }

    public int getModelIndex() {
        return this.modelIndex;
    }

    public List<BakedQuad> getQuads(List<BakedQuad> quads, Int2ObjectOpenHashMap<BakedModel[]> bakedConfigs, BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull BlockAndTintGetter level, @NotNull BlockPos pos) {
        if (side == null) {
            for (int i = 0; i < this.config.length; ++i) {
                BakedModel[] baked = (BakedModel[])bakedConfigs.get(this.config[i]);
                if (baked == null) continue;
                this.addBaked(quads, baked, state, null, rand, level, pos);
                if (i != 0) continue;
                this.setModelIndex(this.config[i]);
            }
        } else if (this.config.length < 6) {
            for (int i = 0; i < this.config.length; ++i) {
                BakedModel[] baked = (BakedModel[])bakedConfigs.get(this.config[i]);
                if (baked == null) continue;
                this.addBaked(quads, baked, state, side, rand, level, pos);
            }
        } else {
            BakedModel[] baked = (BakedModel[])bakedConfigs.get(this.config[side.m_122411_()]);
            if (baked != null) {
                this.addBaked(quads, baked, state, null, rand, level, pos);
            }
        }
        return quads;
    }

    public void addBaked(List<BakedQuad> quads, BakedModel[] baked, BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull BlockAndTintGetter level, @NotNull BlockPos pos) {
        for (int j = 0; j < baked.length; ++j) {
            quads.addAll(ModelUtils.getQuadsFromBaked(baked[j], state, side, rand, level, pos));
        }
    }

    public boolean isInvalid() {
        return this.config == null || this.config.length == 0 || this.config[0] == -1;
    }
}

