/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.datagen.providers;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CrossCollisionBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.block.state.properties.WallSide;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidType;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.block.BlockBasic;
import org.gtreimagined.gtlib.client.GTLibModelManager;
import org.gtreimagined.gtlib.datagen.GTLibDynamics;
import org.gtreimagined.gtlib.datagen.IGTLibProvider;
import org.gtreimagined.gtlib.datagen.builder.GTBlockModelBuilder;
import org.gtreimagined.gtlib.datagen.builder.IModelLocation;
import org.gtreimagined.gtlib.datagen.builder.IStateBuilder;
import org.gtreimagined.gtlib.datagen.builder.MultiPartBlockStateBuilder;
import org.gtreimagined.gtlib.datagen.builder.VariantBlockStateBuilder;
import org.gtreimagined.gtlib.datagen.providers.GTBlockModelProvider;
import org.gtreimagined.gtlib.fluid.GTFluid;
import org.gtreimagined.gtlib.util.RegistryUtils;
import org.jetbrains.annotations.NotNull;

public class GTBlockStateProvider
implements IGTLibProvider {
    protected final String modid;
    protected final String providerName;
    protected final GTBlockModelProvider blockModelProvider;
    protected final Map<Block, IStateBuilder> registeredBlocks = new LinkedHashMap<Block, IStateBuilder>();
    private static final int DEFAULT_ANGLE_OFFSET = 180;
    public static final ImmutableMap<Direction, Property<WallSide>> WALL_PROPS = ImmutableMap.builder().put((Object)Direction.EAST, (Object)BlockStateProperties.f_61378_).put((Object)Direction.NORTH, (Object)BlockStateProperties.f_61379_).put((Object)Direction.SOUTH, (Object)BlockStateProperties.f_61380_).put((Object)Direction.WEST, (Object)BlockStateProperties.f_61381_).build();

    public GTBlockStateProvider(String modid, String providerName) {
        this(modid, providerName, GTBlockModelProvider::new);
    }

    public GTBlockStateProvider(String modid, String providerName, BiFunction<String, String, GTBlockModelProvider> function) {
        this.modid = modid;
        this.providerName = providerName;
        this.blockModelProvider = function.apply(modid, providerName);
    }

    @NotNull
    public String m_6055_() {
        return this.providerName;
    }

    protected void registerStatesAndModels() {
        this.processBlocks(this.modid);
    }

    @Override
    public void run() {
        this.registerStatesAndModels();
    }

    @Override
    public void onCompletion() {
        this.models().buildAll();
        this.registeredBlocks.forEach((b, s) -> {
            if (RegistryUtils.getIdFromBlock(b) == null) {
                BlockBasic blockBasic = (BlockBasic)b;
            } else {
                GTLibDynamics.DYNAMIC_RESOURCE_PACK.addBlockState(s.toState(), RegistryUtils.getIdFromBlock(b));
            }
        });
    }

    public GTBlockModelProvider models() {
        return this.blockModelProvider;
    }

    public void processBlocks(String domain) {
        GTAPI.all(Block.class, domain).forEach(b -> GTLibModelManager.onBlockModelBuild(b, this));
        GTAPI.all(GTFluid.class, domain).forEach(f -> this.state((Block)f.getFluidBlock(), (IModelLocation)this.getBuilder((Block)f.getFluidBlock()).texture("particle", IClientFluidTypeExtensions.of((FluidType)f.getFluidType()).getStillTexture())));
    }

    public GTBlockModelBuilder getBuilder(Block block) {
        if (RegistryUtils.getIdFromBlock(block) == null) {
            return (GTBlockModelBuilder)this.models().getBuilder(((BlockBasic)block).getId());
        }
        return (GTBlockModelBuilder)this.models().getBuilder(RegistryUtils.getIdFromBlock(block).m_135815_());
    }

    public GTBlockModelBuilder cubeAll(Block block, ResourceLocation texture) {
        return (GTBlockModelBuilder)this.models().cubeAll(RegistryUtils.getIdFromBlock(block).toString(), texture);
    }

    public void state(Block block, IModelLocation model) {
        this.simpleBlock(block, model);
    }

    public void state(Block block, ResourceLocation ... textures) {
        if (textures.length == 1) {
            this.simpleBlock(block, this.getSimpleModel(block, textures[0]));
        } else if (textures.length == 2) {
            this.simpleBlock(block, this.getLayeredModel(block, textures[0], textures[1]));
        } else if (textures.length == 6) {
            this.horizontalBlock(block, this.getSimpleModel(block, textures));
        } else if (textures.length == 12) {
            this.horizontalBlock(block, this.getLayeredModel(block, textures));
        }
    }

    public GTBlockModelBuilder getSimpleModel(Block block, ResourceLocation texture) {
        return (GTBlockModelBuilder)((GTBlockModelBuilder)this.getBuilder(block).parent(this.loc("gtlib", "block/preset/simple"))).texture("all", texture);
    }

    public GTBlockModelBuilder getSimpleModel(Block block, ResourceLocation ... texture) {
        return (GTBlockModelBuilder)((GTBlockModelBuilder)((GTBlockModelBuilder)((GTBlockModelBuilder)((GTBlockModelBuilder)((GTBlockModelBuilder)((GTBlockModelBuilder)((GTBlockModelBuilder)this.getBuilder(block).parent(this.loc("gtlib", "block/preset/simple"))).texture("down", texture[0])).texture("up", texture[1])).texture("south", texture[2])).texture("north", texture[3])).texture("west", texture[4])).texture("east", texture[5])).texture("particle", texture[1]);
    }

    public GTBlockModelBuilder getLayeredModel(Block block, ResourceLocation ... texture) {
        return (GTBlockModelBuilder)((GTBlockModelBuilder)((GTBlockModelBuilder)((GTBlockModelBuilder)((GTBlockModelBuilder)((GTBlockModelBuilder)((GTBlockModelBuilder)((GTBlockModelBuilder)((GTBlockModelBuilder)((GTBlockModelBuilder)((GTBlockModelBuilder)((GTBlockModelBuilder)((GTBlockModelBuilder)((GTBlockModelBuilder)this.getBuilder(block).parent(this.loc("gtlib", "block/preset/layered"))).texture("basedown", texture[0])).texture("baseup", texture[1])).texture("basesouth", texture[2])).texture("basenorth", texture[3])).texture("basewest", texture[4])).texture("baseeast", texture[5])).texture("overlaydown", texture[6])).texture("overlayup", texture[7])).texture("overlaysouth", texture[8])).texture("overlaynorth", texture[9])).texture("overlaywest", texture[10])).texture("overlayeast", texture[11])).texture("particle", texture[1]);
    }

    public GTBlockModelBuilder getLayeredModel(Block block, ResourceLocation base, ResourceLocation overlay) {
        return (GTBlockModelBuilder)((GTBlockModelBuilder)((GTBlockModelBuilder)this.getBuilder(block).parent(this.loc("gtlib", "block/preset/layered"))).texture("base", base)).texture("overlay", overlay);
    }

    public ResourceLocation existing(String domain, String path) {
        return this.loc(domain, path);
    }

    public ResourceLocation loc(String domain, String path) {
        return new ResourceLocation(domain, path);
    }

    private String name(Block block) {
        return RegistryUtils.getIdFromBlock(block).m_135815_();
    }

    public ResourceLocation blockTexture(Block block) {
        ResourceLocation name = RegistryUtils.getIdFromBlock(block);
        return new ResourceLocation(name.m_135827_(), "block/" + name.m_135815_());
    }

    public VariantBlockStateBuilder getVariantBuilder(Block b) {
        if (this.registeredBlocks.containsKey(b)) {
            IStateBuilder old = this.registeredBlocks.get(b);
            Preconditions.checkState((boolean)(old instanceof VariantBlockStateBuilder));
            return (VariantBlockStateBuilder)old;
        }
        VariantBlockStateBuilder ret = new VariantBlockStateBuilder(b);
        this.registeredBlocks.put(b, ret);
        return ret;
    }

    public MultiPartBlockStateBuilder getMultipartBuilder(Block b) {
        if (this.registeredBlocks.containsKey(b)) {
            IStateBuilder old = this.registeredBlocks.get(b);
            Preconditions.checkState((boolean)(old instanceof MultiPartBlockStateBuilder));
            return (MultiPartBlockStateBuilder)old;
        }
        MultiPartBlockStateBuilder ret = new MultiPartBlockStateBuilder(b);
        this.registeredBlocks.put(b, ret);
        return ret;
    }

    private ResourceLocation extend(ResourceLocation rl, String suffix) {
        return new ResourceLocation(rl.m_135827_(), rl.m_135815_() + suffix);
    }

    public GTBlockModelBuilder cubeAll(Block block) {
        return (GTBlockModelBuilder)this.models().cubeAll(this.name(block), this.blockTexture(block));
    }

    public void simpleBlock(Block block) {
        this.simpleBlock(block, this.cubeAll(block));
    }

    public void simpleBlock(Block block, Function<IModelLocation, VariantBlockStateBuilder.VariantBuilder> expander) {
        this.simpleBlock(block, expander.apply(this.cubeAll(block)));
    }

    public void simpleBlock(Block block, IModelLocation model) {
        this.getVariantBuilder(block).wildcard(new VariantBlockStateBuilder.VariantBuilder().modelFile(model));
    }

    public void simpleBlock(Block block, VariantBlockStateBuilder.VariantBuilder ... models) {
    }

    public void axisBlock(RotatedPillarBlock block) {
        this.axisBlock(block, this.blockTexture((Block)block));
    }

    public void logBlock(RotatedPillarBlock block) {
        this.axisBlock(block, this.blockTexture((Block)block), this.extend(this.blockTexture((Block)block), "_top"));
    }

    public void axisBlock(RotatedPillarBlock block, ResourceLocation baseName) {
        this.axisBlock(block, this.extend(baseName, "_side"), this.extend(baseName, "_end"));
    }

    public void axisBlock(RotatedPillarBlock block, ResourceLocation side, ResourceLocation end) {
        this.axisBlock(block, (IModelLocation)this.models().cubeColumn(this.name((Block)block), side, end), (IModelLocation)this.models().cubeColumnHorizontal(this.name((Block)block) + "_horizontal", side, end));
    }

    public void axisBlock(RotatedPillarBlock block, IModelLocation vertical, IModelLocation horizontal) {
        this.getVariantBuilder((Block)block).forAllStates(state -> {
            VariantBlockStateBuilder.VariantBuilder builder = new VariantBlockStateBuilder.VariantBuilder();
            return switch ((Direction.Axis)state.m_61143_((Property)RotatedPillarBlock.f_55923_)) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.Axis.X -> builder.modelFile(vertical);
                case Direction.Axis.Y -> builder.modelFile(horizontal).rotationX(90);
                case Direction.Axis.Z -> builder.modelFile(horizontal).rotationX(90).rotationY(90);
            };
        });
    }

    public void horizontalBlock(Block block, ResourceLocation side, ResourceLocation front, ResourceLocation top) {
        this.horizontalBlock(block, (IModelLocation)this.models().orientable(this.name(block), side, front, top));
    }

    public void horizontalBlock(Block block, IModelLocation model) {
        this.horizontalBlock(block, model, 180);
    }

    public void horizontalBlock(Block block, IModelLocation model, int angleOffset) {
        this.horizontalBlock(block, (BlockState $) -> model, angleOffset);
    }

    public void horizontalBlock(Block block, Function<BlockState, IModelLocation> modelFunc) {
        this.horizontalBlock(block, modelFunc, 180);
    }

    public void horizontalBlock(Block block, Function<BlockState, IModelLocation> modelFunc, int angleOffset) {
        if (block.m_49966_().m_61138_((Property)BlockStateProperties.f_61374_)) {
            this.getVariantBuilder(block).forAllStates(state -> new VariantBlockStateBuilder.VariantBuilder().modelFile((IModelLocation)modelFunc.apply((BlockState)state)).rotationY(((int)((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122435_() + angleOffset) % 360));
        } else {
            this.getVariantBuilder(block).wildcard(new VariantBlockStateBuilder.VariantBuilder().modelFile(modelFunc.apply(block.m_49966_())));
        }
    }

    public void horizontalFaceBlock(Block block, IModelLocation model) {
        this.horizontalFaceBlock(block, model, 180);
    }

    public void horizontalFaceBlock(Block block, IModelLocation model, int angleOffset) {
        this.horizontalFaceBlock(block, (BlockState $) -> model, angleOffset);
    }

    public void horizontalFaceBlock(Block block, Function<BlockState, IModelLocation> modelFunc) {
        this.horizontalFaceBlock(block, modelFunc, 180);
    }

    public void horizontalFaceBlock(Block block, Function<BlockState, IModelLocation> modelFunc, int angleOffset) {
        this.getVariantBuilder(block).forAllStates(state -> new VariantBlockStateBuilder.VariantBuilder().modelFile((IModelLocation)modelFunc.apply((BlockState)state)).rotationX(((AttachFace)state.m_61143_((Property)BlockStateProperties.f_61376_)).ordinal() * 90).rotationY(((int)((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122435_() + angleOffset + (state.m_61143_((Property)BlockStateProperties.f_61376_) == AttachFace.CEILING ? 180 : 0)) % 360));
    }

    public void directionalBlock(Block block, IModelLocation model) {
        this.directionalBlock(block, model, 180);
    }

    public void directionalBlock(Block block, IModelLocation model, int angleOffset) {
        this.directionalBlock(block, (BlockState $) -> model, angleOffset);
    }

    public void directionalBlock(Block block, Function<BlockState, IModelLocation> modelFunc) {
        this.directionalBlock(block, modelFunc, 180);
    }

    public void directionalBlock(Block block, Function<BlockState, IModelLocation> modelFunc, int angleOffset) {
        this.getVariantBuilder(block).forAllStates(state -> {
            Direction dir = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
            return new VariantBlockStateBuilder.VariantBuilder().modelFile((IModelLocation)modelFunc.apply((BlockState)state)).rotationX(dir == Direction.DOWN ? 180 : (dir.m_122434_().m_122479_() ? 90 : 0)).rotationY(dir.m_122434_().m_122478_() ? 0 : ((int)dir.m_122435_() + angleOffset) % 360);
        });
    }

    public void stairsBlock(StairBlock block, ResourceLocation texture) {
        this.stairsBlock(block, texture, texture, texture);
    }

    public void stairsBlock(StairBlock block, String name, ResourceLocation texture) {
        this.stairsBlock(block, name, texture, texture, texture);
    }

    public void stairsBlock(StairBlock block, ResourceLocation side, ResourceLocation bottom, ResourceLocation top) {
        this.stairsBlockInternal(block, Registry.f_122824_.m_7981_((Object)block).toString(), side, bottom, top);
    }

    public void stairsBlock(StairBlock block, String name, ResourceLocation side, ResourceLocation bottom, ResourceLocation top) {
        this.stairsBlockInternal(block, name + "_stairs", side, bottom, top);
    }

    private void stairsBlockInternal(StairBlock block, String baseName, ResourceLocation side, ResourceLocation bottom, ResourceLocation top) {
        GTBlockModelBuilder stairs = (GTBlockModelBuilder)this.models().stairs(baseName, side, bottom, top);
        GTBlockModelBuilder stairsInner = (GTBlockModelBuilder)this.models().stairsInner(baseName + "_inner", side, bottom, top);
        GTBlockModelBuilder stairsOuter = (GTBlockModelBuilder)this.models().stairsOuter(baseName + "_outer", side, bottom, top);
        this.stairsBlock(block, stairs, stairsInner, stairsOuter);
    }

    public void stairsBlock(StairBlock block, IModelLocation stairs, IModelLocation stairsInner, IModelLocation stairsOuter) {
        this.getVariantBuilder((Block)block).forAllStatesExcept(state -> {
            Direction facing = (Direction)state.m_61143_((Property)StairBlock.f_56841_);
            Half half = (Half)state.m_61143_((Property)StairBlock.f_56842_);
            StairsShape shape = (StairsShape)state.m_61143_((Property)StairBlock.f_56843_);
            int yRot = (int)facing.m_122427_().m_122435_();
            if (shape == StairsShape.INNER_LEFT || shape == StairsShape.OUTER_LEFT) {
                yRot += 270;
            }
            if (shape != StairsShape.STRAIGHT && half == Half.TOP) {
                yRot += 90;
            }
            boolean uvlock = (yRot %= 360) != 0 || half == Half.TOP;
            return new VariantBlockStateBuilder.VariantBuilder().modelFile(shape == StairsShape.STRAIGHT ? stairs : (shape == StairsShape.INNER_LEFT || shape == StairsShape.INNER_RIGHT ? stairsInner : stairsOuter)).rotationX(half == Half.BOTTOM ? 0 : 180).rotationY(yRot).uvLock(uvlock);
        }, new Property[]{StairBlock.f_56844_});
    }

    public void slabBlock(SlabBlock block, ResourceLocation doubleslab, ResourceLocation texture) {
        this.slabBlock(block, doubleslab, texture, texture, texture);
    }

    public void slabBlock(SlabBlock block, ResourceLocation doubleslab, ResourceLocation side, ResourceLocation bottom, ResourceLocation top) {
        this.slabBlock(block, (IModelLocation)this.models().slab(this.name((Block)block), side, bottom, top), (IModelLocation)this.models().slabTop(this.name((Block)block) + "_top", side, bottom, top), () -> doubleslab);
    }

    public void slabBlock(SlabBlock block, IModelLocation bottom, IModelLocation top, IModelLocation doubleslab) {
        this.getVariantBuilder((Block)block).forAllStates(state -> {
            VariantBlockStateBuilder.VariantBuilder builder = new VariantBlockStateBuilder.VariantBuilder();
            return switch ((SlabType)state.m_61143_((Property)SlabBlock.f_56353_)) {
                default -> throw new IncompatibleClassChangeError();
                case SlabType.TOP -> builder.modelFile(top);
                case SlabType.BOTTOM -> builder.modelFile(bottom);
                case SlabType.DOUBLE -> builder.modelFile(doubleslab);
            };
        });
    }

    public void buttonBlock(ButtonBlock block, ResourceLocation texture) {
        GTBlockModelBuilder button = (GTBlockModelBuilder)this.models().button(this.name((Block)block), texture);
        GTBlockModelBuilder buttonPressed = (GTBlockModelBuilder)this.models().buttonPressed(this.name((Block)block) + "_pressed", texture);
        this.buttonBlock(block, button, buttonPressed);
    }

    public void buttonBlock(ButtonBlock block, IModelLocation button, IModelLocation buttonPressed) {
        this.getVariantBuilder((Block)block).forAllStates(state -> {
            Direction facing = (Direction)state.m_61143_((Property)ButtonBlock.f_54117_);
            AttachFace face = (AttachFace)state.m_61143_((Property)ButtonBlock.f_53179_);
            boolean powered = (Boolean)state.m_61143_((Property)ButtonBlock.f_51045_);
            return new VariantBlockStateBuilder.VariantBuilder().modelFile(powered ? buttonPressed : button).rotationX(face == AttachFace.FLOOR ? 0 : (face == AttachFace.WALL ? 90 : 180)).rotationY((int)(face == AttachFace.CEILING ? facing : facing.m_122424_()).m_122435_()).uvLock(face == AttachFace.WALL);
        });
    }

    public void pressurePlateBlock(PressurePlateBlock block, ResourceLocation texture) {
        GTBlockModelBuilder pressurePlate = (GTBlockModelBuilder)this.models().pressurePlate(this.name((Block)block), texture);
        GTBlockModelBuilder pressurePlateDown = (GTBlockModelBuilder)this.models().pressurePlateDown(this.name((Block)block) + "_down", texture);
        this.pressurePlateBlock(block, pressurePlate, pressurePlateDown);
    }

    public void pressurePlateBlock(PressurePlateBlock block, IModelLocation pressurePlate, IModelLocation pressurePlateDown) {
        this.getVariantBuilder((Block)block).forAllStates(state -> (Boolean)state.m_61143_((Property)PressurePlateBlock.f_55249_) != false ? new VariantBlockStateBuilder.VariantBuilder().modelFile(pressurePlateDown) : new VariantBlockStateBuilder.VariantBuilder().modelFile(pressurePlate));
    }

    public void signBlock(StandingSignBlock signBlock, WallSignBlock wallSignBlock, ResourceLocation texture) {
        Object sign = this.models().sign(this.name((Block)signBlock), texture);
        this.signBlock(signBlock, wallSignBlock, (IModelLocation)sign);
    }

    public void signBlock(StandingSignBlock signBlock, WallSignBlock wallSignBlock, IModelLocation sign) {
        this.simpleBlock((Block)signBlock, sign);
        this.simpleBlock((Block)wallSignBlock, sign);
    }

    public void fourWayBlock(CrossCollisionBlock block, IModelLocation post, IModelLocation side) {
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder((Block)block).part().modelFile(post).addModel().end();
        this.fourWayMultipart(builder, side);
    }

    public void fourWayMultipart(MultiPartBlockStateBuilder builder, IModelLocation side) {
        PipeBlock.f_55154_.entrySet().forEach(e -> {
            Direction dir = (Direction)e.getKey();
            if (dir.m_122434_().m_122479_()) {
                builder.part().modelFile(side).rotationY(((int)dir.m_122435_() + 180) % 360).uvLock().addModel().condition((Property)e.getValue(), new Boolean[]{true});
            }
        });
    }

    public void fenceBlock(FenceBlock block, ResourceLocation texture) {
        String baseName = Registry.f_122824_.m_7981_((Object)block).toString();
        this.fourWayBlock((CrossCollisionBlock)block, (IModelLocation)this.models().fencePost(baseName + "_post", texture), (IModelLocation)this.models().fenceSide(baseName + "_side", texture));
    }

    public void fenceBlock(FenceBlock block, String name, ResourceLocation texture) {
        this.fourWayBlock((CrossCollisionBlock)block, (IModelLocation)this.models().fencePost(name + "_fence_post", texture), (IModelLocation)this.models().fenceSide(name + "_fence_side", texture));
    }

    public void fenceGateBlock(FenceGateBlock block, ResourceLocation texture) {
        this.fenceGateBlockInternal(block, Registry.f_122824_.m_7981_((Object)block).toString(), texture);
    }

    public void fenceGateBlock(FenceGateBlock block, String name, ResourceLocation texture) {
        this.fenceGateBlockInternal(block, name + "_fence_gate", texture);
    }

    private void fenceGateBlockInternal(FenceGateBlock block, String baseName, ResourceLocation texture) {
        Object gate = this.models().fenceGate(baseName, texture);
        Object gateOpen = this.models().fenceGateOpen(baseName + "_open", texture);
        Object gateWall = this.models().fenceGateWall(baseName + "_wall", texture);
        Object gateWallOpen = this.models().fenceGateWallOpen(baseName + "_wall_open", texture);
        this.fenceGateBlock(block, (IModelLocation)gate, (IModelLocation)gateOpen, (IModelLocation)gateWall, (IModelLocation)gateWallOpen);
    }

    public void fenceGateBlock(FenceGateBlock block, IModelLocation gate, IModelLocation gateOpen, IModelLocation gateWall, IModelLocation gateWallOpen) {
        this.getVariantBuilder((Block)block).forAllStatesExcept(state -> {
            IModelLocation model = gate;
            if (((Boolean)state.m_61143_((Property)FenceGateBlock.f_53343_)).booleanValue()) {
                model = gateWall;
            }
            if (((Boolean)state.m_61143_((Property)FenceGateBlock.f_53341_)).booleanValue()) {
                model = model == gateWall ? gateWallOpen : gateOpen;
            }
            return new VariantBlockStateBuilder.VariantBuilder().modelFile(model).rotationY((int)((Direction)state.m_61143_((Property)FenceGateBlock.f_54117_)).m_122435_()).uvLock();
        }, new Property[]{FenceGateBlock.f_53342_});
    }

    public void wallBlock(WallBlock block, ResourceLocation texture) {
        this.wallBlockInternal(block, Registry.f_122824_.m_7981_((Object)block).toString(), texture);
    }

    public void wallBlock(WallBlock block, String name, ResourceLocation texture) {
        this.wallBlockInternal(block, name + "_wall", texture);
    }

    private void wallBlockInternal(WallBlock block, String baseName, ResourceLocation texture) {
        this.wallBlock(block, (IModelLocation)this.models().wallPost(baseName + "_post", texture), (IModelLocation)this.models().wallSide(baseName + "_side", texture), (IModelLocation)this.models().wallSideTall(baseName + "_side_tall", texture));
    }

    public void wallBlock(WallBlock block, IModelLocation post, IModelLocation side, IModelLocation sideTall) {
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder((Block)block).part().modelFile(post).addModel().condition((Property)WallBlock.f_57949_, new Boolean[]{true}).end();
        WALL_PROPS.entrySet().stream().filter(e -> ((Direction)e.getKey()).m_122434_().m_122479_()).forEach(e -> {
            this.wallSidePart(builder, side, (Map.Entry<Direction, Property<WallSide>>)e, WallSide.LOW);
            this.wallSidePart(builder, sideTall, (Map.Entry<Direction, Property<WallSide>>)e, WallSide.TALL);
        });
    }

    private void wallSidePart(MultiPartBlockStateBuilder builder, IModelLocation model, Map.Entry<Direction, Property<WallSide>> entry, WallSide height) {
        builder.part().modelFile(model).rotationY(((int)entry.getKey().m_122435_() + 180) % 360).uvLock().addModel().condition(entry.getValue(), (Comparable[])new WallSide[]{height});
    }

    public void paneBlock(IronBarsBlock block, ResourceLocation pane, ResourceLocation edge) {
        this.paneBlockInternal(block, Registry.f_122824_.m_7981_((Object)block).toString(), pane, edge);
    }

    public void paneBlock(IronBarsBlock block, String name, ResourceLocation pane, ResourceLocation edge) {
        this.paneBlockInternal(block, name + "_pane", pane, edge);
    }

    private void paneBlockInternal(IronBarsBlock block, String baseName, ResourceLocation pane, ResourceLocation edge) {
        Object post = this.models().panePost(baseName + "_post", pane, edge);
        Object side = this.models().paneSide(baseName + "_side", pane, edge);
        Object sideAlt = this.models().paneSideAlt(baseName + "_side_alt", pane, edge);
        Object noSide = this.models().paneNoSide(baseName + "_noside", pane);
        Object noSideAlt = this.models().paneNoSideAlt(baseName + "_noside_alt", pane);
        this.paneBlock(block, (IModelLocation)post, (IModelLocation)side, (IModelLocation)sideAlt, (IModelLocation)noSide, (IModelLocation)noSideAlt);
    }

    public void paneBlock(IronBarsBlock block, IModelLocation post, IModelLocation side, IModelLocation sideAlt, IModelLocation noSide, IModelLocation noSideAlt) {
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder((Block)block).part().modelFile(post).addModel().end();
        PipeBlock.f_55154_.entrySet().forEach(e -> {
            Direction dir = (Direction)e.getKey();
            if (dir.m_122434_().m_122479_()) {
                boolean alt = dir == Direction.SOUTH;
                builder.part().modelFile(alt || dir == Direction.WEST ? sideAlt : side).rotationY(dir.m_122434_() == Direction.Axis.X ? 90 : 0).addModel().condition((Property)e.getValue(), new Boolean[]{true}).end().part().modelFile(alt || dir == Direction.EAST ? noSideAlt : noSide).rotationY(dir == Direction.WEST ? 270 : (dir == Direction.SOUTH ? 90 : 0)).addModel().condition((Property)e.getValue(), new Boolean[]{false});
            }
        });
    }

    public void doorBlock(DoorBlock block, ResourceLocation bottom, ResourceLocation top) {
        this.doorBlockInternal(block, Registry.f_122824_.m_7981_((Object)block).toString(), bottom, top);
    }

    public void doorBlock(DoorBlock block, String name, ResourceLocation bottom, ResourceLocation top) {
        this.doorBlockInternal(block, name + "_door", bottom, top);
    }

    private void doorBlockInternal(DoorBlock block, String baseName, ResourceLocation bottom, ResourceLocation top) {
        Object bottomLeft = this.models().doorBottomLeft(baseName + "_bottom", bottom, top);
        Object bottomRight = this.models().doorBottomRight(baseName + "_bottom_hinge", bottom, top);
        Object topLeft = this.models().doorTopLeft(baseName + "_top", bottom, top);
        Object topRight = this.models().doorTopRight(baseName + "_top_hinge", bottom, top);
        this.doorBlock(block, (IModelLocation)bottomLeft, (IModelLocation)bottomRight, (IModelLocation)topLeft, (IModelLocation)topRight);
    }

    public void doorBlock(DoorBlock block, IModelLocation bottomLeft, IModelLocation bottomRight, IModelLocation topLeft, IModelLocation topRight) {
        this.getVariantBuilder((Block)block).forAllStatesExcept(state -> {
            int yRot = (int)((Direction)state.m_61143_((Property)DoorBlock.f_52726_)).m_122435_() + 90;
            boolean rh = state.m_61143_((Property)DoorBlock.f_52728_) == DoorHingeSide.RIGHT;
            boolean open = (Boolean)state.m_61143_((Property)DoorBlock.f_52727_);
            boolean right = rh ^ open;
            if (open) {
                yRot += 90;
            }
            if (rh && open) {
                yRot += 180;
            }
            return new VariantBlockStateBuilder.VariantBuilder().modelFile(state.m_61143_((Property)DoorBlock.f_52730_) == DoubleBlockHalf.LOWER ? (right ? bottomRight : bottomLeft) : (right ? topRight : topLeft)).rotationY(yRot %= 360);
        }, new Property[]{DoorBlock.f_52729_});
    }

    public void trapdoorBlock(TrapDoorBlock block, ResourceLocation texture, boolean orientable) {
        this.trapdoorBlockInternal(block, Registry.f_122824_.m_7981_((Object)block).toString(), texture, orientable);
    }

    public void trapdoorBlock(TrapDoorBlock block, String name, ResourceLocation texture, boolean orientable) {
        this.trapdoorBlockInternal(block, name + "_trapdoor", texture, orientable);
    }

    private void trapdoorBlockInternal(TrapDoorBlock block, String baseName, ResourceLocation texture, boolean orientable) {
        Object bottom = orientable ? this.models().trapdoorOrientableBottom(baseName + "_bottom", texture) : this.models().trapdoorBottom(baseName + "_bottom", texture);
        Object top = orientable ? this.models().trapdoorOrientableTop(baseName + "_top", texture) : this.models().trapdoorTop(baseName + "_top", texture);
        Object open = orientable ? this.models().trapdoorOrientableOpen(baseName + "_open", texture) : this.models().trapdoorOpen(baseName + "_open", texture);
        this.trapdoorBlock(block, (IModelLocation)bottom, (IModelLocation)top, (IModelLocation)open, orientable);
    }

    public void trapdoorBlock(TrapDoorBlock block, IModelLocation bottom, IModelLocation top, IModelLocation open, boolean orientable) {
        this.getVariantBuilder((Block)block).forAllStatesExcept(state -> {
            int xRot = 0;
            int yRot = (int)((Direction)state.m_61143_((Property)TrapDoorBlock.f_54117_)).m_122435_() + 180;
            boolean isOpen = (Boolean)state.m_61143_((Property)TrapDoorBlock.f_57514_);
            if (orientable && isOpen && state.m_61143_((Property)TrapDoorBlock.f_57515_) == Half.TOP) {
                xRot += 180;
                yRot += 180;
            }
            if (!orientable && !isOpen) {
                yRot = 0;
            }
            return new VariantBlockStateBuilder.VariantBuilder().modelFile(isOpen ? open : (state.m_61143_((Property)TrapDoorBlock.f_57515_) == Half.TOP ? top : bottom)).rotationX(xRot).rotationY(yRot %= 360);
        }, new Property[]{TrapDoorBlock.f_57516_, TrapDoorBlock.f_57517_});
    }
}

