/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.cover;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.NetworkHooks;
import org.gtreimagined.gtlib.Ref;
import org.gtreimagined.gtlib.capability.ICoverHandler;
import org.gtreimagined.gtlib.capability.IGuiHandler;
import org.gtreimagined.gtlib.client.dynamic.IDynamicModelProvider;
import org.gtreimagined.gtlib.cover.CoverFactory;
import org.gtreimagined.gtlib.gui.GuiData;
import org.gtreimagined.gtlib.gui.SlotType;
import org.gtreimagined.gtlib.gui.event.IGuiEvent;
import org.gtreimagined.gtlib.machine.Tier;
import org.gtreimagined.gtlib.machine.event.IMachineEvent;
import org.gtreimagined.gtlib.network.packets.AbstractGuiEventPacket;
import org.gtreimagined.gtlib.registration.ITextureProvider;
import org.gtreimagined.gtlib.texture.Texture;
import org.gtreimagined.gtlib.tool.GTToolType;
import org.gtreimagined.gtlib.util.Utils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ICover
extends ITextureProvider,
IDynamicModelProvider,
MenuProvider,
IGuiHandler {
    public static final ResourceLocation PIPE_COVER_MODEL = new ResourceLocation("gtlib", "block/cover/cover_pipe");
    public static final Cache<Direction, VoxelShape> DEFAULT_SHAPES = CacheBuilder.newBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build();
    public static final ICover empty = new ICover(){

        @Override
        public Direction side() {
            return null;
        }

        @Override
        public CoverFactory getFactory() {
            return emptyFactory;
        }

        @Override
        public Tier getTier() {
            return null;
        }

        @Override
        public void deserialize(CompoundTag nbt) {
        }

        @Override
        public CompoundTag serialize() {
            return new CompoundTag();
        }

        @Override
        public void deserializeStack(@Nullable CompoundTag nbt) {
        }

        @Override
        public CompoundTag serializeStack(CompoundTag nbt) {
            return nbt;
        }

        @Override
        public ItemStack getItem() {
            return ItemStack.f_41583_;
        }

        @Override
        public ICoverHandler<?> source() {
            return null;
        }

        @Override
        public boolean isRemote() {
            return false;
        }

        @Override
        public ResourceLocation getGuiTexture() {
            return null;
        }

        @Override
        public AbstractGuiEventPacket createGuiPacket(IGuiEvent event) {
            return null;
        }

        @Override
        public ResourceLocation getModel(String type, Direction dir) {
            return null;
        }

        @Override
        public Texture[] getTextures() {
            return new Texture[0];
        }

        @Override
        public void setTextures(BiConsumer<String, Texture> texer) {
        }

        @Override
        public boolean ticks() {
            return false;
        }

        @Nullable
        public AbstractContainerMenu m_7208_(int p_createMenu_1_, Inventory p_createMenu_2_, Player p_createMenu_3_) {
            return null;
        }
    };
    public static final CoverFactory emptyFactory = CoverFactory.builder((a, b, c, d) -> empty).build("gtlib", "none");

    default public void onPlace() {
    }

    default public void onCreate() {
    }

    default public boolean canPlace() {
        return true;
    }

    @NotNull
    default public Component m_5446_() {
        return Utils.literal(Utils.underscoreToUpperCamel(this.getId()));
    }

    @Override
    default public void onGuiEvent(IGuiEvent event, Player player) {
    }

    default public boolean onTransfer(Object object, boolean inputSide, boolean simulate) {
        return false;
    }

    public Direction side();

    @Override
    default public ResourceLocation getLoc() {
        return new ResourceLocation(this.getDomain(), this.getId());
    }

    @Override
    default public String getId() {
        return this.getFactory().getId();
    }

    @Override
    default public String getDomain() {
        return this.getFactory().getDomain();
    }

    public CoverFactory getFactory();

    public Tier getTier();

    default public void onRemove() {
    }

    default public void onUpdate() {
    }

    default public void onFirstTick() {
    }

    default public void onBlockUpdate() {
    }

    default public void onBlockUpdateAllSides() {
    }

    @Override
    default public String handlerDomain() {
        return this.getDomain();
    }

    default public void onMachineEvent(IGuiHandler tile, IMachineEvent event, int ... data) {
    }

    default public boolean hasGui() {
        return false;
    }

    default public boolean openGui(Player player, Direction side) {
        if (!this.hasGui()) {
            return false;
        }
        NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)this, packetBuffer -> {
            packetBuffer.m_130064_(this.source().getTile().m_58899_());
            packetBuffer.writeInt(side.m_122411_());
        });
        player.m_6330_(Ref.WRENCH, SoundSource.BLOCKS, 1.0f, 2.0f);
        return true;
    }

    default public Map<SlotType<?>, IItemHandler> getAll() {
        return null;
    }

    default public int getWeakPower() {
        return -1;
    }

    default public int getStrongPower() {
        return -1;
    }

    default public int getPriority(Class<?> clazz) {
        return 0;
    }

    default public InteractionResult onInteract(Player player, InteractionHand hand, Direction side, @Nullable GTToolType type) {
        return InteractionResult.PASS;
    }

    default public boolean ticks() {
        return true;
    }

    public void deserialize(CompoundTag var1);

    public CompoundTag serialize();

    public void deserializeStack(@Nullable CompoundTag var1);

    public CompoundTag serializeStack(CompoundTag var1);

    public ItemStack getItem();

    default public <T> boolean blocksCapability(Class<T> cap, @Nullable Direction side) {
        return false;
    }

    default public <T> boolean blocksInput(Class<T> cap, @Nullable Direction side) {
        return false;
    }

    default public <T> boolean blocksOutput(Class<T> cap, @Nullable Direction side) {
        return false;
    }

    default public boolean blockConnection(Direction side) {
        return false;
    }

    public void setTextures(BiConsumer<String, Texture> var1);

    default public ItemStack getDroppedStack() {
        ItemStack stack = this.getItem();
        CompoundTag nbt = stack.m_41783_() == null ? new CompoundTag() : stack.m_41783_();
        this.serializeStack(nbt);
        if (!nbt.m_128456_()) {
            stack.m_41751_(nbt);
        }
        return stack;
    }

    default public void addInfoFromStack(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        this.deserializeStack(tag);
    }

    default public boolean isEqual(ICover cover) {
        return this.getLoc().equals((Object)cover.getLoc());
    }

    default public boolean isEqual(CoverFactory fac) {
        return this.getLoc().equals((Object)new ResourceLocation(fac.domain, fac.getId()));
    }

    public ICoverHandler<?> source();

    @Override
    default public GuiData getGui() {
        return null;
    }

    default public List<BakedQuad> transformQuads(BlockState state, List<BakedQuad> quads) {
        return quads;
    }

    default public VoxelShape getShape(Direction side) throws ExecutionException {
        return (VoxelShape)DEFAULT_SHAPES.get((Object)side, () -> this.makeShapes(side));
    }

    default public VoxelShape makeShapes(Direction side) {
        return switch (side) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN -> Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.0625, (double)1.0);
            case Direction.UP -> Shapes.m_83048_((double)0.0, (double)0.9375, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
            case Direction.NORTH -> Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)0.0625);
            case Direction.SOUTH -> Shapes.m_83048_((double)0.0, (double)0.0, (double)0.9375, (double)1.0, (double)1.0, (double)1.0);
            case Direction.WEST -> Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)0.0625, (double)1.0, (double)1.0);
            case Direction.EAST -> Shapes.m_83048_((double)0.9375, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
        };
    }

    default public ResourceLocation getIdForCache() {
        return new ResourceLocation("gtlib", "cover");
    }

    default public boolean isEmpty() {
        return this == empty;
    }

    default public boolean isNode() {
        return !this.isEmpty();
    }

    default public List<String> getInfo(boolean simple) {
        return List.of();
    }

    public static void init() {
    }

    public static class DynamicKey {
        public final Direction facing;
        public final Texture machineTexture;
        public final String coverId;

        public DynamicKey(Direction facing, Texture tex, String cover) {
            this.facing = facing;
            this.machineTexture = tex;
            this.coverId = cover;
        }

        public DynamicKey(BlockState state, Texture tex, String cover) {
            this.facing = state.m_61138_((Property)BlockStateProperties.f_61372_) ? (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_) : (state.m_61138_((Property)BlockStateProperties.f_61374_) ? (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_) : Direction.SOUTH);
            this.machineTexture = tex;
            this.coverId = cover;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.facing, this.machineTexture, this.coverId});
        }

        public boolean equals(Object o) {
            if (o instanceof DynamicKey) {
                DynamicKey k = (DynamicKey)o;
                return k.facing == this.facing && k.machineTexture.equals((Object)this.machineTexture) && this.coverId.equals(k.coverId);
            }
            return false;
        }
    }
}

