/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.client;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.gtreimagined.gtlib.machine.types.Machine;

@OnlyIn(value=Dist.CLIENT)
public class SoundHelper {
    private static final Map<Level, Map<BlockPos, SoundInstance>> MACHINE_SOUNDS = new Object2ObjectOpenHashMap();

    public static void startLoop(Machine<?> machine, Level level, BlockPos pos) {
        Minecraft mc = Minecraft.m_91087_();
        SimpleSoundInstance simplesoundinstance = new SimpleSoundInstance(machine.machineNoise.m_11660_(), SoundSource.BLOCKS, machine.soundVolume, 1.0f, level.m_213780_(), true, 0, SoundInstance.Attenuation.LINEAR, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), false);
        mc.m_91106_().m_120367_((SoundInstance)simplesoundinstance);
        MACHINE_SOUNDS.computeIfAbsent(level, l -> new Object2ObjectOpenHashMap()).put(pos, simplesoundinstance);
    }

    public static void worldUnload(LevelAccessor world) {
        Map<BlockPos, SoundInstance> sounds = MACHINE_SOUNDS.remove(world);
        if (sounds != null) {
            for (SoundInstance value : sounds.values()) {
                Minecraft.m_91087_().m_91106_().m_120399_(value);
            }
        }
    }

    public static void clear(Level level, BlockPos pos) {
        Map<BlockPos, SoundInstance> map = MACHINE_SOUNDS.get(level);
        if (map == null) {
            return;
        }
        SoundInstance instance = map.remove(pos);
        if (instance != null) {
            Minecraft.m_91087_().m_91106_().m_120399_(instance);
        }
    }
}

