/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.worldgen;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.GTLib;
import org.gtreimagined.gtlib.data.GTMaterialTypes;
import org.gtreimagined.gtlib.data.VanillaStoneTypes;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.material.MaterialType;
import org.gtreimagined.gtlib.material.MaterialTypeBlock;
import org.gtreimagined.gtlib.ore.StoneType;
import org.gtreimagined.gtlib.worldgen.feature.FeatureOre;
import org.gtreimagined.gtlib.worldgen.vein.VeinSavedData;
import org.jetbrains.annotations.Nullable;

public class WorldGenHelper {
    public static Object2ObjectOpenHashMap<BlockState, StoneType> STONE_MAP = new Object2ObjectOpenHashMap();
    public static ObjectOpenHashSet<BlockState> ROCK_SET = new ObjectOpenHashSet();
    public static ObjectOpenHashSet<BlockState> STONE_SET = new ObjectOpenHashSet();
    public static ObjectOpenHashSet<BlockState> TREE_SET = new ObjectOpenHashSet();
    public static ObjectOpenHashSet<String> TREE_BIOME_SET = new ObjectOpenHashSet();
    public static BlockState STONE_STATE = Blocks.f_50069_.m_49966_();
    public static BlockState WATER_STATE = Blocks.f_49990_.m_49966_();
    public static Predicate<BlockState> ORE_PREDICATE = state -> STONE_MAP.containsKey(state);
    public static Predicate<BlockState> ROCK_PREDICATE = state -> ROCK_SET.contains(state);
    public static Predicate<BlockState> STONE_PREDICATE = state -> STONE_SET.contains(state);

    public static void init() {
        GTAPI.all(StoneType.class).forEach(t -> STONE_MAP.put((Object)t.getState(), t));
        ROCK_SET.add((Object)Blocks.f_50016_.m_49966_());
        ROCK_SET.add((Object)Blocks.f_49990_.m_49966_());
        STONE_SET.add((Object)Blocks.f_50069_.m_49966_());
        STONE_SET.add((Object)Blocks.f_50122_.m_49966_());
        STONE_SET.add((Object)Blocks.f_50334_.m_49966_());
        STONE_SET.add((Object)Blocks.f_50228_.m_49966_());
        STONE_SET.add((Object)Blocks.f_50259_.m_49966_());
        STONE_SET.add((Object)Blocks.f_50134_.m_49966_());
        STONE_SET.add((Object)Blocks.f_152550_.m_49966_());
        STONE_SET.add((Object)Blocks.f_152496_.m_49966_());
        STONE_SET.add((Object)Blocks.f_49997_.m_49966_());
        STONE_SET.add((Object)Blocks.f_49996_.m_49966_());
        STONE_SET.add((Object)Blocks.f_49995_.m_49966_());
        STONE_SET.add((Object)Blocks.f_50089_.m_49966_());
        STONE_SET.add((Object)Blocks.f_50264_.m_49966_());
        STONE_SET.add((Object)Blocks.f_50059_.m_49966_());
        STONE_SET.add((Object)Blocks.f_50173_.m_49966_());
        TREE_SET.add((Object)Blocks.f_50034_.m_49966_());
        TREE_BIOME_SET.add((Object)"Forest");
        TREE_BIOME_SET.add((Object)"ForestHills");
    }

    public static boolean setState(LevelAccessor world, BlockPos pos, BlockState state) {
        if (state == null) {
            GTLib.LOGGER.error("WorldGenHelper: tried to place null state at " + pos.toString());
            return false;
        }
        return world.m_7731_(pos, state, 0);
    }

    public static boolean setOre(LevelAccessor world, BlockPos pos, BlockState existing, Material material, MaterialType<?> type) {
        BlockState oreState;
        StoneType stone = (StoneType)STONE_MAP.get((Object)existing);
        if (stone == null || !stone.doesGenerateOre() || stone == VanillaStoneTypes.BEDROCK) {
            return false;
        }
        BlockState blockState = oreState = type == GTMaterialTypes.ORE ? ((MaterialTypeBlock.IOreGetter)GTMaterialTypes.ORE.get()).get(material, stone).asState() : ((MaterialTypeBlock.IOreGetter)GTMaterialTypes.SMALL_ORE.get()).get(material, stone).asState();
        if (!ORE_PREDICATE.test(existing)) {
            return false;
        }
        boolean setState = WorldGenHelper.setState(world, pos, oreState);
        if (setState && (type == GTMaterialTypes.ORE || type == GTMaterialTypes.SMALL_ORE)) {
            ServerLevel serverLevel = null;
            if (world instanceof ServerLevel) {
                ServerLevel serverLevel1;
                serverLevel = serverLevel1 = (ServerLevel)world;
            }
            if (world instanceof WorldGenRegion) {
                WorldGenRegion worldGenRegion = (WorldGenRegion)world;
                serverLevel = worldGenRegion.m_6018_();
            }
            if (serverLevel != null) {
                VeinSavedData.getOrCreate(serverLevel).addOreToChunk(SectionPos.m_123171_((int)pos.m_123341_()), SectionPos.m_123171_((int)pos.m_123343_()), material, pos);
            }
        }
        return setState;
    }

    public static boolean setOre(LevelAccessor world, BlockPos pos, Material material, MaterialType<?> type) {
        BlockState existing = world.m_8055_(pos);
        return WorldGenHelper.setOre(world, pos, existing, material, type);
    }

    public static boolean addOre(LevelAccessor world, BlockPos pos, Material material, boolean normalOre) {
        ((List)FeatureOre.ORES.computeIfAbsent((Object)world.m_46865_(pos).m_7697_(), k -> new ObjectArrayList())).add(new ImmutableTriple((Object)pos, (Object)material, (Object)normalOre));
        return true;
    }

    public static boolean addRock(LevelAccessor world, BlockPos pos, Material material, int chance) {
        int y = Math.min(world.m_6924_(Heightmap.Types.OCEAN_FLOOR, pos.m_123341_(), pos.m_123343_()), world.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, pos.m_123341_(), pos.m_123343_()));
        BlockState state = WorldGenHelper.getStoneStateForRock(y - 1, pos, world);
        return WorldGenHelper.setRock(world, new BlockPos(pos.m_123341_(), y, pos.m_123343_()), material, state, chance);
    }

    public static BlockState getStoneStateForRock(int y, BlockPos pos, LevelAccessor world) {
        BlockState fill = world.m_8055_(new BlockPos(pos.m_123341_(), y, pos.m_123343_()));
        StoneType stone = (StoneType)STONE_MAP.get((Object)fill);
        if (y <= world.m_141937_() || stone == VanillaStoneTypes.BEDROCK) {
            return fill;
        }
        if (stone == null || !stone.doesGenerateOre()) {
            return WorldGenHelper.getStoneStateForRock(y - 1, pos, world);
        }
        return fill;
    }

    public static boolean setRock(LevelAccessor world, BlockPos pos, Material material, @Nullable BlockState fill, int chance) {
        StoneType stone;
        if (world.m_213780_().m_188503_(chance) != 0) {
            return false;
        }
        StoneType stoneType = stone = fill != null ? (StoneType)STONE_MAP.get((Object)fill) : null;
        if (material == Material.NULL && stone == null) {
            return false;
        }
        BlockState rockState = material == Material.NULL ? ((MaterialTypeBlock.IBlockGetter)GTMaterialTypes.ROCK.get()).get(stone.getMaterial()).asState() : ((MaterialTypeBlock.IOreGetter)GTMaterialTypes.BEARING_ROCK.get()).get(material, stone != null && stone.doesGenerateOre() ? stone : VanillaStoneTypes.STONE).asState();
        BlockState existingBelow = world.m_8055_(pos.m_7495_());
        if (existingBelow.m_60795_() || !existingBelow.m_60767_().m_76333_()) {
            return false;
        }
        BlockState existing = world.m_8055_(pos);
        if (!ROCK_PREDICATE.test(existing)) {
            return false;
        }
        if (existing == WATER_STATE) {
            rockState = WorldGenHelper.waterLogState(rockState);
        }
        return WorldGenHelper.setState(world, pos, rockState);
    }

    public static boolean setStone(LevelAccessor world, BlockPos pos, BlockState existing, BlockState replacement) {
        if (!STONE_PREDICATE.test(existing)) {
            return false;
        }
        return WorldGenHelper.setState(world, pos, replacement);
    }

    public static BlockState waterLogState(BlockState state) {
        return state.m_61138_((Property)BlockStateProperties.f_61362_) ? (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(true)) : state;
    }
}

