/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.worldgen;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.teamresourceful.resourcefullib.common.lib.Constants;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.Level;
import org.gtreimagined.gtlib.GTLib;
import org.gtreimagined.gtlib.network.PacketHelper;
import org.gtreimagined.gtlib.worldgen.IWorldgenObject;
import org.slf4j.Logger;

public abstract class BaseWorldGenData<T extends IWorldgenObject<T>>
extends SimpleJsonResourceReloadListener {
    protected final Map<ResourceLocation, T> VEINS = new Object2ObjectOpenHashMap();
    private final String name;
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public BaseWorldGenData(String subDirectory, String name) {
        super(GSON, "gt_worldgen/" + subDirectory);
        this.name = name;
    }

    protected abstract Codec<T> getCodec();

    protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        HashMap<ResourceLocation, IWorldgenObject> layers = new HashMap<ResourceLocation, IWorldgenObject>();
        for (Map.Entry<ResourceLocation, JsonElement> entry : map.entrySet()) {
            JsonObject vein = GsonHelper.m_13918_((JsonElement)entry.getValue(), (String)this.name);
            vein.addProperty("id", entry.getKey().toString());
            layers.put(entry.getKey(), (IWorldgenObject)this.getCodec().parse((DynamicOps)JsonOps.INSTANCE, (Object)vein).getOrThrow(false, arg_0 -> ((org.apache.logging.log4j.Logger)GTLib.LOGGER).error(arg_0)));
        }
        this.updateVeins(layers);
    }

    public void updateVeins(Map<ResourceLocation, T> veins) {
        this.clear();
        this.VEINS.putAll(veins);
    }

    protected void clear() {
        this.VEINS.clear();
    }

    public Map<ResourceLocation, T> getVeins() {
        return this.VEINS;
    }

    public Map<ResourceLocation, T> getVeins(Level level) {
        return this.VEINS.entrySet().stream().filter(v -> ((IWorldgenObject)v.getValue()).getDimensions().contains(level.m_46472_())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public void encodeVeins(FriendlyByteBuf buf) {
        buf.m_130130_(this.VEINS.size());
        this.VEINS.forEach((resourceLocation, vein) -> {
            buf.m_130085_(resourceLocation);
            PacketHelper.writeWithYabn(buf, this.getCodec(), vein, true).get().mapRight(DataResult.PartialResult::message).ifRight(arg_0 -> ((Logger)Constants.LOGGER).error(arg_0));
        });
    }

    public Map<ResourceLocation, T> decodeVeins(FriendlyByteBuf buf) {
        HashMap<ResourceLocation, IWorldgenObject> result = new HashMap<ResourceLocation, IWorldgenObject>();
        int size = buf.m_130242_();
        for (int i = 0; i < size; ++i) {
            ResourceLocation key = buf.m_130281_();
            Optional vein = PacketHelper.readWithYabn(buf, this.getCodec(), true).get().mapRight(DataResult.PartialResult::message).ifRight(arg_0 -> ((Logger)Constants.LOGGER).error(arg_0)).left();
            if (!vein.isPresent()) {
                GTLib.LOGGER.error(this.name + " packet errored", (Throwable)new NoSuchElementException("No value present"));
                return Collections.emptyMap();
            }
            result.put(key, (IWorldgenObject)vein.get());
        }
        return result;
    }
}

