/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.tool.behaviour;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BambooBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CactusBlock;
import net.minecraft.world.level.block.ChorusFlowerBlock;
import net.minecraft.world.level.block.ChorusPlantBlock;
import net.minecraft.world.level.block.KelpBlock;
import net.minecraft.world.level.block.KelpPlantBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.SugarCaneBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.gtreimagined.gtlib.GTLibConfig;
import org.gtreimagined.gtlib.behaviour.IBlockDestroyed;
import org.gtreimagined.gtlib.tool.IBasicGTTool;
import org.gtreimagined.gtlib.util.Utils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BehaviourTreeFelling
implements IBlockDestroyed<IBasicGTTool> {
    public static final BehaviourTreeFelling INSTANCE = new BehaviourTreeFelling();
    public static final Tree NO_TREE = new Tree(Collections.emptyList());

    @Override
    public String getId() {
        return "tree_felling";
    }

    @Override
    public boolean onBlockDestroyed(IBasicGTTool instance, ItemStack stack, Level world, BlockState state, BlockPos pos, LivingEntity entity) {
        if (!GTLibConfig.AXE_TIMBER.get()) {
            return true;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!world.f_46443_ && instance.genericIsCorrectToolForDrops(stack, state) && !player.m_6047_() && state.m_204336_(BlockTags.f_13106_)) {
                Utils.treeLogging(instance.getGTToolType(), stack, pos, player, world);
            }
        }
        return true;
    }

    @NotNull
    public static Tree findTree(@Nullable BlockGetter reader, BlockPos pos) {
        if (reader == null) {
            return NO_TREE;
        }
        ArrayList<BlockPos> logs = new ArrayList<BlockPos>();
        ArrayList leaves = new ArrayList();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        LinkedList<BlockPos> frontier = new LinkedList<BlockPos>();
        BlockState stateAbove = reader.m_8055_(pos.m_7494_());
        if (BehaviourTreeFelling.isVerticalPlant(stateAbove)) {
            BlockPos current;
            logs.add(pos.m_7494_());
            for (int i = 1; i < 256 && BehaviourTreeFelling.isVerticalPlant(reader.m_8055_(current = pos.m_6630_(i))); ++i) {
                logs.add(current);
            }
            Collections.reverse(logs);
            return new Tree(logs);
        }
        if (BehaviourTreeFelling.isChorus(stateAbove)) {
            frontier.add(pos.m_7494_());
            while (!frontier.isEmpty()) {
                BlockPos current = (BlockPos)frontier.remove(0);
                visited.add(current);
                logs.add(current);
                for (Direction direction : Direction.values()) {
                    BlockPos offset = current.m_121945_(direction);
                    if (visited.contains(offset) || !BehaviourTreeFelling.isChorus(reader.m_8055_(offset))) continue;
                    frontier.add(offset);
                }
            }
            Collections.reverse(logs);
            return new Tree(logs);
        }
        if (!BehaviourTreeFelling.validateCut(reader, pos)) {
            return NO_TREE;
        }
        visited.add(pos);
        BlockPos.m_121990_((BlockPos)pos.m_7918_(-1, 0, -1), (BlockPos)pos.m_7918_(1, 1, 1)).forEach(p -> frontier.add(new BlockPos((Vec3i)p)));
        while (!frontier.isEmpty()) {
            BlockPos currentPos2 = (BlockPos)frontier.remove(0);
            if (visited.contains(currentPos2)) continue;
            visited.add(currentPos2);
            if (!BehaviourTreeFelling.isLog(reader.m_8055_(currentPos2))) continue;
            logs.add(currentPos2);
            BehaviourTreeFelling.forNeighbours(currentPos2, visited, true, p -> frontier.add(new BlockPos((Vec3i)p)));
        }
        visited.clear();
        visited.addAll(logs);
        frontier.addAll(logs);
        while (!frontier.isEmpty()) {
            BlockPos prevPos = (BlockPos)frontier.remove(0);
            if (!logs.contains(prevPos) && visited.contains(prevPos)) continue;
            visited.add(prevPos);
            BlockState prevState = reader.m_8055_(prevPos);
            int prevLeafDistance = BehaviourTreeFelling.isLeaf(prevState) ? BehaviourTreeFelling.getLeafDistance(prevState) : 0;
            BehaviourTreeFelling.forNeighbours(prevPos, visited, false, currentPos -> {
                BlockState state = reader.m_8055_(currentPos);
                BlockPos subtract = currentPos.m_121996_((Vec3i)pos);
                BlockPos currentPosImmutable = currentPos.m_7949_();
                int horizontalDistance = Math.max(Math.abs(subtract.m_123341_()), Math.abs(subtract.m_123343_()));
                if (horizontalDistance <= BehaviourTreeFelling.nonDecayingLeafDistance(state)) {
                    leaves.add(currentPosImmutable);
                    frontier.add(currentPosImmutable);
                    return;
                }
                if (BehaviourTreeFelling.isLeaf(state) && BehaviourTreeFelling.getLeafDistance(state) > prevLeafDistance) {
                    leaves.add(currentPosImmutable);
                    frontier.add(currentPosImmutable);
                }
            });
        }
        return new Tree(logs);
    }

    private static int getLeafDistance(BlockState state) {
        IntegerProperty distanceProperty = LeavesBlock.f_54418_;
        for (Property property : state.m_61148_().keySet()) {
            if (!(property instanceof IntegerProperty)) continue;
            IntegerProperty ip = (IntegerProperty)property;
            if (!property.m_61708_().equals("distance")) continue;
            distanceProperty = ip;
        }
        return (Integer)state.m_61143_((Property)distanceProperty);
    }

    public static boolean isChorus(BlockState stateAbove) {
        return stateAbove.m_60734_() instanceof ChorusPlantBlock || stateAbove.m_60734_() instanceof ChorusFlowerBlock;
    }

    public static boolean isVerticalPlant(BlockState stateAbove) {
        Block block = stateAbove.m_60734_();
        if (block instanceof BambooBlock) {
            return true;
        }
        if (block instanceof CactusBlock) {
            return true;
        }
        if (block instanceof SugarCaneBlock) {
            return true;
        }
        if (block instanceof KelpPlantBlock) {
            return true;
        }
        return block instanceof KelpBlock;
    }

    private static boolean validateCut(BlockGetter reader, BlockPos pos) {
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        LinkedList<BlockPos> frontier = new LinkedList<BlockPos>();
        frontier.add(pos);
        frontier.add(pos.m_7494_());
        int posY = pos.m_123342_();
        while (!frontier.isEmpty()) {
            boolean lowerLayer;
            BlockPos currentPos = (BlockPos)frontier.remove(0);
            visited.add(currentPos);
            boolean bl = lowerLayer = currentPos.m_123342_() == posY;
            if (!BehaviourTreeFelling.isLog(reader.m_8055_(currentPos))) continue;
            if (!lowerLayer && !pos.equals((Object)currentPos.m_7495_()) && BehaviourTreeFelling.isLog(reader.m_8055_(currentPos.m_7495_()))) {
                return false;
            }
            for (Direction direction : Direction.values()) {
                BlockPos offset;
                if (direction == Direction.DOWN || direction == Direction.UP && !lowerLayer || visited.contains(offset = currentPos.m_121945_(direction))) continue;
                frontier.add(offset);
            }
        }
        return true;
    }

    private static void forNeighbours(BlockPos pos, Set<BlockPos> visited, boolean up, Consumer<BlockPos> acceptor) {
        BlockPos.m_121990_((BlockPos)pos.m_7918_(-1, up ? 0 : -1, -1), (BlockPos)pos.m_7918_(1, 1, 1)).filter(((Predicate<BlockPos>)visited::contains).negate()).forEach(acceptor);
    }

    public static boolean isLog(BlockState state) {
        return state.m_204336_(BlockTags.f_13106_) || state.m_60713_(Blocks.f_50182_);
    }

    private static int nonDecayingLeafDistance(BlockState state) {
        if (state.m_60713_(Blocks.f_50181_)) {
            return 2;
        }
        if (state.m_60713_(Blocks.f_50180_)) {
            return 3;
        }
        if (state.m_204336_(BlockTags.f_13078_) || state.m_60713_(Blocks.f_50702_) || state.m_60713_(Blocks.f_50703_)) {
            return 3;
        }
        return -1;
    }

    private static boolean isLeaf(BlockState state) {
        for (Property property : state.m_61148_().keySet()) {
            if (!(property instanceof IntegerProperty) || !property.m_61708_().equals("distance")) continue;
            return true;
        }
        return false;
    }

    public static class Tree {
        private final List<BlockPos> logs;

        public Tree(List<BlockPos> logs) {
            this.logs = logs;
        }

        public List<BlockPos> getLogs() {
            return this.logs;
        }
    }
}

