/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.tool.behaviour;

import java.util.List;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.gtreimagined.gtlib.behaviour.IAddInformation;
import org.gtreimagined.gtlib.behaviour.IBlockDestroyed;
import org.gtreimagined.gtlib.behaviour.IDestroySpeed;
import org.gtreimagined.gtlib.behaviour.IItemRightClick;
import org.gtreimagined.gtlib.tool.IBasicGTTool;
import org.gtreimagined.gtlib.util.Utils;

public class BehaviourAOEBreak
implements IBlockDestroyed<IBasicGTTool>,
IItemRightClick<IBasicGTTool>,
IAddInformation<IBasicGTTool>,
IDestroySpeed<IBasicGTTool> {
    protected int column;
    protected int row;
    protected int depth;
    protected int destroySpedDivider;
    protected String tooltipKey;

    public BehaviourAOEBreak(int column, int row, int depth, int destroySpeedDivider, String tooltipKey) {
        if (column == 0 && row == 0) {
            Utils.onInvalidData("BehaviourAOEBreak was set to break empty rows and columns!");
        }
        this.column = column;
        this.row = row;
        this.depth = depth;
        this.destroySpedDivider = destroySpeedDivider;
        this.tooltipKey = tooltipKey;
    }

    @Override
    public String getId() {
        return "aoe_break";
    }

    @Override
    public float getDestroySpeed(IBasicGTTool instance, float currentDestroySpeed, ItemStack stack, BlockState state) {
        CompoundTag tag = instance.getDataTag(stack);
        if (tag == null || !tag.m_128471_("aoe")) {
            return currentDestroySpeed;
        }
        return currentDestroySpeed / (float)this.destroySpedDivider;
    }

    @Override
    public void onAddInformation(IBasicGTTool instance, ItemStack stack, List<Component> tooltip, TooltipFlag flag) {
        CompoundTag tag = instance.getDataTag(stack);
        boolean enabled = tag != null && tag.m_128471_("aoe");
        tooltip.add((Component)Utils.translatable("gtlib.tooltip.behaviour.aoe_right_click", Utils.translatable("gtlib.behaviour." + this.tooltipKey, new Object[0])));
        String suffix = enabled ? "enabled" : "disabled";
        tooltip.add((Component)Utils.translatable("gtlib.tooltip.behaviour.aoe_" + suffix, Utils.translatable("gtlib.behaviour." + this.tooltipKey, new Object[0])));
    }

    @Override
    public InteractionResultHolder<ItemStack> onRightClick(IBasicGTTool instance, Level level, Player player, InteractionHand usedHand) {
        ItemStack stack = player.m_21120_(usedHand);
        if (player.m_6144_() && !level.f_46443_) {
            CompoundTag tag;
            boolean enabled = (tag = instance.getOrCreateDataTag(stack)).m_128471_("aoe");
            tag.m_128379_("aoe", !enabled);
            player.m_5661_((Component)Utils.literal("Mode set to " + !enabled), false);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    @Override
    public boolean onBlockDestroyed(IBasicGTTool instance, ItemStack stack, Level world, BlockState state, BlockPos pos, LivingEntity entity) {
        if (!(entity instanceof Player)) {
            return true;
        }
        Player player = (Player)entity;
        CompoundTag tag = instance.getDataTag(stack);
        if (tag == null || !tag.m_128471_("aoe") || player.m_6047_() || player.m_9236_().f_46443_) {
            return true;
        }
        for (BlockPos blockPos : Utils.getHarvestableBlocksToBreak(world, player, instance, stack, this.column, this.row, this.depth)) {
            if (!instance.hasEnoughDurability(stack, instance.getGTToolType().getUseDurability(), instance.getGTToolType().isPowered())) {
                return true;
            }
            if (Utils.breakBlock(world, player, stack, blockPos, instance.getGTToolType().getUseDurability())) continue;
            break;
        }
        return true;
    }

    @Generated
    public int getColumn() {
        return this.column;
    }

    @Generated
    public int getRow() {
        return this.row;
    }

    @Generated
    public int getDepth() {
        return this.depth;
    }
}

