/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.recipe;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import org.gtreimagined.gtlib.Ref;
import org.gtreimagined.gtlib.recipe.IRecipe;
import org.gtreimagined.gtlib.recipe.IRecipeValidator;
import org.gtreimagined.gtlib.recipe.ingredient.FluidIngredient;
import org.gtreimagined.gtlib.recipe.ingredient.RecipeIngredient;
import org.gtreimagined.gtlib.recipe.map.RecipeMap;
import org.gtreimagined.gtlib.recipe.serializer.MachineRecipeSerializer;
import org.gtreimagined.gtlib.util.RegistryUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Recipe
implements IRecipe {
    private final ItemStack[] itemsOutput;
    @NotNull
    private final List<Ingredient> itemsInput;
    @NotNull
    private final List<FluidIngredient> fluidsInput;
    private final FluidStack[] fluidsOutput;
    private final int duration;
    private final int special;
    private final long power;
    private final int amps;
    private int[] outputChances;
    private int[] inputChances;
    private boolean hidden;
    private boolean fake;
    private Set<String> tags = new ObjectOpenHashSet();
    public ResourceLocation id;
    public String mapId;
    public final List<IRecipeValidator> validators = Collections.emptyList();
    private boolean valid;
    public static final RecipeType<Recipe> RECIPE_TYPE = RecipeType.simple((ResourceLocation)new ResourceLocation("gtlib", "machine"));

    public static void init() {
    }

    public Recipe(@NotNull List<Ingredient> stacksInput, ItemStack[] stacksOutput, @NotNull List<FluidIngredient> fluidsInput, FluidStack[] fluidsOutput, int duration, long power, int special, int amps) {
        this.itemsInput = ImmutableList.copyOf(stacksInput);
        this.itemsOutput = stacksOutput;
        this.duration = duration;
        this.power = power;
        this.special = special;
        this.fluidsInput = ImmutableList.copyOf(fluidsInput);
        this.amps = amps;
        this.fluidsOutput = fluidsOutput;
        this.valid = true;
    }

    @Override
    public void invalidate() {
        if (this.id != null) {
            this.valid = false;
        }
    }

    @Override
    public void addOutputChances(int[] chances) {
        this.outputChances = chances;
    }

    @Override
    public void addInputChances(int[] chances) {
        this.inputChances = chances;
    }

    @Override
    public void addTags(Set<String> tags) {
        this.tags = tags;
    }

    @Override
    public boolean hasInputItems() {
        return !this.itemsInput.isEmpty();
    }

    @Override
    public boolean hasOutputItems() {
        return this.itemsOutput != null && this.itemsOutput.length > 0;
    }

    @Override
    public boolean hasInputFluids() {
        return !this.fluidsInput.isEmpty();
    }

    @Override
    public boolean hasOutputFluids() {
        return this.fluidsOutput != null && this.fluidsOutput.length > 0;
    }

    @Override
    public boolean hasOutputChances() {
        return this.outputChances != null && this.outputChances.length == this.itemsOutput.length;
    }

    @Override
    public boolean hasInputChances() {
        return this.inputChances != null && this.inputChances.length == this.itemsInput.size();
    }

    @Override
    public void setIds(ResourceLocation id, String map) {
        this.id = id;
        this.mapId = map;
    }

    @Override
    public void setId(ResourceLocation id) {
        this.id = id;
    }

    @Override
    public void setMapId(String mapId) {
        this.mapId = mapId;
    }

    @Override
    public void sortInputItems() {
        this.itemsInput.sort((a, b) -> {
            boolean a2;
            boolean a1 = RecipeMap.isIngredientSpecial(a);
            if (a1 == (a2 = RecipeMap.isIngredientSpecial(b))) {
                return 0;
            }
            if (a1) {
                return 1;
            }
            return -1;
        });
    }

    @Override
    @NotNull
    public List<Ingredient> getInputItems() {
        return this.hasInputItems() ? this.itemsInput : Collections.emptyList();
    }

    @NotNull
    public List<RecipeIngredient> getCastedInputs() {
        return this.hasInputItems() ? this.itemsInput.stream().filter(t -> t instanceof RecipeIngredient).map(t -> (RecipeIngredient)((Object)t)).collect(Collectors.toList()) : Collections.emptyList();
    }

    @Override
    @Nullable
    public ItemStack[] getOutputItems() {
        return this.getOutputItems(true);
    }

    @Override
    public ItemStack[] getOutputItems(boolean chance) {
        if (this.hasOutputItems()) {
            ItemStack[] outputs = (ItemStack[])this.itemsOutput.clone();
            if (this.outputChances != null) {
                ObjectArrayList evaluated = new ObjectArrayList();
                for (int i = 0; i < outputs.length; ++i) {
                    if (chance && Ref.RNG.m_188503_(10000) >= this.outputChances[i]) continue;
                    evaluated.add(outputs[i].m_41777_());
                }
                outputs = evaluated.toArray(new ItemStack[0]);
            }
            return outputs;
        }
        return null;
    }

    @Override
    public ItemStack[] getFlatOutputItems() {
        if (this.hasOutputItems()) {
            ItemStack[] outputs = (ItemStack[])this.itemsOutput.clone();
            if (this.outputChances != null) {
                ObjectArrayList evaluated = new ObjectArrayList();
                for (int i = 0; i < outputs.length; ++i) {
                    if (this.outputChances[i] < 10000) continue;
                    evaluated.add(outputs[i]);
                }
                outputs = evaluated.toArray(new ItemStack[0]);
            }
            return outputs;
        }
        return null;
    }

    @Override
    public boolean hasSpecialIngredients() {
        for (Ingredient ingredient : this.itemsInput) {
            if (!RecipeMap.isIngredientSpecial(ingredient)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public List<FluidIngredient> getInputFluids() {
        return this.fluidsInput;
    }

    @Override
    @Nullable
    public FluidStack[] getOutputFluids() {
        return this.hasOutputFluids() ? (FluidStack[])this.fluidsOutput.clone() : null;
    }

    @Override
    public int @Nullable [] getOutputChances() {
        return this.outputChances;
    }

    @Override
    public int @Nullable [] getInputChances() {
        return this.inputChances;
    }

    @Override
    public int getSpecialValue() {
        return this.special;
    }

    @Override
    public boolean isFake() {
        return this.fake;
    }

    public String toString() {
        int i;
        StringBuilder builder = new StringBuilder();
        if (!this.itemsInput.isEmpty()) {
            builder.append("\nInput Items: { ");
            for (i = 0; i < this.itemsInput.size(); ++i) {
                builder.append("\n Item ").append(i);
                builder.append(this.itemsInput.get(i).m_43942_());
                if (i == this.itemsInput.size() - 1) continue;
                builder.append(", ");
            }
            builder.append(" }\n");
        }
        if (this.itemsOutput != null) {
            builder.append("Output Items: { ");
            for (i = 0; i < this.itemsOutput.length; ++i) {
                builder.append(this.itemsOutput[i].m_41786_()).append(" x").append(this.itemsOutput[i].m_41613_());
                if (i == this.itemsOutput.length - 1) continue;
                builder.append(", ");
            }
            builder.append(" }\n");
        }
        if (!this.fluidsInput.isEmpty()) {
            builder.append("Input Fluids: { ");
            builder.append(" }\n");
        }
        if (this.fluidsOutput != null) {
            builder.append("Output Fluids: { ");
            for (i = 0; i < this.fluidsOutput.length; ++i) {
                builder.append(RegistryUtils.getIdFromFluid(this.fluidsOutput[i].getFluid())).append(": ").append(this.fluidsOutput[i].getAmount()).append("mb");
                if (i == this.fluidsOutput.length - 1) continue;
                builder.append(", ");
            }
            builder.append(" }\n");
        }
        if (this.outputChances != null) {
            builder.append("Output Chances: { ");
            for (i = 0; i < this.outputChances.length; ++i) {
                builder.append((float)this.outputChances[i] / 100.0f).append("%");
                if (i == this.outputChances.length - 1) continue;
                builder.append(", ");
            }
            builder.append(" }\n");
        }
        if (this.inputChances != null) {
            builder.append("Input Chances: { ");
            for (i = 0; i < this.inputChances.length; ++i) {
                builder.append((float)this.inputChances[i] / 100.0f).append("%");
                if (i == this.inputChances.length - 1) continue;
                builder.append(", ");
            }
            builder.append(" }\n");
        }
        builder.append("Special: ").append(this.special).append("\n");
        return builder.toString();
    }

    public boolean m_5818_(Container inv, Level worldIn) {
        return false;
    }

    public ItemStack m_5874_(Container inv) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return false;
    }

    public ItemStack m_8043_() {
        return ItemStack.f_41583_;
    }

    @Override
    public String getMapId() {
        return this.mapId;
    }

    public ResourceLocation m_6423_() {
        return this.id != null ? this.id : new ResourceLocation("gtlib", "default");
    }

    public RecipeSerializer<?> m_7707_() {
        return MachineRecipeSerializer.INSTANCE;
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return RECIPE_TYPE;
    }

    public boolean m_5598_() {
        return true;
    }

    @Override
    public List<IRecipeValidator> getValidators() {
        return this.validators;
    }

    @Override
    @Generated
    public int getDuration() {
        return this.duration;
    }

    @Override
    @Generated
    public long getPower() {
        return this.power;
    }

    @Override
    @Generated
    public int getAmps() {
        return this.amps;
    }

    @Override
    @Generated
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    @Generated
    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    @Override
    @Generated
    public void setFake(boolean fake) {
        this.fake = fake;
    }

    @Override
    @Generated
    public Set<String> getTags() {
        return this.tags;
    }

    @Override
    @Generated
    public boolean isValid() {
        return this.valid;
    }
}

