/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.proxy;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.registries.ForgeRegistries;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.block.BlockFakeTile;
import org.gtreimagined.gtlib.block.BlockFrame;
import org.gtreimagined.gtlib.block.BlockStorage;
import org.gtreimagined.gtlib.block.BlockSurfaceRock;
import org.gtreimagined.gtlib.client.GTTextureStitcher;
import org.gtreimagined.gtlib.client.ModelUtils;
import org.gtreimagined.gtlib.client.tesr.MachineTESR;
import org.gtreimagined.gtlib.cover.CoverFactory;
import org.gtreimagined.gtlib.cover.ICover;
import org.gtreimagined.gtlib.data.GTMaterialTypes;
import org.gtreimagined.gtlib.fluid.GTFluid;
import org.gtreimagined.gtlib.gui.MenuHandler;
import org.gtreimagined.gtlib.machine.BlockMachine;
import org.gtreimagined.gtlib.machine.BlockMultiMachine;
import org.gtreimagined.gtlib.machine.types.Machine;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.material.MaterialType;
import org.gtreimagined.gtlib.ore.BlockOre;
import org.gtreimagined.gtlib.pipe.BlockPipe;
import org.gtreimagined.gtlib.proxy.IProxyHandler;
import org.gtreimagined.gtlib.registration.IColorHandler;

public class ClientHandler
implements IProxyHandler {
    public ClientHandler() {
        GTTextureStitcher.addStitcher(event -> GTAPI.all(CoverFactory.class).forEach(cover -> {
            if (cover == ICover.emptyFactory) {
                return;
            }
            for (ResourceLocation resourceLocation : cover.getTextures()) {
                event.accept(resourceLocation);
            }
        }));
    }

    public static boolean isLocal() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc == null) {
            return true;
        }
        ClientPacketListener listener = mc.m_91403_();
        if (listener == null) {
            return true;
        }
        return listener.m_6198_().m_129531_();
    }

    public static void setup() {
        MaterialType.buildTooltips();
        GTAPI.all(Material.class, Material::setChemicalFormula);
        GTAPI.runLaterClient(() -> {
            ObjectOpenHashSet registered = new ObjectOpenHashSet();
            GTAPI.all(MenuHandler.class, arg_0 -> ClientHandler.lambda$setup$2((Set)registered, arg_0));
        });
        GTAPI.runLaterClient(() -> {
            GTAPI.all(BlockMachine.class, b -> ModelUtils.setRenderLayer(b, RenderType.m_110463_()));
            GTAPI.all(BlockFakeTile.class, b -> ModelUtils.setRenderLayer(b, RenderType.m_110463_()));
            GTAPI.all(BlockMultiMachine.class, b -> ModelUtils.setRenderLayer(b, RenderType.m_110463_()));
            GTAPI.all(BlockOre.class, b -> ModelUtils.setRenderLayer(b, RenderType.m_110463_()));
            GTAPI.all(BlockPipe.class, b -> ModelUtils.setRenderLayer(b, RenderType.m_110463_()));
            GTAPI.all(BlockStorage.class).stream().filter(b -> b.getType() == GTMaterialTypes.RAW_ORE_BLOCK).forEach(b -> ModelUtils.setRenderLayer(b, RenderType.m_110463_()));
            GTAPI.all(BlockFrame.class).stream().filter(b -> b.getType() == GTMaterialTypes.FRAME).forEach(b -> ModelUtils.setRenderLayer(b, RenderType.m_110463_()));
            GTAPI.all(BlockSurfaceRock.class).stream().forEach(b -> ModelUtils.setRenderLayer(b, RenderType.m_110463_()));
            GTAPI.all(GTFluid.class).forEach(f -> {
                ModelUtils.setRenderLayer((Fluid)f.getFluid(), RenderType.m_110466_());
                ModelUtils.setRenderLayer((Fluid)f.getFlowingFluid(), RenderType.m_110466_());
            });
        });
        GTAPI.all(Machine.class).stream().filter(Machine::renderAsTesr).filter(Machine::rendersContainedLiquids).map(Machine::getTileType).distinct().forEach(i -> BlockEntityRenderers.m_173590_((BlockEntityType)i, MachineTESR::new));
    }

    public static void onItemColorHandler(ItemColors colors) {
        IColorHandler h;
        for (Item item : GTAPI.all(Item.class)) {
            if (!(item instanceof IColorHandler) || !(h = (IColorHandler)item).registerColorHandlers()) continue;
            colors.m_92689_((stack, i) -> h.getItemColor(stack, null, i), new ItemLike[]{item});
        }
        for (Block block : GTAPI.all(Block.class)) {
            if (!(block instanceof IColorHandler) || !(h = (IColorHandler)block).registerColorHandlers()) continue;
            colors.m_92689_((stack, i) -> h.getItemColor(stack, null, i), new ItemLike[]{block.m_5456_()});
        }
    }

    public static void onBlockColorHandler(BlockColors colors) {
        for (Block block : GTAPI.all(Block.class)) {
            IColorHandler h;
            if (!(block instanceof IColorHandler) || !(h = (IColorHandler)block).registerColorHandlers()) continue;
            colors.m_92589_(h::getBlockColor, new Block[]{block});
        }
    }

    public static void onModelRegistry() {
    }

    @Override
    public Level getClientWorld() {
        return Minecraft.m_91087_().f_91073_;
    }

    @Override
    public Player getClientPlayer() {
        return Minecraft.m_91087_().f_91074_;
    }

    private static /* synthetic */ void lambda$setup$2(Set registered, MenuHandler h) {
        if (!registered.contains(ForgeRegistries.MENU_TYPES.getKey(h.getContainerType()))) {
            registered.add(ForgeRegistries.MENU_TYPES.getKey(h.getContainerType()));
            MenuScreens.m_96206_(h.getContainerType(), (MenuScreens.ScreenConstructor)GTAPI.get(MenuScreens.ScreenConstructor.class, h.screenID(), h.screenDomain()));
        }
    }
}

