/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.material;

import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.material.MaterialType;
import org.gtreimagined.gtlib.registration.IGTObject;
import org.gtreimagined.gtlib.texture.Texture;

public class TextureSet
implements IGTObject {
    public static final TextureSet NONE = new TextureSet("gtlib", "none");
    public static final TextureSet CUBE = new TextureSet("gtlib", "cube");
    public static final TextureSet DULL = new TextureSet("gtlib", "dull");
    public static final TextureSet METALLIC = new TextureSet("gtlib", "metallic");
    public static final TextureSet SHINY = new TextureSet("gtlib", "shiny");
    public static final TextureSet ROUGH = new TextureSet("gtlib", "rough");
    public static final TextureSet MAGNETIC = new TextureSet("gtlib", "magnetic", true);
    public static final TextureSet DIAMOND = new TextureSet("gtlib", "diamond");
    public static final TextureSet RUBY = new TextureSet("gtlib", "ruby");
    public static final TextureSet LAPIS = new TextureSet("gtlib", "lapis");
    public static final TextureSet GEM_H = new TextureSet("gtlib", "gem_h");
    public static final TextureSet GEM_V = new TextureSet("gtlib", "gem_v");
    public static final TextureSet GARNET = new TextureSet("gtlib", "garnet");
    public static final TextureSet QUARTZ = new TextureSet("gtlib", "quartz");
    public static final TextureSet FINE = new TextureSet("gtlib", "fine");
    public static final TextureSet FLINT = new TextureSet("gtlib", "flint");
    public static final TextureSet LIGNITE = new TextureSet("gtlib", "lignite");
    public static final TextureSet WOOD = new TextureSet("gtlib", "wood");
    public static final TextureSet REDSTONE = new TextureSet("gtlib", "redstone");
    public static final TextureSet RAD = new TextureSet("gtlib", "rad");
    public static final TextureSet RUBBER = new TextureSet("gtlib", "rubber");
    private String domain;
    private String id;
    private boolean force;

    public TextureSet(String domain, String id) {
        this(domain, id, false);
    }

    public TextureSet(String domain, String id, boolean force) {
        this.domain = domain;
        this.id = id;
        this.force = force;
        GTAPI.register(TextureSet.class, this);
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public Texture getTexture(MaterialType<?> type, int layer) {
        StringBuilder builder = new StringBuilder();
        builder.append("material/");
        if (!type.ignoreTextureSets() || this.force) {
            builder.append(this.id).append("/");
        }
        builder.append(type.getId()).append(layer == 0 ? "" : "_overlay");
        return new Texture(type.ignoreTextureSets() && !this.force ? "gtlib" : this.domain, builder.toString());
    }

    public String getPath() {
        return "material/" + this.id;
    }

    public Texture[] getTextures(MaterialType<?> type) {
        Texture[] textures = new Texture[type.getLayers()];
        for (int i = 0; i < type.getLayers(); ++i) {
            textures[i] = this.getTexture(type, i);
        }
        return textures;
    }

    public static void init() {
    }
}

