/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.material;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.Generated;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.GTLibConfig;
import org.gtreimagined.gtlib.material.IMaterialTag;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.material.MaterialItem;
import org.gtreimagined.gtlib.recipe.ingredient.RecipeIngredient;
import org.gtreimagined.gtlib.registration.IRegistryEntryProvider;
import org.gtreimagined.gtlib.registration.ISharedGTObject;
import org.gtreimagined.gtlib.util.TagUtils;
import org.gtreimagined.gtlib.util.Utils;

public class MaterialType<T>
implements IMaterialTag,
ISharedGTObject,
IRegistryEntryProvider {
    public static final Codec<MaterialType<?>> CODEC = Codec.STRING.xmap(t -> GTAPI.get(MaterialType.class, t), MaterialType::getId);
    protected final String id;
    protected int layers;
    protected long unitValue;
    protected boolean generating = true;
    protected boolean blockType;
    protected boolean visible;
    protected boolean splitName;
    protected final Set<Material> materials = new ObjectLinkedOpenHashSet();
    protected final Map<MaterialType<?>, TagKey<?>> tagMap = new Object2ObjectOpenHashMap();
    protected String tagPrefix;
    protected Function<Material, String> lang;
    protected Function<Material, String> idGetter;
    protected T getter;
    private boolean hidden = false;
    protected final BiMap<Material, Supplier<Item>> replacements = HashBiMap.create();
    protected final Set<IMaterialTag> dependents = new ObjectLinkedOpenHashSet();
    protected boolean hasRegistered;
    protected boolean ignoreTextureSets = false;
    public static ImmutableMap<Item, Tuple<MaterialType, Material>> tooltipCache;

    public MaterialType(String id, int layers, boolean visible, long unitValue) {
        this.id = id;
        this.visible = visible;
        this.unitValue = unitValue;
        this.layers = layers;
        this.splitName = id.contains("_");
        this.tagPrefix = Utils.getConventionalMaterialType(this);
        this.tagMap.put(this, this.tagFromString(this.tagPrefix));
        this.lang = m -> {
            String[] split = Utils.getLocalizedMaterialType(this);
            if (split.length > 1) {
                return String.join((CharSequence)"", split[0], " ", Utils.getLocalizedType(m), " ", split[1]);
            }
            return String.join((CharSequence)"", Utils.getLocalizedType(m), " ", split[0]);
        };
        this.idGetter = m -> {
            String[] split = Utils.getLocalizedMaterialType(this);
            if (split.length > 1) {
                return String.join((CharSequence)"", split[0].toLowerCase().replace(" ", "_"), "_", m.getId(), "_", split[1].toLowerCase().replace(" ", "_"));
            }
            return String.join((CharSequence)"", m.getId(), "_", split[0].toLowerCase().replace(" ", "_"));
        };
        this.register(MaterialType.class, this.getId());
    }

    protected TagKey<?> tagFromString(String name) {
        return TagUtils.getForgelikeItemTag(name);
    }

    public MaterialType<T> nonGen() {
        this.generating = false;
        return this;
    }

    public void dependents(IMaterialTag ... tags) {
        this.dependents.addAll(Arrays.asList(tags));
    }

    public void replacement(Material mat, Supplier<Item> replacement) {
        if (!mat.enabled) {
            return;
        }
        this.replacements.put((Object)mat, replacement);
        this.add(mat);
        GTAPI.addReplacement(this.getMaterialTag(mat), replacement);
    }

    public boolean hasReplacement(Material mat) {
        return this.replacements.containsKey((Object)mat);
    }

    public Material getMaterialFromStack(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof MaterialItem) {
            MaterialItem item2 = (MaterialItem)item;
            if (item2.getType() == this) {
                return item2.getMaterial();
            }
            return null;
        }
        for (Map.Entry entry : this.replacements.entrySet()) {
            Item item3 = (Item)((Supplier)entry.getValue()).get();
            if (item3 != stack.m_41720_()) continue;
            return (Material)entry.getKey();
        }
        for (TagKey tagKey : stack.m_41720_().m_204114_().m_203616_().toList()) {
            Material material;
            String prefix = this.getTag().f_203868_().m_135815_() + "/";
            if (!tagKey.f_203868_().m_135827_().equals(this.getTag().f_203868_().m_135827_()) || !tagKey.f_203868_().m_135815_().contains(prefix) || (material = Material.get(tagKey.f_203868_().m_135815_().replace(prefix, ""))) == Material.NULL) continue;
            return material;
        }
        return null;
    }

    public boolean hidden() {
        return this.hidden;
    }

    public MaterialType<T> setHidden() {
        this.hidden = true;
        return this;
    }

    public boolean ignoreTextureSets() {
        return this.ignoreTextureSets;
    }

    public MaterialType<T> setIgnoreTextureSets() {
        this.ignoreTextureSets = true;
        return this;
    }

    public TagKey<Item> getMaterialTag(Material m) {
        return this.tagFromString(String.join((CharSequence)"", this.tagPrefix, "/", this.getId().equals("raw_ore_block") ? "raw_" : "", m.getId()));
    }

    public RecipeIngredient getMaterialIngredient(Material m, int count) {
        return RecipeIngredient.of(this.getMaterialTag(m), count);
    }

    public MaterialType<T> blockType() {
        this.blockType = true;
        this.tagMap.put(this, TagUtils.getForgelikeBlockTag(Utils.getConventionalMaterialType(this)));
        return this;
    }

    public MaterialType<T> unSplitName() {
        this.splitName = false;
        this.tagPrefix = Utils.getConventionalMaterialType(this);
        this.tagMap.put(this, this.tagFromString(this.tagPrefix));
        return this;
    }

    public MaterialType<T> setLang(Function<Material, String> lang) {
        this.lang = lang;
        return this;
    }

    public MaterialType<T> setLang(BiFunction<MaterialType<?>, Material, String> lang) {
        return this.setLang((Material m) -> (String)lang.apply(this, (Material)m));
    }

    public MaterialType<T> setIdGetter(Function<Material, String> idGetter) {
        this.idGetter = idGetter;
        return this;
    }

    public MaterialType<T> setTagPrefix(String prefix) {
        this.tagPrefix = prefix;
        this.tagMap.put(this, this.tagFromString(prefix));
        return this;
    }

    @Override
    public void add(Material ... m) {
        for (Material m2 : m) {
            if (!m2.enabled) continue;
            this.all().add(m2);
            m2.types.add(this);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    public <T> TagKey<T> getTag() {
        return this.tagMap.get(this);
    }

    public MaterialType<T> set(T getter) {
        this.getter = getter;
        return this;
    }

    @Override
    public Set<IMaterialTag> dependents() {
        return this.dependents;
    }

    public T get() {
        return this.getter;
    }

    @Override
    public Set<Material> all() {
        return this.materials;
    }

    public boolean isVisible() {
        return this.visible || GTLibConfig.SHOW_ALL_MATERIAL_ITEMS.get();
    }

    public boolean allowGen(Material material) {
        return this.generating && this.materials.contains(material) && GTAPI.getReplacement(this, material, new String[0]) == null;
    }

    public String toString() {
        return this.getId();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void buildTooltips() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        GTAPI.all(MaterialType.class, (T t) -> {
            BiMap map = t.getReplacements().inverse();
            for (Map.Entry entry : map.entrySet()) {
                builder.put((Object)((Item)((Supplier)entry.getKey()).get()), (Object)new Tuple(t, (Object)((Material)entry.getValue())));
            }
        });
        tooltipCache = builder.build();
    }

    public static void addTooltip(ItemStack stack, List<Component> tooltips, Player player, TooltipFlag flag) {
        if (player == null) {
            return;
        }
        if (tooltipCache == null) {
            return;
        }
        Tuple mat = (Tuple)tooltipCache.get((Object)stack.m_41720_());
        if (mat == null) {
            Item item = stack.m_41720_();
            if (item instanceof MaterialItem) {
                MaterialItem item2 = (MaterialItem)item;
                MaterialItem.addTooltipsForMaterialItems(stack, item2.material, item2.type, player.f_19853_, tooltips, flag);
            }
            return;
        }
        MaterialItem.addTooltipsForMaterialItems(stack, (Material)mat.m_14419_(), (MaterialType)mat.m_14418_(), player.f_19853_, tooltips, flag);
    }

    public static Material getMaterialFromStackTypeless(ItemStack stack) {
        MaterialType type;
        Material material = null;
        Iterator<MaterialType> iterator = GTAPI.all(MaterialType.class).iterator();
        while (iterator.hasNext() && (material = (type = iterator.next()).getMaterialFromStack(stack)) == null) {
        }
        return material;
    }

    @Override
    public void onRegistryBuild(ResourceKey<? extends Registry<?>> registry) {
    }

    protected boolean doRegister() {
        boolean old = this.hasRegistered;
        this.hasRegistered = true;
        return !old;
    }

    @Generated
    public int getLayers() {
        return this.layers;
    }

    @Generated
    public long getUnitValue() {
        return this.unitValue;
    }

    @Generated
    public boolean isGenerating() {
        return this.generating;
    }

    @Generated
    public boolean isBlockType() {
        return this.blockType;
    }

    @Generated
    public boolean isSplitName() {
        return this.splitName;
    }

    @Generated
    public String getTagPrefix() {
        return this.tagPrefix;
    }

    @Generated
    public Function<Material, String> getLang() {
        return this.lang;
    }

    @Generated
    public Function<Material, String> getIdGetter() {
        return this.idGetter;
    }

    @Generated
    public BiMap<Material, Supplier<Item>> getReplacements() {
        return this.replacements;
    }
}

