/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.integration.xei;

import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import lombok.Generated;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.GTLib;
import org.gtreimagined.gtlib.gui.GuiData;
import org.gtreimagined.gtlib.gui.SlotType;
import org.gtreimagined.gtlib.gui.slot.ISlotProvider;
import org.gtreimagined.gtlib.integration.jei.GTLibJEIPlugin;
import org.gtreimagined.gtlib.integration.rei.REIUtils;
import org.gtreimagined.gtlib.machine.BlockMachine;
import org.gtreimagined.gtlib.machine.Tier;
import org.gtreimagined.gtlib.machine.types.BasicMultiMachine;
import org.gtreimagined.gtlib.machine.types.Machine;
import org.gtreimagined.gtlib.recipe.map.IRecipeMap;
import org.gtreimagined.gtlib.recipe.map.RecipeMap;
import org.gtreimagined.gtlib.structure.Pattern;

public class GTLibXEIPlugin {
    private static final List<Consumer<List<ItemLike>>> ITEMS_TO_HIDE = new ArrayList<Consumer<List<ItemLike>>>();
    private static final List<Consumer<List<Fluid>>> FLUIDS_TO_HIDE = new ArrayList<Consumer<List<Fluid>>>();
    private static final Map<ResourceLocation, List<Consumer<List<Item>>>> WORKSTATIONS = new Object2ObjectOpenHashMap();
    private static final Map<BlockMachine, List<Pattern>> STRUCTURES = new Object2ObjectOpenHashMap();
    public static final GuiData BACKUP_MAP_GUI = new GuiData("gtlib", "backup_map").setSlots((ISlotProvider<?>)ISlotProvider.DEFAULT().add(SlotType.IT_IN, 17, 16).add(SlotType.IT_IN, 35, 16).add(SlotType.IT_IN, 53, 16).add(SlotType.IT_IN, 17, 34).add(SlotType.IT_IN, 35, 34).add(SlotType.IT_IN, 53, 34).add(SlotType.IT_OUT, 107, 16).add(SlotType.IT_OUT, 125, 16).add(SlotType.IT_OUT, 143, 16).add(SlotType.IT_OUT, 107, 34).add(SlotType.IT_OUT, 125, 34).add(SlotType.IT_OUT, 143, 34).add(SlotType.FL_IN, 17, 63).add(SlotType.FL_IN, 35, 63).add(SlotType.FL_IN, 53, 63).add(SlotType.FL_OUT, 107, 63).add(SlotType.FL_OUT, 125, 63).add(SlotType.FL_OUT, 143, 63));
    private static final Object2ObjectMap<ResourceLocation, RegistryValue> REGISTRY = new Object2ObjectLinkedOpenHashMap();

    public static void registerMissingMaps() {
        GTAPI.all(RecipeMap.class).forEach(r -> {
            if (!REGISTRY.containsKey((Object)r.getLoc())) {
                GTLibXEIPlugin.registerCategory(r, BACKUP_MAP_GUI, Tier.LV, null, false);
            }
        });
    }

    public static void registerCategory(IRecipeMap map, GuiData gui, Tier tier, ResourceLocation model, boolean override) {
        if (REGISTRY.containsKey((Object)new ResourceLocation(map.getDomain(), map.getId())) && !override) {
            GTLib.LOGGER.info("Attempted duplicate category registration: " + map.getId());
            return;
        }
        REGISTRY.put((Object)new ResourceLocation(map.getDomain(), map.getId()), (Object)new RegistryValue(map, map.getGui() == null ? gui : map.getGui(), tier).addWorkstation(model));
    }

    public static boolean containsCategory(IRecipeMap map) {
        return REGISTRY.containsKey((Object)map.getLoc());
    }

    public static void registerCategoryWorkstation(IRecipeMap map, ResourceLocation model) {
        RegistryValue value = (RegistryValue)REGISTRY.get((Object)map.getLoc());
        if (value != null) {
            value.addWorkstation(model);
        }
    }

    public static void registerPatternForJei(BasicMultiMachine<?> machine, List<Pattern> patternList) {
        machine.getTiers().forEach(t -> GTLibXEIPlugin.registerPatternForJei(machine, t, patternList));
    }

    public static void registerPatternForJei(BasicMultiMachine<?> machine, Tier tier, List<Pattern> patternList) {
        STRUCTURES.put(machine.getBlockState(tier), patternList);
    }

    public static String intToSuperScript(long i) {
        String intString = String.valueOf(i);
        StringBuilder builder = new StringBuilder();
        for (char c : intString.toCharArray()) {
            builder.append(GTLibXEIPlugin.charToSuperScript(c));
        }
        return builder.toString();
    }

    private static String charToSuperScript(char c) {
        return switch (c) {
            case '0' -> "\u2070";
            case '1' -> "\u00b9";
            case '2' -> "\u00b2";
            case '3' -> "\u00b3";
            case '4' -> "\u2074";
            case '5' -> "\u2075";
            case '6' -> "\u2076";
            case '7' -> "\u2077";
            case '8' -> "\u2078";
            case '9' -> "\u2079";
            default -> String.valueOf(c);
        };
    }

    public static void showCategory(Machine<?> type, Tier tier) {
        if (!type.has("recipe")) {
            return;
        }
        IRecipeMap map = type.getRecipeMap(tier);
        if (map == null) {
            return;
        }
        ArrayList<ResourceLocation> categories = new ArrayList<ResourceLocation>();
        categories.add(map.getLoc());
        if (!map.getSubCategories().isEmpty()) {
            map.getSubCategories().keySet().forEach(s -> categories.add(new ResourceLocation("gt", s)));
        }
        GTLibXEIPlugin.showCategories((ResourceLocation[])categories.toArray(ResourceLocation[]::new));
    }

    public static void showCategories(ResourceLocation ... categories) {
        if (GTAPI.isModLoaded("jei") && !GTAPI.isModLoaded("roughlyenoughitems")) {
            GTLibJEIPlugin.showCategories(categories);
        } else if (GTAPI.isModLoaded("roughlyenoughitems")) {
            REIUtils.showCategories(categories);
        }
    }

    public static void uses(FluidStack val, boolean USE) {
        if (GTAPI.isModLoaded("jei") && !GTAPI.isModLoaded("roughlyenoughitems")) {
            GTLibJEIPlugin.uses(val, USE);
        } else if (GTAPI.isModLoaded("roughlyenoughitems")) {
            REIUtils.uses(val, USE);
        }
    }

    public static <T> void addModDescriptor(List<Component> tooltip, T t) {
        if (GTAPI.isModLoaded("jei") && !GTAPI.isModLoaded("roughlyenoughitems")) {
            GTLibJEIPlugin.addModDescriptor(tooltip, t);
        } else if (GTAPI.isModLoaded("roughlyenoughitems")) {
            REIUtils.addModDescriptor(tooltip, t);
        }
    }

    public static void addItemsToHide(ItemLike ... items) {
        GTLibXEIPlugin.addItemsToHide((List<ItemLike> l) -> l.addAll(Arrays.asList(items)));
    }

    public static void addItemsToHide(Consumer<List<ItemLike>> listConsumer) {
        ITEMS_TO_HIDE.add(listConsumer);
    }

    public static void addFluidsToHide(Fluid ... fluids) {
        GTLibXEIPlugin.addFluidsToHide((List<Fluid> l) -> l.addAll(Arrays.asList(fluids)));
    }

    public static void addFluidsToHide(Consumer<List<Fluid>> listConsumer) {
        FLUIDS_TO_HIDE.add(listConsumer);
    }

    public static void addWorkstations(ResourceLocation category, Item ... items) {
        GTLibXEIPlugin.addWorkstations(category, (List<Item> l) -> l.addAll(Arrays.asList(items)));
    }

    public static void addWorkstations(ResourceLocation category, Consumer<List<Item>> listConsumer) {
        WORKSTATIONS.computeIfAbsent(category, r -> new ArrayList()).add(listConsumer);
    }

    public static List<Consumer<List<ItemLike>>> getItemsToHide() {
        return ITEMS_TO_HIDE;
    }

    public static List<Consumer<List<Fluid>>> getFluidsToHide() {
        return FLUIDS_TO_HIDE;
    }

    @Generated
    public static Map<ResourceLocation, List<Consumer<List<Item>>>> getWORKSTATIONS() {
        return WORKSTATIONS;
    }

    @Generated
    public static Map<BlockMachine, List<Pattern>> getSTRUCTURES() {
        return STRUCTURES;
    }

    @Generated
    public static Object2ObjectMap<ResourceLocation, RegistryValue> getREGISTRY() {
        return REGISTRY;
    }

    public static class RegistryValue {
        public IRecipeMap map;
        public GuiData gui;
        public Tier tier;
        public List<ResourceLocation> workstations = new ArrayList<ResourceLocation>();

        public RegistryValue(IRecipeMap map, GuiData gui, Tier tier) {
            this.map = map;
            this.gui = gui;
            this.tier = tier;
        }

        public RegistryValue addWorkstation(ResourceLocation supplier) {
            if (supplier != null && !this.workstations.contains(supplier)) {
                this.workstations.add(supplier);
            }
            return this;
        }
    }
}

