/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.integration.rei;

import dev.architectury.fluid.FluidStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.view.ViewSearchBuilder;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;

public class REIUtils {
    static List<Consumer<CategoryRegistry>> EXTRA_CATEGORIES = new ArrayList<Consumer<CategoryRegistry>>();
    static List<Consumer<DisplayRegistry>> EXTRA_DISPLAYS = new ArrayList<Consumer<DisplayRegistry>>();

    public static net.minecraftforge.fluids.FluidStack fromREIFluidStack(FluidStack from) {
        return new net.minecraftforge.fluids.FluidStack(from.getFluid(), (int)from.getAmount(), from.getTag());
    }

    public static FluidStack toREIFLuidStack(net.minecraftforge.fluids.FluidStack from) {
        return FluidStack.create((Fluid)from.getFluid(), (long)from.getAmount(), (CompoundTag)from.getTag());
    }

    public static <T> void addModDescriptor(List<Component> tooltip, T t) {
    }

    public static void addExtraDisplay(Consumer<DisplayRegistry> registry) {
        EXTRA_DISPLAYS.add(registry);
    }

    public static void addExtraCategory(Consumer<CategoryRegistry> registry) {
        EXTRA_CATEGORIES.add(registry);
    }

    public static void uses(net.minecraftforge.fluids.FluidStack val, boolean USE) {
        EntryStack stack = EntryStack.of((EntryType)VanillaEntryTypes.FLUID, (Object)REIUtils.toREIFLuidStack(val));
        if (USE) {
            ViewSearchBuilder.builder().addUsagesFor(stack).open();
        } else {
            ViewSearchBuilder.builder().addRecipesFor(stack).open();
        }
    }

    public static void showCategories(ResourceLocation ... categories) {
        ViewSearchBuilder.builder().addCategories((Collection)Arrays.stream(categories).map(CategoryIdentifier::of).collect(Collectors.toList())).open();
    }
}

