/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.integration.jei.category;

import com.mojang.blaze3d.vertex.PoseStack;
import java.text.DecimalFormat;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.gtreimagined.gtlib.data.GTMaterialTypes;
import org.gtreimagined.gtlib.data.VanillaStoneTypes;
import org.gtreimagined.gtlib.integration.jei.GTLibJEIPlugin;
import org.gtreimagined.gtlib.integration.jei.category.RecipeMapCategory;
import org.gtreimagined.gtlib.integration.xei.StoneVein;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.material.MaterialTypeBlock;
import org.gtreimagined.gtlib.util.Utils;

public class StoneVeinCategory
implements IRecipeCategory<StoneVein> {
    IDrawable icon = RecipeMapCategory.guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)Items.f_41834_.m_7968_());
    IDrawable background = RecipeMapCategory.guiHelper.drawableBuilder(new ResourceLocation("gtlib", "textures/gui/background/machine_basic.png"), 3, 3, 170, 60).addPadding(0, 60, 0, 0).build();
    public static final RecipeType<StoneVein> STONE_VEINS = new RecipeType(new ResourceLocation("gtlib", "stone_veins"), StoneVein.class);

    public Component getTitle() {
        return Utils.translatable("jei.category.gtlib.stone_veins", new Object[0]);
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public RecipeType<StoneVein> getRecipeType() {
        return STONE_VEINS;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, StoneVein recipe, IFocusGroup focuses) {
        Material material = recipe.ore().material();
        builder.addSlot(RecipeIngredientRole.OUTPUT, 1, 1).addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)((MaterialTypeBlock.IOreGetter)GTMaterialTypes.ORE.get()).get(material, VanillaStoneTypes.STONE).asItem()));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 19, 1).addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)recipe.stoneLayer().block()));
        GTLibJEIPlugin.addDimensionSlots(builder, recipe.stoneLayer().dimensions());
    }

    public void draw(StoneVein recipe, IRecipeSlotsView recipeSlotsView, PoseStack stack, double mouseX, double mouseY) {
        int x = RecipeMapCategory.JEI_OFFSET_X;
        int y = RecipeMapCategory.JEI_OFFSET_Y + 3;
        DecimalFormat format = new DecimalFormat("###.####");
        String fullId = recipe.stoneLayer().getLoc().m_135815_();
        this.renderString(stack, "Stone Layer Name: " + Utils.lowerUnderscoreToUpperSpaced(fullId), Minecraft.m_91087_().f_91062_, 0.0f, 18.0f, 0, x, y, false);
        this.renderString(stack, "Stone: " + recipe.stoneLayer().block().m_49954_().getString(), Minecraft.m_91087_().f_91062_, 0.0f, 28.0f, 0, x, y, false);
        this.renderString(stack, "Ore: " + recipe.ore().material().getDisplayNameString() + " Ore", Minecraft.m_91087_().f_91062_, 0.0f, 38.0f, 0, x, y, false);
        this.renderString(stack, "StoneLayerChance: " + format.format((double)recipe.stoneLayer().weight() / (double)recipe.totalWeight() * 100.0) + "%", Minecraft.m_91087_().f_91062_, 0.0f, 58.0f, 0, x, y, false);
        this.renderString(stack, "MinY: " + recipe.ore().minY() + " MaxY: " + recipe.ore().maxY(), Minecraft.m_91087_().f_91062_, 0.0f, 68.0f, 0, x, y, false);
        this.renderString(stack, "Ore Chance per Stone: " + format.format((double)recipe.ore().chance() / 1.8144E7 * 100.0) + "%", Minecraft.m_91087_().f_91062_, 0.0f, 78.0f, 0, x, y, false);
        this.renderString(stack, "Generated world:", Minecraft.m_91087_().f_91062_, 0.0f, 88.0f, 0, x, y, false);
    }

    void renderString(PoseStack stack, String string, Font render, float x, float y, int color, int guiOffsetX, int guiOffsetY, boolean shadow) {
        if (shadow) {
            render.m_92750_(stack, string, (float)guiOffsetX + x, (float)guiOffsetY + y, color);
        } else {
            render.m_92883_(stack, string, (float)guiOffsetX + x, (float)guiOffsetY + y, color);
        }
    }
}

