/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.gui.widget;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.gtreimagined.gtlib.GTLib;
import org.gtreimagined.gtlib.blockentity.BlockEntityMachine;
import org.gtreimagined.gtlib.capability.IGuiHandler;
import org.gtreimagined.gtlib.cover.ICover;
import org.gtreimagined.gtlib.gui.ButtonOverlay;
import org.gtreimagined.gtlib.gui.GuiInstance;
import org.gtreimagined.gtlib.gui.ICanSyncData;
import org.gtreimagined.gtlib.gui.IGuiElement;
import org.gtreimagined.gtlib.gui.event.GuiEvents;
import org.gtreimagined.gtlib.gui.event.IGuiEvent;
import org.gtreimagined.gtlib.gui.widget.ButtonWidget;
import org.gtreimagined.gtlib.gui.widget.WidgetSupplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextButtonWidget<T>
extends ButtonWidget {
    T state;
    final Function<IGuiHandler, T> syncFunction;
    final Function<T, Component> textToRender;

    public TextButtonWidget(GuiInstance instance, IGuiElement parent, @NotNull Function<T, Component> textToRender, T defaultValue, Function<IGuiHandler, T> syncFunction, @Nullable Consumer<ButtonWidget> onPress) {
        super(instance, parent, ButtonOverlay.NO_OVERLAY, onPress);
        this.state = defaultValue;
        this.textToRender = textToRender;
        this.syncFunction = syncFunction;
    }

    @Override
    public void init() {
        super.init();
        if (this.state instanceof Integer) {
            this.gui.syncInt(() -> (int)((Integer)this.syncFunction.apply(this.gui.handler)), i -> {
                this.state = i;
            }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
        } else if (this.state instanceof Long) {
            this.gui.syncLong(() -> (long)((Long)this.syncFunction.apply(this.gui.handler)), i -> {
                this.state = i;
            }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
        } else if (this.state instanceof Float) {
            this.gui.syncFloat(() -> Float.valueOf(((Float)this.syncFunction.apply(this.gui.handler)).floatValue()), i -> {
                this.state = i;
            }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
        } else if (this.state instanceof Double) {
            this.gui.syncDouble(() -> (double)((Double)this.syncFunction.apply(this.gui.handler)), i -> {
                this.state = i;
            }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
        } else if (this.state instanceof Boolean) {
            this.gui.syncBoolean(() -> (boolean)((Boolean)this.syncFunction.apply(this.gui.handler)), i -> {
                this.state = i;
            }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
        } else if (this.state instanceof String) {
            this.gui.syncString(() -> (String)this.syncFunction.apply(this.gui.handler), i -> {
                this.state = i;
            }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
        } else if (this.state instanceof ItemStack) {
            this.gui.syncItemStack(() -> (ItemStack)this.syncFunction.apply(this.gui.handler), i -> {
                this.state = i;
            }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
        } else if (this.state instanceof FluidStack) {
            this.gui.syncFluidStack(() -> (FluidStack)this.syncFunction.apply(this.gui.handler), i -> {
                this.state = i;
            }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
        } else {
            String string;
            IGuiHandler iGuiHandler = this.gui.handler;
            if (iGuiHandler instanceof BlockEntityMachine) {
                BlockEntityMachine machine = (BlockEntityMachine)iGuiHandler;
                string = machine.getMachineType().getLoc().toString();
            } else {
                iGuiHandler = this.gui.handler;
                if (iGuiHandler instanceof ICover) {
                    ICover cover = (ICover)iGuiHandler;
                    string = cover.getLoc().toString();
                } else {
                    string = this.gui.handler.getClass().toString();
                }
            }
            String object = string;
            GTLib.LOGGER.warn("Unknown sync type in text widget in: " + object);
        }
    }

    @Override
    protected void renderButtonBody(PoseStack matrixStack, double mouseX, double mouseY, float partialTicks) {
        Component text = this.textToRender.apply(this.state);
        int textWidth = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)text);
        int xScaled = textWidth / 2;
        int xCenter = this.getW() / 2;
        int xPosition = xCenter - xScaled;
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        int textHeight = 9;
        int yScaled = textHeight / 2;
        int yCenter = this.getH() / 2;
        int yPosition = yCenter - yScaled;
        this.drawText(matrixStack, this.textToRender.apply(this.state), this.realX() + xPosition, this.realY() + yPosition, 0x404040);
    }

    public static <T> WidgetSupplier build(Function<IGuiHandler, T> syncFunction, Function<T, Component> textToRender, T defaultValue, IGuiEvent.IGuiEventFactory ev, int id, boolean renderBackground) {
        return TextButtonWidget.builder((a, b) -> new TextButtonWidget<Object>((GuiInstance)a, (IGuiElement)b, textToRender, defaultValue, syncFunction, but -> but.gui.sendPacket(but.gui.handler.createGuiPacket(new GuiEvents.GuiEvent(ev, Screen.m_96638_() ? 1 : 0, id)))).setRenderBackground(renderBackground));
    }
}

