/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.gui;

import com.teamresourceful.resourcefullib.common.networking.base.Packet;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.gtreimagined.gtlib.capability.IGuiHandler;
import org.gtreimagined.gtlib.gui.ButtonOverlay;
import org.gtreimagined.gtlib.gui.ICanSyncData;
import org.gtreimagined.gtlib.gui.IGuiElement;
import org.gtreimagined.gtlib.gui.Widget;
import org.gtreimagined.gtlib.gui.container.IGTContainer;
import org.gtreimagined.gtlib.gui.core.RTree;
import org.gtreimagined.gtlib.gui.event.GuiEvents;
import org.gtreimagined.gtlib.gui.event.IGuiEvent;
import org.gtreimagined.gtlib.gui.screen.GTContainerScreen;
import org.gtreimagined.gtlib.gui.widget.ButtonWidget;
import org.gtreimagined.gtlib.gui.widget.CycleButtonWidget;
import org.gtreimagined.gtlib.gui.widget.SwitchButtonWidget;
import org.gtreimagined.gtlib.gui.widget.TextButtonWidget;
import org.gtreimagined.gtlib.gui.widget.WidgetSupplier;
import org.gtreimagined.gtlib.network.GTLibNetwork;
import org.gtreimagined.gtlib.network.packets.AbstractGuiEventPacket;
import org.gtreimagined.gtlib.network.packets.ClientboundGuiSyncPacket;
import org.gtreimagined.gtlib.network.packets.GuiSyncPacket;
import org.gtreimagined.gtlib.network.packets.ServerboundGuiSyncPacket;
import org.jetbrains.annotations.Nullable;

public class GuiInstance
implements ICanSyncData {
    private int buttonCounter = 0;
    public final IGuiHandler handler;
    public final AbstractContainerMenu container;
    public final boolean isRemote;
    private final List<SyncHolder> syncData = new ObjectArrayList();
    private int indexCounter = 0;
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public GTContainerScreen<?> screen;
    private final List<WidgetSupplier> builders = new ObjectArrayList();
    private final RTree<Widget> widgetLookup = new RTree();
    private final Set<Widget> widgets = new ObjectOpenHashSet();
    private IGuiElement focus;

    public GuiInstance(IGuiHandler handler, AbstractContainerMenu container, boolean isRemote) {
        this.handler = handler;
        this.isRemote = isRemote;
        this.container = container;
    }

    public void rescale(IGuiElement root) {
        for (Widget w : this.unsortedWidgets()) {
            if (w.parent != root) continue;
            w.updateSize();
        }
    }

    public Iterable<Widget> getWidgets(double mouseX, double mouseY) {
        return () -> {
            Stream stream = this.widgetLookup.search(new float[]{(float)mouseX, (float)mouseY}, new float[]{0.0f, 0.0f}).stream();
            return stream.sorted((a, b) -> Integer.compare(b.depth(), a.depth())).iterator();
        };
    }

    public Optional<Widget> getTopLevelWidget(double mouseX, double mouseY) {
        Iterator<Widget> iterator = this.getWidgets(mouseX, mouseY).iterator();
        return iterator.hasNext() ? Optional.of(iterator.next()) : Optional.empty();
    }

    @OnlyIn(value=Dist.CLIENT)
    public Iterable<Widget> widgetsToRender() {
        return () -> this.widgets.stream().sorted(Comparator.comparing(Widget::depth)).iterator();
    }

    public boolean isOnTop(Widget wid, double mouseX, double mouseY) {
        return this.getWidgets(mouseX, mouseY).iterator().next() == wid;
    }

    public void rescaleWidget(Widget wid, int oldX, int oldY, int oldW, int oldH) {
        if (!wid.isEnabled()) {
            return;
        }
        if (!this.widgets.contains(wid)) {
            return;
        }
        float x = oldX;
        float y = oldY;
        float w = oldW;
        float h = oldH;
        if (this.widgetLookup.delete(new float[]{x, y}, new float[]{w, h}, wid)) {
            this.widgetLookup.insert(wid);
        }
    }

    public void updateWidgetStatus(Widget wid) {
        if (wid.isEnabled()) {
            this.widgetLookup.insert(wid);
        } else {
            this.widgetLookup.delete(wid);
        }
    }

    private void initWidgets(IGuiElement parent) {
        this.handler.addWidgets(this, parent);
        for (WidgetSupplier builder : this.builders) {
            if (!builder.shouldAdd(this)) continue;
            builder.buildAndAdd(this, parent);
        }
    }

    private void putWidget(Widget w) {
        this.widgets.add(w);
        this.updateWidgetStatus(w);
        w.init();
    }

    public void init() {
        this.initWidgets(null);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initClient(GTContainerScreen<?> parent) {
        this.screen = parent;
        this.initWidgets(parent);
        for (Widget mut : this.unsortedWidgets()) {
            if (mut.parent != null) continue;
            mut.setParent(parent);
        }
    }

    public GuiInstance addWidget(Widget widget) {
        this.putWidget(widget);
        return this;
    }

    public GuiInstance addWidget(WidgetSupplier provider) {
        this.builders.add(provider);
        return this;
    }

    public GuiInstance addButton(int x, int y, ButtonOverlay body) {
        this.addWidget(ButtonWidget.build(body, GuiEvents.EXTRA_BUTTON, this.buttonCounter++, false).setSize(x, y, body.w, body.h));
        return this;
    }

    public GuiInstance addButton(int x, int y, ButtonOverlay body, boolean renderBackground) {
        this.addWidget(ButtonWidget.build(body, GuiEvents.EXTRA_BUTTON, this.buttonCounter++, renderBackground).setSize(x, y, body.w, body.h));
        return this;
    }

    public GuiInstance addButton(int x, int y, ButtonOverlay body, boolean renderBackground, String tooltipKey) {
        this.addWidget(ButtonWidget.build(body, GuiEvents.EXTRA_BUTTON, this.buttonCounter++, renderBackground, tooltipKey).setSize(x, y, body.w, body.h));
        return this;
    }

    public GuiInstance addButton(int x, int y, ButtonOverlay body, String tooltipKey) {
        this.addWidget(ButtonWidget.build(body, GuiEvents.EXTRA_BUTTON, this.buttonCounter++, false, tooltipKey).setSize(x, y, body.w, body.h));
        return this;
    }

    public GuiInstance addSwitchButton(int x, int y, int w, int h, ButtonOverlay bodyOff, ButtonOverlay bodyOn, Predicate<IGuiHandler> syncFunction, boolean renderBackground) {
        this.addWidget(SwitchButtonWidget.build(bodyOff, bodyOn, syncFunction, GuiEvents.EXTRA_BUTTON, this.buttonCounter++, renderBackground).setSize(x, y, w, h));
        return this;
    }

    public GuiInstance addSwitchButton(int x, int y, int w, int h, ButtonOverlay bodyOff, ButtonOverlay bodyOn, Predicate<IGuiHandler> syncFunction, boolean renderBackground, Function<Boolean, String> tooltipKeyFunction) {
        this.addWidget(SwitchButtonWidget.build(bodyOff, bodyOn, syncFunction, GuiEvents.EXTRA_BUTTON, this.buttonCounter++, renderBackground, tooltipKeyFunction).setSize(x, y, w, h));
        return this;
    }

    public GuiInstance addCycleButton(int x, int y, int w, int h, ToIntFunction<IGuiHandler> syncFunction, boolean renderBackground, ButtonOverlay ... buttons) {
        this.addWidget(CycleButtonWidget.build(syncFunction, (IGuiEvent.IGuiEventFactory)GuiEvents.EXTRA_BUTTON, this.buttonCounter++, renderBackground, buttons).setSize(x, y, w, h));
        return this;
    }

    public GuiInstance addCycleButton(int x, int y, int w, int h, ToIntFunction<IGuiHandler> syncFunction, boolean renderBackground, IntFunction<String> tooltipKey, ButtonOverlay ... buttons) {
        this.addWidget(CycleButtonWidget.build(syncFunction, (IGuiEvent.IGuiEventFactory)GuiEvents.EXTRA_BUTTON, this.buttonCounter++, renderBackground, tooltipKey, buttons).setSize(x, y, w, h));
        return this;
    }

    public <T> GuiInstance addTextButton(int x, int y, int w, int h, Function<IGuiHandler, T> syncFunction, Function<T, Component> textToRender, T defaultValue, boolean renderBackground) {
        this.addWidget(TextButtonWidget.build(syncFunction, textToRender, defaultValue, GuiEvents.EXTRA_BUTTON, this.buttonCounter++, renderBackground).setSize(x, y, w, h));
        return this;
    }

    public Iterable<Widget> unsortedWidgets() {
        return this.widgets;
    }

    public void update(double mouseX, double mouseY) {
        this.getTopLevelWidget(mouseX, mouseY).ifPresent(t -> {
            this.focus = t;
        });
        this.unsortedWidgets().forEach(t -> t.update(mouseX, mouseY));
        ObjectArrayList toSync = new ObjectArrayList();
        for (SyncHolder sync : this.syncData) {
            Object value;
            if (sync.direction == ICanSyncData.SyncDirection.SERVER_TO_CLIENT || sync.equality.apply(value = sync.source.get(), sync.current).booleanValue()) continue;
            sync.current = value;
            toSync.add(sync);
        }
        if (toSync.size() > 0) {
            this.writeToServer((List<SyncHolder>)toSync);
        }
    }

    public void sendPacket(AbstractGuiEventPacket pkt) {
        GTLibNetwork.NETWORK.sendToServer((Packet)pkt);
    }

    public void update() {
        ObjectArrayList toSync = new ObjectArrayList();
        for (SyncHolder sync : this.syncData) {
            Object value;
            if (sync.direction == ICanSyncData.SyncDirection.CLIENT_TO_SERVER || sync.equality.apply(value = sync.source.get(), sync.current).booleanValue()) continue;
            sync.current = value;
            toSync.add(sync);
        }
        if (toSync.size() > 0) {
            this.writeToClient((List<SyncHolder>)toSync);
        }
    }

    public ItemStack getHeldItem() {
        return this.container.m_142621_();
    }

    @Nullable
    public IGuiElement getFocus() {
        return this.focus;
    }

    public void receivePacket(GuiSyncPacket packet, ICanSyncData.SyncDirection dir) {
        ByteBuf data = packet.clientData;
        FriendlyByteBuf buf = new FriendlyByteBuf(data);
        int size = buf.m_130242_();
        for (int i = 0; i < size; ++i) {
            int offset = buf.m_130242_();
            Object o = this.syncData.get((int)offset).reader.apply(buf);
            SyncHolder holder = this.syncData.get(offset);
            holder.current = o;
            holder.sink.accept(o);
        }
    }

    private void writeToClient(List<SyncHolder> data) {
        ClientboundGuiSyncPacket pkt = new ClientboundGuiSyncPacket(data);
        for (ServerPlayer listener : ((IGTContainer)this.container).listeners()) {
            GTLibNetwork.NETWORK.sendToPlayer((Packet)pkt, (Player)listener);
        }
    }

    private void writeToServer(List<SyncHolder> data) {
        ServerboundGuiSyncPacket pkt = new ServerboundGuiSyncPacket(data);
        GTLibNetwork.NETWORK.sendToServer((Packet)pkt);
    }

    @Override
    public <T> void bind(Supplier<T> supplier, Consumer<T> consumer, Function<FriendlyByteBuf, T> reader, BiConsumer<FriendlyByteBuf, T> writer, BiFunction<Object, Object, Boolean> equality, ICanSyncData.SyncDirection direction) {
        this.syncData.add(new SyncHolder(supplier, consumer, reader, writer, this.indexCounter++, equality, direction));
    }

    public static class SyncHolder {
        public final Supplier source;
        public final Consumer sink;
        public Object current;
        public final Function<FriendlyByteBuf, Object> reader;
        public final BiConsumer<FriendlyByteBuf, Object> writer;
        public final int index;
        public BiFunction<Object, Object, Boolean> equality;
        public final ICanSyncData.SyncDirection direction;

        public SyncHolder(Supplier<?> source, Consumer<?> sink, Function<FriendlyByteBuf, ?> reader, BiConsumer<FriendlyByteBuf, ?> writer, int index, BiFunction<Object, Object, Boolean> equality, ICanSyncData.SyncDirection direction) {
            this.source = source;
            this.index = index;
            this.sink = sink;
            this.reader = reader;
            this.writer = writer;
            this.equality = equality;
            this.direction = direction;
        }
    }
}

