/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.datagen.providers;

import com.google.common.collect.ImmutableMap;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.Generated;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.Registry;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.ConditionalRecipe;
import net.minecraftforge.common.crafting.conditions.ICondition;
import org.gtreimagined.gtlib.GTLib;
import org.gtreimagined.gtlib.data.GTTools;
import org.gtreimagined.gtlib.datagen.builder.GTShapedRecipeBuilder;
import org.gtreimagined.gtlib.datagen.builder.GTShapelessRecipeBuilder;
import org.gtreimagined.gtlib.datagen.builder.SequencedAssemblyBuilder;
import org.gtreimagined.gtlib.recipe.condition.ConfigCondition;
import org.gtreimagined.gtlib.recipe.condition.TomlConfigCondition;
import org.gtreimagined.gtlib.recipe.ingredient.PropertyIngredient;
import org.gtreimagined.gtlib.util.RegistryUtils;
import org.gtreimagined.gtlib.util.TagUtils;
import org.gtreimagined.gtlib.util.Utils;

public class GTRecipeProvider
extends RecipeProvider {
    protected final String providerDomain;
    protected final String providerName;
    private static final Set<ResourceLocation> RECIPES_TO_REMOVE = new HashSet<ResourceLocation>();

    public GTRecipeProvider(String providerDomain, String providerName) {
        super(null);
        this.providerDomain = providerDomain;
        this.providerName = providerName;
    }

    public void removeRecipe(ResourceLocation recipeId) {
        RECIPES_TO_REMOVE.add(recipeId);
    }

    public SequencedAssemblyBuilder getSequencedAssemblyRecipe(Ingredient input) {
        return new SequencedAssemblyBuilder(input);
    }

    public void addConditionalRecipe(Consumer<FinishedRecipe> consumer, GTShapedRecipeBuilder builtRecipe, Class configClass, String configFieldName, String recipeDomain, String recipeName) {
        ConditionalRecipe.builder().addCondition((ICondition)new ConfigCondition(configClass, configFieldName)).addRecipe(builtRecipe::build).build(consumer, recipeDomain, recipeName);
    }

    public void addConditionalRecipe(Consumer<FinishedRecipe> consumer, GTShapedRecipeBuilder builtRecipe, String config, String configField, String recipeDomain, String recipeName) {
        ConditionalRecipe.builder().addCondition((ICondition)new TomlConfigCondition(config, configField)).addRecipe(builtRecipe::build).build(consumer, recipeDomain, recipeName);
    }

    public GTShapedRecipeBuilder getItemRecipe(String groupName, boolean customCriterion, ItemLike output, ImmutableMap<Character, Object> inputs, String ... inputPattern) {
        return this.getStackRecipe(groupName, customCriterion, new ItemStack(output), inputs, inputPattern);
    }

    public GTShapedRecipeBuilder getStackRecipe(String groupName, boolean customCriterion, ItemStack output, ImmutableMap<Character, Object> inputs, String ... inputPattern) {
        return this.getStackRecipe(groupName, customCriterion, Collections.singletonList(output), inputs, inputPattern);
    }

    public GTShapedRecipeBuilder getStackRecipe(String groupName, boolean customCriterion, List<ItemStack> output, ImmutableMap<Character, Object> inputs, String ... inputPattern) {
        if (inputs.isEmpty()) {
            Utils.onInvalidData("Inputs should not be empty!");
        }
        if (inputPattern.length < 1 || inputPattern.length > 3) {
            Utils.onInvalidData("Input pattern must have between 1 and 3 rows!");
        }
        GTShapedRecipeBuilder recipeBuilder = GTShapedRecipeBuilder.shapedRecipe(output);
        recipeBuilder = this.resolveKeys(recipeBuilder, inputs);
        for (String s : inputPattern) {
            if (s.length() > 3) {
                Utils.onInvalidData("Input pattern rows must have between 0 and 3 characters!");
            }
            recipeBuilder = recipeBuilder.patternLine(s);
        }
        recipeBuilder = recipeBuilder.setGroup(groupName);
        if (!customCriterion) {
            ArrayList<CallSite> criteria = new ArrayList<CallSite>();
            for (Object o : inputs.values()) {
                ItemLike itemLike;
                String id;
                TagKey tag;
                if (o instanceof TagKey && (tag = (TagKey)o).f_203867_() == Registry.f_122904_) {
                    id = "has_" + tag.f_203868_().m_135815_();
                    if (criteria.contains(id)) continue;
                    recipeBuilder.addCriterion(id, this.hasSafeItem((TagKey<Item>)tag));
                    criteria.add((CallSite)((Object)id));
                    continue;
                }
                if (!(o instanceof ItemLike) || criteria.contains(id = "has_" + RegistryUtils.getIdFromItem((itemLike = (ItemLike)o).m_5456_()).m_135815_())) continue;
                recipeBuilder.addCriterion(id, this.hasSafeItem(itemLike));
                criteria.add((CallSite)((Object)id));
            }
            if (criteria.isEmpty()) {
                recipeBuilder.addCriterion("has_wrench", this.hasSafeItem(GTTools.WRENCH.getTag()));
            }
        }
        return recipeBuilder;
    }

    public void shapeless(Consumer<FinishedRecipe> consumer, String recipeID, String groupName, ItemStack output, Object ... inputs) {
        this.shapeless(consumer, "gtlib", recipeID, groupName, output, inputs);
    }

    public void shapeless(Consumer<FinishedRecipe> consumer, String domain, String recipeID, String groupName, ItemStack output, Object ... inputs) {
        GTShapelessRecipeBuilder builder = GTShapelessRecipeBuilder.shapeless((ItemLike)output.m_41720_(), output.m_41613_()).group(groupName);
        ArrayList<CallSite> criteria = new ArrayList<CallSite>();
        for (Object input : inputs) {
            try {
                String id;
                if (input instanceof ItemLike) {
                    ItemLike l = (ItemLike)input;
                    builder.requires(l);
                    id = "has_" + RegistryUtils.getIdFromItem(l.m_5456_()).m_135815_();
                    if (criteria.contains(id)) continue;
                    builder.unlockedBy(id, this.hasSafeItem(l));
                    criteria.add((CallSite)((Object)id));
                    continue;
                }
                if (input instanceof TagKey) {
                    TagKey tagKey = (TagKey)input;
                    builder.requires(TagUtils.nc(TagUtils.getItemTag(tagKey.f_203868_()).f_203868_()));
                    id = "has_" + tagKey.f_203868_().m_135815_();
                    if (criteria.contains(id)) continue;
                    builder.unlockedBy(id, this.hasSafeItem((TagKey<Item>)tagKey));
                    criteria.add((CallSite)((Object)id));
                    continue;
                }
                if (!(input instanceof Ingredient)) continue;
                Ingredient i = (Ingredient)input;
                builder.requires(i);
            }
            catch (ClassCastException ex) {
                throw new RuntimeException("ERROR PARSING SHAPELESS RECIPE" + ex.getMessage());
            }
        }
        if (criteria.isEmpty()) {
            builder.unlockedBy("has_wrench", this.hasSafeItem(GTTools.WRENCH.getTag()));
        }
        if (recipeID.isEmpty()) {
            builder.save(consumer);
        } else if (domain.isEmpty()) {
            builder.save(consumer, recipeID);
        } else {
            builder.save(consumer, this.fixLoc(domain, recipeID));
        }
    }

    public void addItemRecipe(Consumer<FinishedRecipe> consumer, String groupName, ItemLike output, ImmutableMap<Character, Object> inputs, String ... inputPattern) {
        this.addStackRecipe(consumer, "", "", groupName, new ItemStack(output), inputs, inputPattern);
    }

    public void addItemRecipe(Consumer<FinishedRecipe> consumer, String recipeDomain, String recipeName, String groupName, ItemLike output, ImmutableMap<Character, Object> inputs, String ... inputPattern) {
        this.addStackRecipe(consumer, recipeDomain, recipeName, groupName, new ItemStack(output), inputs, inputPattern);
    }

    public void addStackRecipe(Consumer<FinishedRecipe> consumer, String recipeDomain, String recipeName, String groupName, ItemStack output, Function<ImmutableMap.Builder<Character, Object>, ImmutableMap.Builder<Character, Object>> inputs, String ... inputPattern) {
        this.addStackRecipe(consumer, recipeDomain, recipeName, groupName, output, (ImmutableMap<Character, Object>)inputs.apply((ImmutableMap.Builder<Character, Object>)new ImmutableMap.Builder()).build(), inputPattern);
    }

    public void addStackRecipe(Consumer<FinishedRecipe> consumer, String groupName, ItemStack output, ImmutableMap<Character, Object> inputs, String ... inputPattern) {
        this.addStackRecipe(consumer, "", "", groupName, output, inputs, inputPattern);
    }

    public void addStackRecipe(Consumer<FinishedRecipe> consumer, String recipeDomain, String recipeName, String groupName, ItemStack output, ImmutableMap<Character, Object> inputs, String ... inputPattern) {
        GTShapedRecipeBuilder recipeBuilder = this.getStackRecipe(groupName, false, output, inputs, inputPattern);
        if (recipeName.isEmpty()) {
            recipeBuilder.build(consumer);
        } else if (recipeDomain.isEmpty()) {
            recipeBuilder.build(consumer, recipeName);
        } else {
            recipeBuilder.build(consumer, this.fixLoc(recipeDomain, recipeName));
        }
    }

    public void addToolRecipe(String builder, Consumer<FinishedRecipe> consumer, String recipeDomain, String recipeName, String groupName, ItemStack output, ImmutableMap<Character, Object> inputs, String ... inputPattern) {
        if (output.m_41619_()) {
            GTLib.LOGGER.warn("Material recipe " + recipeDomain + ":" + recipeName + "has an empty output.");
            return;
        }
        GTShapedRecipeBuilder recipeBuilder = this.getStackRecipe(groupName, false, output, inputs, inputPattern);
        if (recipeName.isEmpty()) {
            recipeBuilder.buildTool(consumer, builder);
        } else if (recipeDomain.isEmpty()) {
            recipeBuilder.buildTool(consumer, builder, recipeName);
        } else {
            recipeBuilder.buildTool(consumer, builder, this.fixLoc(recipeDomain, recipeName));
        }
    }

    protected GTShapedRecipeBuilder resolveKeys(GTShapedRecipeBuilder incompleteBuilder, ImmutableMap<Character, Object> inputs) {
        for (Map.Entry entry : inputs.entrySet()) {
            Object v = entry.getValue();
            if (v instanceof ItemLike) {
                ItemLike l = (ItemLike)v;
                incompleteBuilder = incompleteBuilder.key((Character)entry.getKey(), l);
                continue;
            }
            v = entry.getValue();
            if (v instanceof ItemStack) {
                ItemStack stack = (ItemStack)v;
                incompleteBuilder = incompleteBuilder.key((Character)entry.getKey(), (ItemLike)stack.m_41720_());
                continue;
            }
            v = entry.getValue();
            if (v instanceof TagKey) {
                TagKey tagKey = (TagKey)v;
                try {
                    incompleteBuilder = incompleteBuilder.key((Character)entry.getKey(), TagUtils.nc(tagKey.f_203868_()));
                }
                catch (ClassCastException e) {
                    Utils.onInvalidData("Tag inputs only allow Item Tags!");
                }
                continue;
            }
            v = entry.getValue();
            if (v instanceof PropertyIngredient) {
                PropertyIngredient pi = (PropertyIngredient)((Object)v);
                incompleteBuilder = incompleteBuilder.key((Character)entry.getKey(), pi);
                continue;
            }
            v = entry.getValue();
            if (!(v instanceof Ingredient)) continue;
            Ingredient i = (Ingredient)v;
            incompleteBuilder = incompleteBuilder.key((Character)entry.getKey(), i);
        }
        return incompleteBuilder;
    }

    public String fixLoc(String providerDomain, String attach) {
        return providerDomain.concat(":").concat(attach);
    }

    public String m_6055_() {
        return this.providerName;
    }

    public CriterionTriggerInstance hasSafeItem(TagKey<Item> tag) {
        return GTRecipeProvider.m_126011_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_204145_(tag).m_45077_()});
    }

    public CriterionTriggerInstance hasSafeItem(ItemLike stack) {
        return RecipeProvider.m_125977_((ItemLike)stack);
    }

    @Generated
    public static Set<ResourceLocation> getRECIPES_TO_REMOVE() {
        return RECIPES_TO_REMOVE;
    }
}

