/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.cover;

import java.util.Collection;
import java.util.Collections;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.gtreimagined.gtlib.blockentity.multi.BlockEntityHatch;
import org.gtreimagined.gtlib.blockentity.multi.BlockEntityMultiMachine;
import org.gtreimagined.gtlib.capability.ComponentHandler;
import org.gtreimagined.gtlib.capability.ICoverHandler;
import org.gtreimagined.gtlib.cover.BaseCover;
import org.gtreimagined.gtlib.cover.CoverFactory;
import org.gtreimagined.gtlib.machine.MachineState;
import org.gtreimagined.gtlib.machine.Tier;
import org.gtreimagined.gtlib.structure.StructureCache;
import org.jetbrains.annotations.Nullable;

public class CoverMuffler
extends BaseCover {
    public CoverMuffler(ICoverHandler<?> source, @Nullable Tier tier, Direction side, CoverFactory factory) {
        super(source, tier, side, factory);
    }

    @Override
    public ResourceLocation getModel(String type, Direction dir) {
        if (type.equals("pipe")) {
            return PIPE_COVER_MODEL;
        }
        return CoverMuffler.getBasicModel();
    }

    @Override
    public void onBlockUpdate() {
        super.onBlockUpdate();
        BlockState neighbor = this.handler.getTile().m_58904_().m_8055_(this.handler.getTile().m_58899_().m_121945_(this.side));
        boolean isAir = neighbor.m_60795_();
        Object t = this.handler.getTile();
        if (t instanceof BlockEntityHatch) {
            BlockEntityHatch machine = (BlockEntityHatch)t;
            ((Collection)machine.getComponentHandler().map(ComponentHandler::getControllers).orElse(Collections.emptyList())).forEach(controller -> controller.recipeHandler.ifPresent(r -> {
                if (isAir && r.isProcessingBlocked()) {
                    r.setProcessingBlocked(false);
                } else if (!isAir && !r.isProcessingBlocked()) {
                    r.setProcessingBlocked(true);
                }
            }));
        }
    }

    @Override
    public boolean ticks() {
        return true;
    }

    @Override
    public void onUpdate() {
        BlockPos pos = this.handler.getTile().m_58899_();
        Level world = this.handler.getTile().m_58904_();
        if (world.f_46443_) {
            BlockEntityMultiMachine tile = StructureCache.getAnyMulti(world, pos, BlockEntityMultiMachine.class);
            if (tile == null || tile.getMachineState() != MachineState.ACTIVE) {
                return;
            }
            RandomSource rand = world.f_46441_;
            Direction dir = this.side;
            double d0 = (double)pos.m_123341_() + 0.5 + (dir.m_122434_() == Direction.Axis.X ? 0.0 : (rand.m_188500_() - 0.5) / 2.0);
            double d1 = (double)pos.m_123342_() + 0.5 + (dir.m_122434_() == Direction.Axis.Y ? 0.0 : (rand.m_188500_() - 0.5) / 2.0);
            double d2 = (double)pos.m_123343_() + 0.5 + (dir.m_122434_() == Direction.Axis.Z ? 0.0 : (rand.m_188500_() - 0.5) / 2.0);
            if (rand.m_188500_() < 0.1) {
                // empty if block
            }
            world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d0 + (double)(0.6f * (float)this.side.m_122429_()), d1 + 0.6 * (double)this.side.m_122430_(), d2 + (double)(0.6f * (float)this.side.m_122431_()), (double)this.side.m_122429_(), (double)this.side.m_122430_(), (double)this.side.m_122431_());
        }
    }
}

