/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.block;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.util.Iterator;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.gtreimagined.gtlib.block.BlockStorage;
import org.gtreimagined.gtlib.block.GTItemBlock;
import org.gtreimagined.gtlib.data.GTMaterialTypes;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.material.MaterialTags;
import org.gtreimagined.gtlib.material.MaterialType;
import org.gtreimagined.gtlib.registration.IItemBlockProvider;
import org.gtreimagined.gtlib.util.Utils;
import org.jetbrains.annotations.Nullable;

public class BlockFrame
extends BlockStorage
implements IItemBlockProvider,
SimpleWaterloggedBlock {
    private static final VoxelShape FRAME_SHAPE = Shapes.m_83048_((double)0.05, (double)0.0, (double)0.05, (double)0.95, (double)1.0, (double)0.95);
    private static final Object2ObjectMap<Integer, IntegerProperty> PROPERTIES = new Object2ObjectArrayMap();
    protected final StateDefinition<Block, BlockState> stateContainer;
    private final int maxRange;
    private final boolean initialized;

    public BlockFrame(String domain, MaterialType<?> type, Material material) {
        super(domain, type, material);
        int n = material.has(MaterialTags.WOOD) || material.has(MaterialTags.RUBBERTOOLS) ? 9 : (this.maxRange = material.has(MaterialTags.METAL) ? 65 : 33);
        if (!PROPERTIES.containsKey((Object)this.maxRange)) {
            PROPERTIES.put((Object)this.maxRange, (Object)IntegerProperty.m_61631_((String)"distance", (int)0, (int)this.maxRange));
        }
        this.initialized = true;
        StateDefinition.Builder builder = new StateDefinition.Builder((Object)this);
        this.m_7926_((StateDefinition.Builder<Block, BlockState>)builder);
        this.stateContainer = builder.m_61101_(Block::m_49966_, BlockState::new);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.stateContainer.m_61090_()).m_61124_((Property)PROPERTIES.get((Object)this.maxRange), (Comparable)Integer.valueOf(this.maxRange))).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        if (!this.initialized) {
            return;
        }
        builder.m_61104_(new Property[]{(Property)PROPERTIES.get((Object)this.maxRange), BlockStateProperties.f_61362_});
    }

    public StateDefinition<Block, BlockState> m_49965_() {
        return this.stateContainer;
    }

    public BlockState m_5573_(BlockPlaceContext blockPlaceContext) {
        BlockPos blockPos = blockPlaceContext.m_8083_();
        Level level = blockPlaceContext.m_43725_();
        int i = this.getDistance((BlockGetter)level, blockPos);
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(level.m_6425_(blockPos).m_76152_() == Fluids.f_76193_))).m_61124_((Property)PROPERTIES.get((Object)this.maxRange), (Comparable)Integer.valueOf(i));
    }

    public void m_6807_(BlockState blockState, Level level, BlockPos blockPos, BlockState blockState2, boolean bl) {
        if (!level.f_46443_) {
            level.m_186460_(blockPos, (Block)this, 1);
        }
    }

    public BlockState m_7417_(BlockState blockState, Direction direction, BlockState blockState2, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos2) {
        if (((Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            levelAccessor.m_186469_(blockPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)levelAccessor));
        }
        if (!levelAccessor.m_5776_()) {
            levelAccessor.m_186460_(blockPos, (Block)this, 1);
        }
        return blockState;
    }

    public void tick(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, Random randomSource) {
        int i = this.getDistance((BlockGetter)serverLevel, blockPos);
        BlockState blockState2 = (BlockState)blockState.m_61124_((Property)PROPERTIES.get((Object)this.maxRange), (Comparable)Integer.valueOf(i));
        if ((Integer)blockState2.m_61143_((Property)PROPERTIES.get((Object)this.maxRange)) == this.maxRange) {
            if ((Integer)blockState.m_61143_((Property)PROPERTIES.get((Object)this.maxRange)) == this.maxRange) {
                FallingBlockEntity.m_201971_((Level)serverLevel, (BlockPos)blockPos, (BlockState)blockState2);
            } else {
                serverLevel.m_46961_(blockPos, true);
            }
        } else if (blockState != blockState2) {
            serverLevel.m_7731_(blockPos, blockState2, 3);
        }
    }

    public boolean m_7898_(BlockState blockState, LevelReader levelReader, BlockPos blockPos) {
        return this.getDistance((BlockGetter)levelReader, blockPos) < this.maxRange;
    }

    public FluidState m_5888_(BlockState blockState) {
        return (Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(blockState);
    }

    public int getDistance(BlockGetter blockGetter, BlockPos blockPos) {
        Direction direction;
        BlockState blockState2;
        BlockPos.MutableBlockPos mutableBlockPos = blockPos.m_122032_().m_122173_(Direction.DOWN);
        BlockState blockState = blockGetter.m_8055_((BlockPos)mutableBlockPos);
        int i = this.maxRange;
        if (blockState.m_60713_((Block)this)) {
            i = (Integer)blockState.m_61143_((Property)PROPERTIES.get((Object)this.maxRange));
        } else if (blockState.m_60783_(blockGetter, (BlockPos)mutableBlockPos, Direction.UP)) {
            return 0;
        }
        Iterator iterator = Direction.Plane.HORIZONTAL.iterator();
        while (iterator.hasNext() && (!(blockState2 = blockGetter.m_8055_((BlockPos)mutableBlockPos.m_122159_((Vec3i)blockPos, direction = (Direction)iterator.next()))).m_60713_((Block)this) || (i = Math.min(i, (Integer)blockState2.m_61143_((Property)PROPERTIES.get((Object)this.maxRange)) + 1)) != 1)) {
        }
        return i;
    }

    @Override
    public GTItemBlock getItemBlock() {
        return new GTItemBlock(this){

            @Nullable
            public BlockPlaceContext m_7732_(BlockPlaceContext ctx) {
                Block block;
                BlockPos blockPos = ctx.m_8083_();
                BlockState blockState = ctx.m_43725_().m_8055_(blockPos);
                if (!blockState.m_60713_(block = this.m_40614_())) {
                    return BlockFrame.this.getDistance((BlockGetter)ctx.m_43725_(), blockPos) == BlockFrame.this.maxRange ? null : ctx;
                }
                Direction direction = ctx.m_7078_() ? ctx.m_43719_() : (ctx.m_43719_() == Direction.UP ? ctx.m_8125_() : Direction.UP);
                int i = 0;
                BlockPos.MutableBlockPos mutableBlockPos = blockPos.m_122032_().m_122173_(direction);
                while (i < BlockFrame.this.maxRange) {
                    if (!ctx.m_43725_().f_46443_ && !ctx.m_43725_().m_46739_((BlockPos)mutableBlockPos)) {
                        Player player = ctx.m_43723_();
                        int j = ctx.m_43725_().m_151558_();
                        if (!(player instanceof ServerPlayer)) break;
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        if (mutableBlockPos.m_123342_() < j) break;
                        serverPlayer.m_240418_((Component)Utils.translatable("build.tooHigh", j - 1).m_130940_(ChatFormatting.RED), true);
                        break;
                    }
                    blockState = ctx.m_43725_().m_8055_((BlockPos)mutableBlockPos);
                    if (!blockState.m_60713_(this.m_40614_())) {
                        if (!blockState.m_60629_(ctx)) break;
                        return BlockPlaceContext.m_43644_((BlockPlaceContext)ctx, (BlockPos)mutableBlockPos, (Direction)direction);
                    }
                    mutableBlockPos.m_122173_(direction);
                    if (!direction.m_122434_().m_122479_()) continue;
                    ++i;
                }
                return null;
            }

            protected boolean m_6652_() {
                return false;
            }
        };
    }

    public boolean m_6864_(BlockState blockState, BlockPlaceContext blockPlaceContext) {
        return blockPlaceContext.m_43722_().m_150930_(this.m_5456_());
    }

    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        if (this.type == GTMaterialTypes.BLOCK) {
            return;
        }
        entity.m_20334_(Mth.m_14008_((double)entity.m_20184_().f_82479_, (double)-0.15, (double)0.15), entity.m_20184_().f_82480_, Mth.m_14008_((double)entity.m_20184_().f_82481_, (double)-0.15, (double)0.15));
        entity.f_19789_ = 0.0f;
        if (entity.m_6047_() && entity instanceof Player) {
            if (entity.m_20069_()) {
                entity.m_20334_(entity.m_20184_().f_82479_, 0.02, entity.m_20184_().f_82481_);
            } else {
                entity.m_20334_(entity.m_20184_().f_82479_, 0.08, entity.m_20184_().f_82481_);
            }
        } else if (entity.f_19862_) {
            entity.m_20334_(entity.m_20184_().f_82479_, this.material.has(MaterialTags.METAL) ? 0.44 : 0.22, entity.m_20184_().f_82481_);
        } else {
            entity.m_20334_(entity.m_20184_().f_82479_, Math.max(entity.m_20184_().f_82480_, -0.2), entity.m_20184_().f_82481_);
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (context != CollisionContext.m_82749_()) {
            return super.m_5940_(state, world, pos, context);
        }
        return FRAME_SHAPE;
    }

    public boolean isLadder(BlockState state, LevelReader world, BlockPos pos, LivingEntity entity) {
        return true;
    }

    public PushReaction m_5537_(BlockState state) {
        return PushReaction.DESTROY;
    }
}

