/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib;

import com.mojang.datafixers.util.Either;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.Arrays;
import java.util.Deque;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.LoadingModList;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.util.TriConsumer;
import org.gtreimagined.gtlib.GTLib;
import org.gtreimagined.gtlib.datagen.IGTLibProvider;
import org.gtreimagined.gtlib.gui.GuiData;
import org.gtreimagined.gtlib.integration.xei.GTLibXEIPlugin;
import org.gtreimagined.gtlib.machine.Tier;
import org.gtreimagined.gtlib.machine.types.Machine;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.material.MaterialType;
import org.gtreimagined.gtlib.ore.StoneType;
import org.gtreimagined.gtlib.recipe.map.IRecipeMap;
import org.gtreimagined.gtlib.registration.IGTObject;
import org.gtreimagined.gtlib.registration.IGTRegistrar;
import org.gtreimagined.gtlib.registration.IRegistryEntryProvider;
import org.gtreimagined.gtlib.registration.ISharedGTObject;
import org.gtreimagined.gtlib.registration.RegistrationEvent;
import org.gtreimagined.gtlib.util.NonNullSupplier;
import org.gtreimagined.gtlib.util.TagUtils;
import org.gtreimagined.gtlib.util.Utils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GTAPI {
    private static final Map<Class<?>, Map<String, Either<ISharedGTObject, Map<String, Object>>>> OBJECTS = new Object2ObjectOpenHashMap();
    private static final EnumMap<RegistrationEvent, List<Runnable>> CALLBACKS = new EnumMap(RegistrationEvent.class);
    private static final EnumSet<RegistrationEvent> REGISTRATION_EVENTS_HANDLED = EnumSet.noneOf(RegistrationEvent.class);
    private static final ObjectList<IBlockUpdateEvent> BLOCK_UPDATE_HANDLERS = new ObjectArrayList();
    private static final Int2ObjectMap<Deque<Runnable>> DEFERRED_QUEUE = new Int2ObjectOpenHashMap();
    private static final Object2ObjectMap<ResourceLocation, Supplier<Object>> REPLACEMENTS = new Object2ObjectOpenHashMap();
    private static final Map<String, Map<String, Class<?>>> CLASS_LOOKUP = new Object2ObjectOpenHashMap();
    private static RegistrationEvent PHASE = null;
    private static IGTRegistrar INTERNAL_REGISTRAR;

    public static void init() {
    }

    private static void registerInternal(Class<?> c, String id, @Nullable String domain, Object o) {
        if (domain != null) {
            Object present = OBJECTS.computeIfAbsent(c, t -> new Object2ObjectLinkedOpenHashMap()).computeIfAbsent(domain, t -> Either.right((Object)new Object2ObjectLinkedOpenHashMap())).map(t -> null, t -> t.put(id, o));
            if (present != null) {
                throw new IllegalStateException(String.join((CharSequence)"", "Class ", c.getName(), "'s object: ", id, " has already been registered by: ", present.toString()));
            }
        } else {
            Map map = OBJECTS.computeIfAbsent(c, t -> new Object2ObjectLinkedOpenHashMap());
            Either present = map.put(id, Either.left((Object)((ISharedGTObject)o)));
            if (present != null) {
                throw new IllegalStateException(String.join((CharSequence)"", "Class ", c.getName(), "'s object: ", id, " has already been registered by: ", present.toString()));
            }
        }
        String name = c.getSimpleName();
        CLASS_LOOKUP.computeIfAbsent(domain, k -> new Object2ObjectOpenHashMap()).putIfAbsent(name, c);
    }

    public static RegistrationEvent getPhase() {
        return PHASE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T register(Class<?> c, String id, String domain, Object o) {
        Map<Class<?>, Map<String, Either<ISharedGTObject, Map<String, Object>>>> map = OBJECTS;
        synchronized (map) {
            if (!GTAPI.allowRegistration()) {
                throw new IllegalStateException("Registering after DataDone in GTAPI - badbad!");
            }
            if (o instanceof IGTObject && !((IGTObject)o).shouldRegister()) {
                return (T)o;
            }
            if (o instanceof ISharedGTObject && GTAPI.getInternal(c, id) != null) {
                return (T)GTAPI.getInternal(c, id);
            }
            GTAPI.registerInternal(c, id, o instanceof ISharedGTObject ? null : domain, o);
            if (o instanceof Block && GTAPI.notRegistered(Block.class, id, domain)) {
                GTAPI.registerInternal(Block.class, id, domain, o);
            } else if (o instanceof Item && GTAPI.notRegistered(Item.class, id, domain)) {
                GTAPI.registerInternal(Item.class, id, domain, o);
            } else if (o instanceof IRegistryEntryProvider) {
                String changedId;
                String string = o instanceof Material ? "material_" + id : (changedId = o instanceof StoneType ? "stone_" + id : id);
                if (GTAPI.notRegistered(IRegistryEntryProvider.class, changedId, domain)) {
                    GTAPI.registerInternal(IRegistryEntryProvider.class, changedId, domain, o);
                }
            }
            return (T)o;
        }
    }

    public static <T> T register(Class<T> c, IGTObject o) {
        return GTAPI.register(c, o.getId(), o.getDomain(), o);
    }

    private static boolean notRegistered(Class<?> c, String id, String domain) {
        return !GTAPI.has(c, id, domain);
    }

    private static <T> T getInternal(Class<T> c, String id, String domain) {
        Either<ISharedGTObject, Map<String, Object>> inner;
        Map<String, Either<ISharedGTObject, Map<String, Object>>> map = OBJECTS.get(c);
        if (map != null && (inner = map.get(domain)) != null) {
            return (T)inner.map(t -> null, t -> {
                Object o = t.get(id);
                return o == null ? null : c.cast(o);
            });
        }
        return null;
    }

    @Nullable
    public static <T> T get(Class<T> c, String id, String domain) {
        T obj = GTAPI.getInternal(c, id, domain);
        if (obj == null) {
            Class<T> clazz = c;
            if (domain.equals("gt")) {
                T o = GTAPI.get(clazz, id);
                return o == null ? null : (T)c.cast(o);
            }
        }
        return obj;
    }

    public static <T> T get(Class<T> c, ResourceLocation location) {
        return GTAPI.get(c, location.m_135815_(), location.m_135827_());
    }

    static boolean allowRegistration() {
        return PHASE == RegistrationEvent.DATA_INIT || PHASE == RegistrationEvent.CLIENT_DATA_INIT || PHASE == RegistrationEvent.WORLDGEN_INIT;
    }

    private static <T extends ISharedGTObject> T getInternal(Class<? extends T> c, String id) {
        Map<String, Either<ISharedGTObject, Map<String, Object>>> map = OBJECTS.get(c);
        if (map == null) {
            return null;
        }
        Either<ISharedGTObject, Map<String, Object>> obj = map.get(id);
        return (T)(obj == null ? null : (ISharedGTObject)c.cast(obj.map(t -> t, t -> null)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends ISharedGTObject> T get(Class<? extends T> c, String id) {
        if (!GTAPI.allowRegistration()) {
            Map<Class<?>, Map<String, Either<ISharedGTObject, Map<String, Object>>>> map = OBJECTS;
            synchronized (map) {
                return GTAPI.getInternal(c, id);
            }
        }
        return GTAPI.getInternal(c, id);
    }

    @NotNull
    public static <T> T getOrDefault(Class<T> c, String id, String domain, NonNullSupplier<? extends T> supplier) {
        T obj = GTAPI.get(c, id, domain);
        return obj != null ? c.cast(obj) : supplier.get();
    }

    @NotNull
    public static <T> T getOrThrow(Class<T> c, String id, String domain, Supplier<? extends RuntimeException> supplier) {
        T obj = GTAPI.get(c, id, domain);
        if (obj != null) {
            return c.cast(obj);
        }
        throw supplier.get();
    }

    @NotNull
    public static <T extends ISharedGTObject> T getOrThrow(Class<T> c, String id, Supplier<? extends RuntimeException> supplier) {
        T obj = GTAPI.get(c, id);
        if (obj != null) {
            return (T)((ISharedGTObject)c.cast(obj));
        }
        throw supplier.get();
    }

    public static <T> boolean has(Class<T> c, String id, String domain) {
        Map<String, Either<ISharedGTObject, Map<String, Object>>> map = OBJECTS.get(c);
        if (map != null) {
            Either<ISharedGTObject, Map<String, Object>> either = map.get(domain);
            if (either == null) {
                return false;
            }
            return (Boolean)either.map(t -> true, t -> t.containsKey(id));
        }
        return false;
    }

    public static <T> boolean has(Class<T> c, String id) {
        Map<String, Either<ISharedGTObject, Map<String, Object>>> map = OBJECTS.get(c);
        if (map != null) {
            Either<ISharedGTObject, Map<String, Object>> inner = map.get(id);
            return inner != null && inner.left().isPresent();
        }
        return false;
    }

    @Nullable
    public static <T> T get(String className, String domain, String id) {
        Map<String, Class<?>> map = CLASS_LOOKUP.get(domain);
        if (map == null) {
            return null;
        }
        Class<?> clazz = map.get(className);
        if (clazz == null) {
            return null;
        }
        return (T)GTAPI.get(clazz, id, domain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void all(String className, String domain, Consumer<T> consumer) {
        Map<Class<?>, Map<String, Either<ISharedGTObject, Map<String, Object>>>> map = OBJECTS;
        synchronized (map) {
            Map<String, Class<?>> map2 = CLASS_LOOKUP.get(domain);
            if (map2 == null) {
                return;
            }
            Class<?> clazz = map2.get(className);
            if (clazz == null) {
                return;
            }
            if (domain == null) {
                GTAPI.allInternal(clazz).forEach(consumer);
            } else {
                GTAPI.allInternal(clazz, domain).forEach(consumer);
            }
        }
    }

    @Nullable
    public static <T> T get(String className, String id) {
        return GTAPI.get(className, "gt", id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<T> all(Class<T> c) {
        if (!GTAPI.allowRegistration()) {
            List list;
            Map<Class<?>, Map<String, Either<ISharedGTObject, Map<String, Object>>>> map = OBJECTS;
            synchronized (map) {
                list = GTAPI.allInternal(c).collect(Collectors.toList());
            }
            return list;
        }
        return GTAPI.allInternal(c).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<T> all(Class<T> c, String domain) {
        if (!GTAPI.allowRegistration()) {
            List list;
            Map<Class<?>, Map<String, Either<ISharedGTObject, Map<String, Object>>>> map = OBJECTS;
            synchronized (map) {
                list = GTAPI.allInternal(c, domain).collect(Collectors.toList());
            }
            return list;
        }
        return GTAPI.allInternal(c, domain).collect(Collectors.toList());
    }

    private static <T> Stream<T> allInternal(Class<T> c) {
        Map<String, Either<ISharedGTObject, Map<String, Object>>> map = OBJECTS.get(c);
        return map == null ? Stream.empty() : new Object2ObjectArrayMap(map).values().stream().flatMap(t -> (Stream)t.map(Stream::of, right -> right.values().stream())).map(c::cast);
    }

    private static <T> Stream<T> allInternal(Class<T> c, @NotNull String domain) {
        return GTAPI.allInternal(c).filter(o -> o instanceof IGTObject && ((IGTObject)o).getDomain().equals(domain));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void all(Class<T> c, TriConsumer<T, String, String> consumer) {
        Map<Class<?>, Map<String, Either<ISharedGTObject, Map<String, Object>>>> map = OBJECTS;
        synchronized (map) {
            Map<String, Either<ISharedGTObject, Map<String, Object>>> map2 = OBJECTS.get(c);
            if (map2 != null) {
                new Object2ObjectArrayMap(map2).forEach((d, e) -> {
                    if (e.left().isPresent()) {
                        e.left().ifPresent(o -> consumer.accept(c.cast(o), (Object)o.getDomain(), (Object)o.getId()));
                    } else {
                        e.right().ifPresent(m -> m.forEach((i, o) -> consumer.accept(c.cast(o), d, i)));
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void all(Class<T> c, String domain, TriConsumer<T, String, String> consumer) {
        Map<Class<?>, Map<String, Either<ISharedGTObject, Map<String, Object>>>> map = OBJECTS;
        synchronized (map) {
            Map<String, Either<ISharedGTObject, Map<String, Object>>> map2 = OBJECTS.get(c);
            if (map2 != null) {
                new Object2ObjectArrayMap(map2).forEach((d, e) -> {
                    if (e.left().isPresent()) {
                        if (domain.equals("gt")) {
                            e.left().ifPresent(o -> consumer.accept(c.cast(o), (Object)o.getDomain(), (Object)o.getId()));
                        }
                    } else {
                        e.right().ifPresent(m -> m.forEach((i, o) -> {
                            if (d.equals(domain)) {
                                consumer.accept(c.cast(o), d, i);
                            }
                        }));
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void all(Class<T> c, Consumer<T> consumer) {
        if (!GTAPI.allowRegistration()) {
            Map<Class<?>, Map<String, Either<ISharedGTObject, Map<String, Object>>>> map = OBJECTS;
            synchronized (map) {
                GTAPI.allInternal(c).forEach(consumer);
            }
        } else {
            GTAPI.allInternal(c).forEach(consumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void all(Class<T> c, String domain, Consumer<T> consumer) {
        if (GTAPI.allowRegistration()) {
            Map<Class<?>, Map<String, Either<ISharedGTObject, Map<String, Object>>>> map = OBJECTS;
            synchronized (map) {
                GTAPI.allInternal(c, domain).forEach(consumer);
            }
        } else {
            GTAPI.allInternal(c, domain).forEach(consumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void all(Class<T> c, String[] domains, Consumer<T> consumer) {
        if (GTAPI.allowRegistration()) {
            Map<Class<?>, Map<String, Either<ISharedGTObject, Map<String, Object>>>> map = OBJECTS;
            synchronized (map) {
                for (String domain : domains) {
                    GTAPI.allInternal(c, domain).forEach(consumer);
                }
            }
        } else {
            for (String domain : domains) {
                GTAPI.allInternal(c, domain).forEach(consumer);
            }
        }
    }

    private static void runProvider(IGTLibProvider provider) {
        LogManager.getLogger().debug("Running " + provider.m_6055_());
        provider.run();
    }

    public static Optional<Deque<Runnable>> getCommonDeferredQueue() {
        return Optional.ofNullable((Deque)DEFERRED_QUEUE.get(0));
    }

    public static Optional<Deque<Runnable>> getClientDeferredQueue() {
        return Optional.ofNullable((Deque)DEFERRED_QUEUE.get(1));
    }

    public static Optional<Deque<Runnable>> getServerDeferredQueue() {
        return Optional.ofNullable((Deque)DEFERRED_QUEUE.get(2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runLaterCommon(Runnable ... r) {
        Int2ObjectMap<Deque<Runnable>> int2ObjectMap = DEFERRED_QUEUE;
        synchronized (int2ObjectMap) {
            ((Deque)DEFERRED_QUEUE.computeIfAbsent(0, q -> new LinkedList<Runnable>(Arrays.asList(r)))).addAll(Arrays.asList(r));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runLaterClient(Runnable ... r) {
        Int2ObjectMap<Deque<Runnable>> int2ObjectMap = DEFERRED_QUEUE;
        synchronized (int2ObjectMap) {
            ((Deque)DEFERRED_QUEUE.computeIfAbsent(1, q -> new LinkedList())).addAll(Arrays.asList(r));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runLaterServer(Runnable ... r) {
        Int2ObjectMap<Deque<Runnable>> int2ObjectMap = DEFERRED_QUEUE;
        synchronized (int2ObjectMap) {
            ((Deque)DEFERRED_QUEUE.computeIfAbsent(2, q -> new LinkedList<Runnable>(Arrays.asList(r)))).addAll(Arrays.asList(r));
        }
    }

    public static void onRegistration(RegistrationEvent event) {
        RegistrationEvent previous = PHASE;
        PHASE = event;
        GTLib.LOGGER.info("Registration event " + event);
        Dist side = FMLEnvironment.dist;
        if (!REGISTRATION_EVENTS_HANDLED.add(event)) {
            if (ModLoadingContext.get().getActiveNamespace().equals("gtlib")) {
                return;
            }
            throw new IllegalStateException("The RegistrationEvent " + event.name() + " has already been handled");
        }
        INTERNAL_REGISTRAR.onRegistrationEvent(event, side);
        List<IGTRegistrar> list = GTAPI.all(IGTRegistrar.class).stream().sorted((c1, c2) -> Integer.compare(c2.getPriority(), c1.getPriority())).filter(IGTRegistrar::isEnabled).toList();
        list.forEach(r -> r.onRegistrationEvent(event, side));
        if (CALLBACKS.containsKey((Object)event)) {
            CALLBACKS.get((Object)event).forEach(Runnable::run);
        }
        if (event == RegistrationEvent.CLIENT_DATA_INIT) {
            PHASE = previous;
        }
    }

    public static boolean isModLoaded(String modid) {
        if (ModList.get() == null) {
            return LoadingModList.get().getMods().stream().map(ModInfo::getModId).anyMatch(modid::equals);
        }
        return ModList.get().isLoaded(modid);
    }

    public static void runOnEvent(RegistrationEvent event, Runnable runnable) {
        CALLBACKS.computeIfAbsent(event, k -> new ObjectArrayList()).add(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addRegistrar(IGTRegistrar registrar) {
        if (INTERNAL_REGISTRAR == null && registrar instanceof GTLib) {
            INTERNAL_REGISTRAR = registrar;
        } else if (registrar.isEnabled()) {
            Map<Class<?>, Map<String, Either<ISharedGTObject, Map<String, Object>>>> map = OBJECTS;
            synchronized (map) {
                GTAPI.registerInternal(IGTRegistrar.class, registrar.getId(), registrar.getDomain(), registrar);
            }
        }
    }

    public static Optional<IGTRegistrar> getRegistrar(String id) {
        return GTAPI.allInternal(IGTRegistrar.class).filter(t -> t.getId().equals(id)).findFirst();
    }

    public static boolean isRegistrarEnabled(String id) {
        return GTAPI.getRegistrar(id).map(IGTRegistrar::isEnabled).orElse(false);
    }

    public static void registerJEICategory(IRecipeMap map, GuiData gui, Tier tier, ResourceLocation model, boolean override) {
        if (GTAPI.isModLoaded("jei") || GTAPI.isModLoaded("roughlyenoughitems")) {
            GTLibXEIPlugin.registerCategory(map, gui, tier, model, override);
        }
    }

    public static void registerJEICategory(IRecipeMap map, GuiData gui, Machine<?> machine, @Nullable Tier tier, boolean override) {
        if (GTAPI.isModLoaded("jei") || GTAPI.isModLoaded("roughlyenoughitems")) {
            if (tier == null) {
                tier = machine.getFirstTier();
            }
            GTLibXEIPlugin.registerCategory(map, gui, tier, new ResourceLocation(machine.getDomain(), machine.getIdFromTier(tier)), override);
        }
    }

    public static void registerJEICategoryWorkstation(IRecipeMap map, Machine<?> machine, @Nullable Tier tier) {
        if (GTAPI.isModLoaded("jei") || GTAPI.isModLoaded("roughlyenoughitems")) {
            GTLibXEIPlugin.registerCategoryWorkstation(map, new ResourceLocation(machine.getDomain(), machine.getIdFromTier(tier != null ? tier : machine.getFirstTier())));
        }
    }

    public static void registerJEICategory(IRecipeMap map, GuiData gui) {
        GTAPI.registerJEICategory(map, gui, Tier.LV, null, true);
    }

    public static Item getReplacement(MaterialType<?> type, Material material, String ... namespaces) {
        if (type.getId().contains("liquid")) {
            return null;
        }
        TagKey<Item> tag = type.getMaterialTag(material);
        return GTAPI.getReplacement(null, tag, namespaces);
    }

    public static Item getReplacement(MaterialType<?> type, Material material, StoneType stone, String ... namespaces) {
        if (type.getId().contains("liquid")) {
            return null;
        }
        TagKey<Item> tag = TagUtils.getForgelikeItemTag(String.join((CharSequence)"", stone.getId(), "_", Utils.getConventionalMaterialType(type), "/", material.getId()));
        return GTAPI.getReplacement(null, tag, namespaces);
    }

    public static <T> T getReplacement(@Nullable T originalItem, TagKey<T> tag, String ... namespaces) {
        if (tag == null) {
            throw new IllegalArgumentException("GTAPI#getReplacement received a null tag!");
        }
        if (REPLACEMENTS.containsKey((Object)tag.f_203868_())) {
            return ((Supplier)REPLACEMENTS.get((Object)tag.f_203868_())).get();
        }
        return originalItem;
    }

    public static <T> void addReplacement(ResourceLocation tag, Supplier<T> obj) {
        REPLACEMENTS.put((Object)tag, obj::get);
    }

    public static <T> void addReplacement(TagKey<Item> tag, Supplier<T> obj) {
        REPLACEMENTS.put((Object)tag.f_203868_(), obj::get);
    }

    public static boolean hasReplacement(TagKey<Item> tag) {
        return REPLACEMENTS.containsKey((Object)tag.f_203868_());
    }

    public static void registerBlockUpdateHandler(IBlockUpdateEvent handler) {
        BLOCK_UPDATE_HANDLERS.add((Object)handler);
    }

    public static void onNotifyBlockUpdate(Level world, BlockPos pos, BlockState oldState, BlockState newState, int flags) {
        BLOCK_UPDATE_HANDLERS.forEach(h -> h.onNotifyBlockUpdate(world, pos, oldState, newState, flags));
    }

    public static interface IBlockUpdateEvent {
        public void onNotifyBlockUpdate(Level var1, BlockPos var2, BlockState var3, BlockState var4, int var5);
    }
}

