/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.gui;

import net.minecraft.resources.ResourceLocation;
import org.gtreimagined.gtlib.registration.IGTObject;

public class ButtonOverlay
implements IGTObject {
    public static ButtonOverlay STOP = new ButtonOverlay("gtlib", "stop", 16, 16);
    public static ButtonOverlay TORCH_OFF = new ButtonOverlay("gtlib", "torch_off", 16, 16);
    public static ButtonOverlay TORCH_ON = new ButtonOverlay("gtlib", "torch_on", 16, 16);
    public static ButtonOverlay REDSTONE = new ButtonOverlay("gtlib", "redstone", 16, 16).setTextureOverride(new ResourceLocation("textures/item/redstone.png"));
    public static ButtonOverlay EXPORT = new ButtonOverlay("gtlib", "export", 16, 16);
    public static ButtonOverlay IMPORT = new ButtonOverlay("gtlib", "import", 16, 16);
    public static ButtonOverlay EXPORT_IMPORT = new ButtonOverlay("gtlib", "export_import", 16, 16);
    public static ButtonOverlay IMPORT_EXPORT = new ButtonOverlay("gtlib", "import_export", 16, 16);
    public static ButtonOverlay INPUT_OFF = new ButtonOverlay("gtlib", "input_off", 16, 16);
    public static ButtonOverlay GREY_OFF = new ButtonOverlay("gtlib", "grey_off", 16, 16);
    public static ButtonOverlay GREY_ON = new ButtonOverlay("gtlib", "grey_on", 16, 16);
    public static ButtonOverlay BLUE_OFF = new ButtonOverlay("gtlib", "blue_off", 16, 16);
    public static ButtonOverlay BLUE_ON = new ButtonOverlay("gtlib", "blue_on", 16, 16);
    public static ButtonOverlay LESS = new ButtonOverlay("gtlib", "less", 16, 16);
    public static ButtonOverlay EQUAL = new ButtonOverlay("gtlib", "equal", 16, 16);
    public static ButtonOverlay MORE = new ButtonOverlay("gtlib", "more", 16, 16);
    public static ButtonOverlay WHITELIST = new ButtonOverlay("gtlib", "whitelist", 16, 16);
    public static ButtonOverlay BLACKLIST = new ButtonOverlay("gtlib", "blacklist", 16, 16);
    public static ButtonOverlay MINUS = new ButtonOverlay("gtlib", "minus", 16, 16);
    public static ButtonOverlay PLUS = new ButtonOverlay("gtlib", "plus", 16, 16);
    public static ButtonOverlay DIVISION = new ButtonOverlay("gtlib", "division", 16, 16);
    public static ButtonOverlay MULT = new ButtonOverlay("gtlib", "mult", 16, 16);
    public static ButtonOverlay PERCENT = new ButtonOverlay("gtlib", "percent", 16, 16);
    public static ButtonOverlay ARROW_LEFT = new ButtonOverlay("gtlib", "arrow_left", 16, 16);
    public static ButtonOverlay A_LEFT = new ButtonOverlay("gtlib", "a_left", 16, 16);
    public static ButtonOverlay A_RIGHT = new ButtonOverlay("gtlib", "a_right", 16, 16);
    public static ButtonOverlay ARROW_RIGHT = new ButtonOverlay("gtlib", "arrow_right", 16, 16);
    public static ButtonOverlay INPUT_OUTPUT = new ButtonOverlay("gtlib", "in_out", 14, 14);
    public static ButtonOverlay NO_OVERLAY = new ButtonOverlay("gtlib", "no_overlay", 16, 16);
    public static ButtonOverlay APAD_LEFT = new ButtonOverlay("gtlib", "apad_left", 14, 14).changedOnHovered();
    public static ButtonOverlay PAD_LEFT = new ButtonOverlay("gtlib", "pad_left", 14, 14).changedOnHovered();
    public static ButtonOverlay PAD_RIGHT = new ButtonOverlay("gtlib", "pad_right", 14, 14).changedOnHovered();
    public static ButtonOverlay APAD_RIGHT = new ButtonOverlay("gtlib", "apad_right", 14, 14).changedOnHovered();
    protected String id;
    protected String domain;
    protected int w;
    protected int h;
    protected boolean colored = false;
    protected boolean changedOnHovered = false;
    protected ResourceLocation textureOverride = null;

    public ButtonOverlay(String domain, String id, int w, int h) {
        this.domain = domain;
        this.id = id;
        this.w = w;
        this.h = h;
    }

    public ButtonOverlay colored() {
        this.colored = true;
        return this;
    }

    public ButtonOverlay changedOnHovered() {
        this.changedOnHovered = true;
        return this;
    }

    public ButtonOverlay setTextureOverride(ResourceLocation textureOverride) {
        this.textureOverride = textureOverride;
        return this;
    }

    public ResourceLocation getTexture() {
        if (this.textureOverride != null) {
            return this.textureOverride;
        }
        return new ResourceLocation(this.domain, "textures/gui/button/" + this.id + ".png");
    }

    @Override
    public String getId() {
        return this.id;
    }

    public int getW() {
        return this.w;
    }

    public int getH() {
        return this.h;
    }

    public boolean isChangedOnHovered() {
        return this.changedOnHovered;
    }

    public boolean isColored() {
        return this.colored;
    }
}

