/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.common.event;

import com.teamresourceful.resourcefullib.common.networking.base.Packet;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RecipesUpdatedEvent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.gtreimagined.gtlib.Data;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.GTLibConfig;
import org.gtreimagined.gtlib.GTRemapping;
import org.gtreimagined.gtlib.blockentity.pipe.BlockEntityPipe;
import org.gtreimagined.gtlib.capability.fluid.FluidHandlerItem;
import org.gtreimagined.gtlib.common.event.PlayerTickCallback;
import org.gtreimagined.gtlib.data.GTLibMaterials;
import org.gtreimagined.gtlib.data.GTMaterialTypes;
import org.gtreimagined.gtlib.datagen.GTLibDynamics;
import org.gtreimagined.gtlib.datagen.GTLoot;
import org.gtreimagined.gtlib.datagen.providers.GTBlockLootProvider;
import org.gtreimagined.gtlib.gui.container.IGTContainer;
import org.gtreimagined.gtlib.item.IFluidItem;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.material.MaterialTypeBlock;
import org.gtreimagined.gtlib.network.GTLibNetwork;
import org.gtreimagined.gtlib.network.packets.ClientboundWorldgenSyncPacket;
import org.gtreimagined.gtlib.ore.BlockOre;
import org.gtreimagined.gtlib.pipe.BlockPipe;
import org.gtreimagined.gtlib.pipe.TileTicker;
import org.gtreimagined.gtlib.proxy.ClientHandler;
import org.gtreimagined.gtlib.structure.StructureCache;
import org.gtreimagined.gtlib.tool.IGTTool;
import org.gtreimagined.gtlib.util.RegistryUtils;
import org.gtreimagined.gtlib.worldgen.GTLibWorldGenerator;

@Mod.EventBusSubscriber(modid="gtlib")
public class ForgeCommonEvents {
    @SubscribeEvent
    public static void onContainerOpen(PlayerContainerEvent.Open ev) {
        Player player = ev.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            AbstractContainerMenu abstractContainerMenu = ev.getContainer();
            if (abstractContainerMenu instanceof IGTContainer) {
                IGTContainer gtContainer = (IGTContainer)abstractContainerMenu;
                gtContainer.listeners().add(serverPlayer);
            }
        }
    }

    @SubscribeEvent
    public static void onItemCrafted(PlayerEvent.ItemCraftedEvent e) {
        Container inv = e.getInventory();
        Player player = e.getPlayer();
        if (!GTLibConfig.PLAY_CRAFTING_SOUNDS.get()) {
            return;
        }
        for (int i = 0; i < inv.m_6643_(); ++i) {
            IGTTool tool;
            SoundEvent type;
            Item item = inv.m_8020_(i).m_41720_();
            if (!(item instanceof IGTTool) || (type = (tool = (IGTTool)item).getGTToolType().getUseSound()) == null) continue;
            player.m_5496_(type, 0.75f, 0.75f);
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        TileTicker.onServerWorldTick(ServerLifecycleHooks.getCurrentServer(), event.phase == TickEvent.Phase.START);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onBlockPlace(BlockEvent.EntityPlaceEvent event) {
        BlockEntity blockEntity;
        if (event.getPlacedAgainst().m_60734_() instanceof BlockPipe && !(event.getPlacedBlock().m_60734_() instanceof BlockPipe) && event.getEntity() instanceof Player && !event.getEntity().m_6047_() && (blockEntity = event.getWorld().m_7702_(event.getPos().m_142300_(event.getEntity().m_6350_()))) instanceof BlockEntityPipe) {
            BlockEntityPipe pipe = (BlockEntityPipe)blockEntity;
            if (event.getPlacedBlock().m_60734_() instanceof EntityBlock) {
                pipe.setConnection(event.getEntity().m_6350_().m_122424_());
            }
        }
    }

    @SubscribeEvent
    public static void onAnvilUpdated(AnvilUpdateEvent event) {
        Item item;
        ItemStack left = event.getLeft();
        ItemStack right = event.getRight();
        if (left.m_41720_() == right.m_41720_() && (item = left.m_41720_()) instanceof IGTTool) {
            IGTTool leftTool = (IGTTool)item;
            item = right.m_41720_();
            if (item instanceof IGTTool) {
                IGTTool rightTool = (IGTTool)item;
                if (leftTool.getPrimaryMaterial(left) != rightTool.getPrimaryMaterial(right) || leftTool.getSecondaryMaterial(left) != rightTool.getSecondaryMaterial(right)) {
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLootTableLoad(LootTableLoadEvent event) {
        Block block;
        ResourceLocation blockId;
        if (event.getTable().getLootTableId().m_135815_().startsWith("blocks/") && RegistryUtils.blockExists(blockId = new ResourceLocation(event.getTable().getLootTableId().m_135827_(), event.getName().m_135815_().replace("blocks/", ""))) && ((block = RegistryUtils.getBlockFromId(blockId)) == Blocks.f_50126_ || block == Blocks.f_50354_ || block == Blocks.f_50568_)) {
            event.getTable().addPool(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(GTBlockLootProvider.SAW).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)block)).m_79082_());
        }
        GTLoot.onLootTableLoad(event.getTable().getPool("main"), event.getName());
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        PlayerTickCallback.PLAYER_TICK_CALLBACKS.forEach(c -> c.onTick(event.phase == TickEvent.Phase.END, event.side == LogicalSide.SERVER, event.player));
    }

    @SubscribeEvent
    public static void onDataPackSync(OnDatapackSyncEvent event) {
        if (event.getPlayer() != null) {
            GTLibNetwork.NETWORK.sendToPlayer((Packet)new ClientboundWorldgenSyncPacket(), (Player)event.getPlayer());
        } else if (ServerLifecycleHooks.getCurrentServer() != null) {
            GTLibNetwork.NETWORK.sendToAllPlayers((Packet)new ClientboundWorldgenSyncPacket(), ServerLifecycleHooks.getCurrentServer());
        }
    }

    @SubscribeEvent
    public static void onAttachItemCapabilities(AttachCapabilitiesEvent<ItemStack> event) {
        Item item = ((ItemStack)event.getObject()).m_41720_();
        if (item instanceof IFluidItem) {
            IFluidItem fluidItem = (IFluidItem)item;
            event.addCapability(new ResourceLocation("gtlib", "fluid"), (ICapabilityProvider)new FluidHandlerItem((ItemStack)event.getObject(), fluidItem.getCapacity(), fluidItem.getFilter()));
        }
    }

    @SubscribeEvent
    public static void remapMissingEnchantments(RegistryEvent.MissingMappings<Enchantment> event) {
        event.getMappings("antimatter").forEach(m -> {
            if (m.key.m_135815_().equals("energy_efficiency")) {
                m.remap((IForgeRegistryEntry)Data.ENERGY_EFFICIENCY);
            }
            if (m.key.m_135815_().equals("implosion")) {
                m.remap((IForgeRegistryEntry)Data.IMPLOSION);
            }
        });
    }

    @SubscribeEvent
    public static void remapMissingBlocks(RegistryEvent.MissingMappings<Block> event) {
        for (String modid : GTRemapping.getRemappingMap().keySet()) {
            for (RegistryEvent.MissingMappings.Mapping mapping : event.getMappings(modid)) {
                Block replacement;
                Map<String, ResourceLocation> map2 = GTRemapping.getRemappingMap().get(modid);
                if (!map2.containsKey(mapping.key.m_135815_()) || (replacement = GTAPI.get(Block.class, map2.get(mapping.key.m_135815_()))) == null) continue;
                mapping.remap((IForgeRegistryEntry)replacement);
            }
        }
        event.getMappings("kubejs").forEach(map -> {
            Block replacement;
            Material mat;
            String domain = map.key.m_135827_();
            String id = map.key.m_135815_();
            if (id.startsWith("block_") && (mat = Material.get(id.replace("block_", ""))) != Material.NULL) {
                map.remap((IForgeRegistryEntry)((MaterialTypeBlock.IBlockGetter)GTMaterialTypes.BLOCK.get()).get(mat).asBlock());
                return;
            }
            if (id.startsWith("ore_") && (replacement = (Block)GTAPI.get(BlockOre.class, id)) != null) {
                map.remap((IForgeRegistryEntry)replacement);
                return;
            }
            replacement = GTAPI.get(Block.class, id, "antimatter_shared");
            if (replacement != null) {
                map.remap((IForgeRegistryEntry)replacement);
            }
        });
        event.getMappings("antimatter_shared").forEach(map -> {
            Block replacementBlock;
            String id = map.key.m_135815_();
            if (id.equals("basalt")) {
                map.remap((IForgeRegistryEntry)Blocks.f_50137_);
                return;
            }
            String replacement = "";
            if (id.startsWith("fluid_")) {
                replacement = id.replace("fluid_", "fluid_pipe_");
            } else if (id.startsWith("item_")) {
                replacement = id.replace("item_", "item_pipe_");
            } else if (id.contains("vanilla_basalt")) {
                replacement = id.replace("vanilla_basalt", "basalt");
            } else if (id.contains("sad_red")) {
                replacement = id.replace("sand_red", "red_sand");
            }
            if (id.contains("__")) {
                String string = replacement = replacement.isEmpty() ? id.replace("__", "_") : replacement.replace("__", "_");
            }
            if (!replacement.isEmpty() && (replacementBlock = GTAPI.get(Block.class, replacement, "antimatter_shared")) != null) {
                map.remap((IForgeRegistryEntry)replacementBlock);
            }
        });
    }

    @SubscribeEvent
    public static void remapMissingItems(RegistryEvent.MissingMappings<Item> event) {
        for (String modid : GTRemapping.getRemappingMap().keySet()) {
            for (RegistryEvent.MissingMappings.Mapping mapping : event.getMappings(modid)) {
                Item replacement;
                Map<String, ResourceLocation> map2 = GTRemapping.getRemappingMap().get(modid);
                if (!map2.containsKey(mapping.key.m_135815_()) || (replacement = GTAPI.get(Item.class, map2.get(mapping.key.m_135815_()))) == null) continue;
                mapping.remap((IForgeRegistryEntry)replacement);
            }
        }
        event.getMappings("gtlib").forEach(map -> {
            Item replacement = GTAPI.get(Item.class, map.key.m_135815_(), "antimatter_shared");
            if (replacement != null) {
                map.remap((IForgeRegistryEntry)replacement);
            }
        });
        event.getMappings("antimatter_shared").forEach(map -> {
            Item replacementBlock;
            String replacement;
            String id = map.key.m_135815_();
            if (id.equals("basalt")) {
                map.remap((IForgeRegistryEntry)Items.f_42051_);
                return;
            }
            if (id.equals("dust_gravel")) {
                map.remap((IForgeRegistryEntry)GTMaterialTypes.DUST.get(GTLibMaterials.Stone));
                return;
            }
            if (id.startsWith("rock_") && (replacement = GTAPI.get(Item.class, id.replace("rock_", "bearing_rock_"), "antimatter_shared")) != null) {
                map.remap((IForgeRegistryEntry)replacement);
                return;
            }
            if (id.contains("crushed_centrifuged") && (replacement = GTAPI.get(Item.class, id.replace("centrifuged", "refined"), "antimatter_shared")) != null) {
                map.remap((IForgeRegistryEntry)replacement);
                return;
            }
            replacement = "";
            if (id.startsWith("fluid_")) {
                replacement = id.replace("fluid_", "fluid_pipe_");
            } else if (id.startsWith("item_")) {
                replacement = id.replace("item_", "item_pipe_");
            } else if (id.contains("vanilla_basalt")) {
                replacement = id.replace("vanilla_basalt", "basalt");
            } else if (id.contains("sand_red")) {
                replacement = id.replace("sand_red", "red_sand");
            }
            if (id.contains("__")) {
                String string = replacement = replacement.isEmpty() ? id.replace("__", "_") : replacement.replace("__", "_");
            }
            if (!replacement.isEmpty() && (replacementBlock = GTAPI.get(Item.class, replacement, "antimatter_shared")) != null) {
                map.remap((IForgeRegistryEntry)replacementBlock);
            }
        });
    }

    @SubscribeEvent
    public static void recipeEvent(RecipesUpdatedEvent ev) {
        if (ClientHandler.isLocal()) {
            GTLibDynamics.onRecipeCompile(false, ev.getRecipeManager());
        }
    }

    @SubscribeEvent
    public static void tagsEvent(TagsUpdatedEvent ev) {
        if (FMLEnvironment.dist == Dist.CLIENT && !ClientHandler.isLocal()) {
            GTLibDynamics.onRecipeCompile(true, Minecraft.m_91087_().m_91403_().m_105141_());
        }
    }

    @SubscribeEvent
    public static void biomeLoadEvent(BiomeLoadingEvent event) {
        GTLibWorldGenerator.reloadEvent(event.getName(), event.getClimate(), event.getCategory(), event.getEffects(), (BiomeGenerationSettings.Builder)event.getGeneration(), (MobSpawnSettings.Builder)event.getSpawns());
    }

    @SubscribeEvent
    public static void onWorldUnload(WorldEvent.Unload event) {
        StructureCache.onWorldUnload(event.getWorld());
    }
}

