/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.structure;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import it.unimi.dsi.fastutil.longs.LongLists;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collections;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.blockentity.BlockEntityMachine;
import org.gtreimagined.gtlib.blockentity.multi.BlockEntityBasicMultiMachine;
import org.gtreimagined.gtlib.structure.StructureHandle;
import org.jetbrains.annotations.Nullable;

public class StructureCache {
    private static final Object2ObjectMap<Level, DimensionEntry> LOOKUP = new Object2ObjectOpenHashMap();
    private static final Object2ObjectMap<Level, Long2ObjectMap<Set<StructureHandle<?>>>> CALLBACKS = new Object2ObjectOpenHashMap();

    public static boolean validate(Level world, BlockPos pos, LongList structure, int maxAmount) {
        DimensionEntry e = (DimensionEntry)LOOKUP.computeIfAbsent((Object)world, w -> new DimensionEntry());
        if (!StructureCache.has(world, pos)) {
            boolean ok = e.validate(pos, maxAmount, structure);
            return ok;
        }
        return false;
    }

    public static int refCount(Level world, BlockPos pos) {
        DimensionEntry entry = (DimensionEntry)LOOKUP.get((Object)world);
        if (entry == null) {
            return 0;
        }
        LongSet e = entry.get(pos);
        return e == null ? 0 : e.size();
    }

    public static boolean has(Level world, BlockPos pos) {
        DimensionEntry entry = (DimensionEntry)LOOKUP.get((Object)world);
        if (entry == null) {
            return false;
        }
        long p = pos.m_121878_();
        LongList l = (LongList)entry.CONTROLLER_TO_STRUCTURE.get(p);
        if (l == null || l.size() == 0) {
            return false;
        }
        return ((LongSet)entry.STRUCTURE_TO_CONTROLLER.get(l.iterator().nextLong())).contains(p);
    }

    @Nullable
    public static LongSet get(Level world, BlockPos pos) {
        DimensionEntry entry = (DimensionEntry)LOOKUP.get((Object)world);
        return entry != null ? entry.get(pos) : null;
    }

    @Nullable
    public static <T extends BlockEntityBasicMultiMachine> T getAnyMulti(Level world, BlockPos pos, Class<T> clazz) {
        DimensionEntry entry = (DimensionEntry)LOOKUP.get((Object)world);
        if (entry == null) {
            return null;
        }
        LongSet list = entry.get(pos);
        if (list == null || list.size() == 0) {
            return null;
        }
        LongIterator longIterator = list.iterator();
        while (longIterator.hasNext()) {
            long e = (Long)longIterator.next();
            BlockPos p = BlockPos.m_122022_((long)e);
            BlockEntity tile = world.m_7702_(p);
            if (!clazz.isInstance(tile)) continue;
            return (T)((BlockEntityBasicMultiMachine)tile);
        }
        return null;
    }

    public static void add(Level world, BlockPos pos, LongList structure) {
        DimensionEntry entry = (DimensionEntry)LOOKUP.computeIfAbsent((Object)world, e -> new DimensionEntry());
        entry.add(pos, structure);
        StructureCache.notifyListenersAdd(world, pos);
    }

    public static void remove(Level world, BlockPos pos) {
        DimensionEntry entry = (DimensionEntry)LOOKUP.get((Object)world);
        if (entry == null) {
            return;
        }
        entry.remove(pos);
        StructureCache.notifyListenersRemove(world, pos);
    }

    private static void refreshController(Level world, BlockPos controller, BlockPos at) {
        BlockEntity tile = world.m_7702_(controller);
        if (tile instanceof BlockEntityMachine) {
            BlockEntityMachine machine = (BlockEntityMachine)tile;
            machine.onBlockUpdate(at);
        }
    }

    public static void addListener(StructureHandle<?> handle, Level world, BlockPos pos) {
        Long2ObjectMap map = (Long2ObjectMap)CALLBACKS.computeIfAbsent((Object)world, k -> new Long2ObjectOpenHashMap());
        Set set = (Set)map.computeIfAbsent(pos.m_121878_(), k -> new ObjectOpenHashSet());
        set.add(handle);
        BlockEntity tile = world.m_7702_(pos);
        if (tile != null && StructureCache.has(world, pos)) {
            handle.structureCacheAddition(tile);
        }
    }

    public static void removeListener(StructureHandle<?> handle, Level world, BlockPos pos) {
        Set set;
        Long2ObjectMap map = (Long2ObjectMap)CALLBACKS.get((Object)world);
        if (map != null && (set = (Set)map.get(pos.m_121878_())) != null) {
            set.remove(handle);
        }
    }

    private static void notifyListenersAdd(Level world, BlockPos pos) {
        Long2ObjectMap map = (Long2ObjectMap)CALLBACKS.get((Object)world);
        if (map != null) {
            BlockEntity tile = world.m_7702_(pos);
            ((Set)map.getOrDefault(pos.m_121878_(), Collections.emptySet())).forEach(handle -> handle.structureCacheAddition(tile));
        }
    }

    private static void notifyListenersRemove(Level world, BlockPos pos) {
        Long2ObjectMap map = (Long2ObjectMap)CALLBACKS.get((Object)world);
        if (map != null) {
            ((Set)map.getOrDefault(pos.m_121878_(), Collections.emptySet())).forEach(StructureHandle::structureCacheRemoval);
        }
    }

    public static void onWorldUnload(LevelAccessor world) {
        LOOKUP.remove((Object)((Level)world));
        Long2ObjectMap map = (Long2ObjectMap)CALLBACKS.remove((Object)((Level)world));
        if (map != null) {
            map.forEach((k, v) -> v.forEach(StructureHandle::structureCacheRemoval));
        }
    }

    static {
        GTAPI.registerBlockUpdateHandler((world, pos, oldState, newState, flags) -> {
            if (oldState == newState) {
                return;
            }
            if ((flags & 1) == 0) {
                return;
            }
            DimensionEntry entry = (DimensionEntry)LOOKUP.get((Object)world);
            if (entry == null) {
                return;
            }
            LongSet controllerPos = entry.get(pos);
            if (controllerPos != null && controllerPos.size() > 0) {
                controllerPos.forEach(controller -> {
                    if (controller != pos.m_121878_()) {
                        StructureCache.refreshController(world, BlockPos.m_122022_((long)controller), pos);
                    }
                });
            }
        });
    }

    public static class DimensionEntry {
        public final Long2ObjectMap<LongSet> STRUCTURE_TO_CONTROLLER = new Long2ObjectOpenHashMap();
        public final Long2ObjectMap<LongList> CONTROLLER_TO_STRUCTURE = new Long2ObjectOpenHashMap();

        public DimensionEntry() {
            this.CONTROLLER_TO_STRUCTURE.defaultReturnValue((Object)LongLists.EMPTY_LIST);
        }

        @Nullable
        public LongSet get(BlockPos pos) {
            return (LongSet)this.STRUCTURE_TO_CONTROLLER.get(pos.m_121878_());
        }

        public void add(BlockPos pos, LongList structure) {
            long at = pos.m_121878_();
            this.CONTROLLER_TO_STRUCTURE.put(at, (Object)structure);
            LongListIterator longListIterator = structure.iterator();
            while (longListIterator.hasNext()) {
                long s = (Long)longListIterator.next();
                this.STRUCTURE_TO_CONTROLLER.compute(s, (k, v) -> {
                    if (v == null) {
                        v = new LongOpenHashSet();
                    }
                    v.add(pos.m_121878_());
                    return v;
                });
            }
        }

        public boolean validate(BlockPos pos, int maxAmount, LongList structure) {
            long at = pos.m_121878_();
            long i = structure.longStream().map(t -> {
                LongSet list = (LongSet)this.STRUCTURE_TO_CONTROLLER.get(t);
                if (list == null) {
                    return 0L;
                }
                return list.size();
            }).max().orElse(0L);
            return i <= (long)maxAmount;
        }

        public void remove(BlockPos pos) {
            long at = pos.m_121878_();
            LongList structure = (LongList)this.CONTROLLER_TO_STRUCTURE.remove(at);
            LongListIterator longListIterator = structure.iterator();
            while (longListIterator.hasNext()) {
                long s = (Long)longListIterator.next();
                this.STRUCTURE_TO_CONTROLLER.compute(s, (k, v) -> {
                    if (v == null) {
                        return null;
                    }
                    if (v.size() == 0) {
                        return null;
                    }
                    v.remove(pos.m_121878_());
                    return v;
                });
            }
        }
    }
}

