/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.datagen.loaders;

import com.google.common.collect.ImmutableMap;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.gtreimagined.gtlib.data.GTMaterialTypes;
import org.gtreimagined.gtlib.datagen.builder.GTCookingRecipeBuilder;
import org.gtreimagined.gtlib.datagen.providers.GTRecipeProvider;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.material.MaterialTags;
import org.gtreimagined.gtlib.material.MaterialType;
import org.gtreimagined.gtlib.material.MaterialTypeItem;
import org.gtreimagined.gtlib.recipe.ingredient.RecipeIngredient;

public class MaterialRecipes {
    public static void init(Consumer<FinishedRecipe> consumer, GTRecipeProvider provider) {
        GTMaterialTypes.DUST.all().forEach(m -> {
            provider.addStackRecipe(consumer, "gtlib", m.getId() + "_dust_small", "gtlib_dusts", GTMaterialTypes.DUST.get((Material)m, 1), (ImmutableMap<Character, Object>)ImmutableMap.of((Object)Character.valueOf('D'), GTMaterialTypes.SMALL_DUST.getMaterialTag((Material)m)), "DD", "DD");
            provider.addStackRecipe(consumer, "gtlib", m.getId() + "_dust_tiny", "gtlib_dusts", GTMaterialTypes.DUST.get((Material)m, 1), (ImmutableMap<Character, Object>)ImmutableMap.of((Object)Character.valueOf('D'), GTMaterialTypes.TINY_DUST.getMaterialTag((Material)m)), "DDD", "DDD", "DDD");
        });
        GTMaterialTypes.INGOT.all().forEach(m -> {
            if (!(!m.has(GTMaterialTypes.NUGGET) || GTMaterialTypes.INGOT.hasReplacement((Material)m) && GTMaterialTypes.NUGGET.hasReplacement((Material)m))) {
                provider.addItemRecipe(consumer, "gtlib", m.getId() + "_ingot", "ingots", (ItemLike)GTMaterialTypes.INGOT.get((Material)m), (ImmutableMap<Character, Object>)ImmutableMap.of((Object)Character.valueOf('I'), GTMaterialTypes.NUGGET.getMaterialTag((Material)m)), "III", "III", "III");
                provider.shapeless(consumer, "nugget_" + m.getId() + "_from_ingot", "ingots", GTMaterialTypes.NUGGET.get((Material)m, 9), GTMaterialTypes.INGOT.getMaterialTag((Material)m));
            }
            if (m.has(GTMaterialTypes.CHUNK)) {
                provider.addItemRecipe(consumer, "gtlib", m.getId() + "_ingot_from_chunk", "ingots", (ItemLike)GTMaterialTypes.INGOT.get((Material)m), (ImmutableMap<Character, Object>)ImmutableMap.of((Object)Character.valueOf('I'), GTMaterialTypes.CHUNK.getMaterialTag((Material)m)), "II", "II");
            }
        });
        GTMaterialTypes.RAW_ORE.all().stream().filter(m -> !m.has(MaterialTags.HAS_CUSTOM_SMELTING) && MaterialTags.SMELT_INTO.getMapping((Material)m).has(GTMaterialTypes.INGOT)).forEach(m -> {
            if (!GTMaterialTypes.INGOT.hasReplacement((Material)m) && !GTMaterialTypes.RAW_ORE.hasReplacement((Material)m)) {
                MaterialRecipes.addSmeltingRecipe(consumer, provider, GTMaterialTypes.RAW_ORE, GTMaterialTypes.INGOT, 1, m, MaterialTags.SMELT_INTO.getMapping((Material)m));
            }
        });
        GTMaterialTypes.ORE.all().stream().filter(m -> !m.has(MaterialTags.HAS_CUSTOM_SMELTING) && MaterialTags.SMELT_INTO.getMapping((Material)m).has(GTMaterialTypes.INGOT)).forEach(m -> {
            if (!GTMaterialTypes.ORE.hasReplacement((Material)m) && !GTMaterialTypes.INGOT.hasReplacement((Material)m)) {
                MaterialRecipes.addSmeltingRecipe(consumer, provider, GTMaterialTypes.ORE, GTMaterialTypes.INGOT, 1, m, MaterialTags.SMELT_INTO.getMapping((Material)m));
            }
        });
        GTMaterialTypes.CRUSHED_ORE.all().stream().filter(m -> !m.has(MaterialTags.HAS_CUSTOM_SMELTING) && MaterialTags.SMELT_INTO.getMapping((Material)m).has(GTMaterialTypes.INGOT)).forEach(m -> {
            if (m != MaterialTags.SMELT_INTO.getMapping((Material)m) || !m.has(GTMaterialTypes.NUGGET)) {
                return;
            }
            MaterialRecipes.addSmeltingRecipe(consumer, provider, GTMaterialTypes.CRUSHED_ORE, GTMaterialTypes.NUGGET, 12, m);
            MaterialRecipes.addSmeltingRecipe(consumer, provider, GTMaterialTypes.IMPURE_DUST, GTMaterialTypes.INGOT, 1, m);
            MaterialRecipes.addSmeltingRecipe(consumer, provider, GTMaterialTypes.PURIFIED_ORE, GTMaterialTypes.NUGGET, 11, m);
            MaterialRecipes.addSmeltingRecipe(consumer, provider, GTMaterialTypes.PURE_DUST, GTMaterialTypes.INGOT, 1, m);
            MaterialRecipes.addSmeltingRecipe(consumer, provider, GTMaterialTypes.REFINED_ORE, GTMaterialTypes.NUGGET, 10, m);
        });
        GTMaterialTypes.DUST.all().forEach(m -> {
            if (m.has(MaterialTags.HAS_CUSTOM_SMELTING)) {
                return;
            }
            if (MaterialTags.DIRECT_SMELT_INTO.getMapping((Material)m).has(GTMaterialTypes.INGOT)) {
                MaterialRecipes.addSmeltingRecipe(consumer, provider, GTMaterialTypes.DUST, GTMaterialTypes.INGOT, 1, m, MaterialTags.DIRECT_SMELT_INTO.getMapping((Material)m));
            }
            if (MaterialTags.DIRECT_SMELT_INTO.getMapping((Material)m).has(GTMaterialTypes.NUGGET)) {
                MaterialRecipes.addSmeltingRecipe(consumer, provider, GTMaterialTypes.TINY_DUST, GTMaterialTypes.NUGGET, 1, m, MaterialTags.DIRECT_SMELT_INTO.getMapping((Material)m));
            }
            if (MaterialTags.DIRECT_SMELT_INTO.getMapping((Material)m).has(GTMaterialTypes.CHUNK)) {
                MaterialRecipes.addSmeltingRecipe(consumer, provider, GTMaterialTypes.SMALL_DUST, GTMaterialTypes.CHUNK, 1, m, MaterialTags.DIRECT_SMELT_INTO.getMapping((Material)m));
            }
        });
    }

    public static void addSmeltingRecipe(Consumer<FinishedRecipe> consumer, GTRecipeProvider provider, MaterialType<?> input, MaterialTypeItem<?> output, int amount, Material in) {
        MaterialRecipes.addSmeltingRecipe(consumer, provider, input, output, amount, in, in);
    }

    public static void addSmeltingRecipe(Consumer<FinishedRecipe> consumer, GTRecipeProvider provider, MaterialType<?> input, MaterialTypeItem<?> output, int amount, Material in, Material out) {
        GTCookingRecipeBuilder.blastingRecipe(RecipeIngredient.of(input.getMaterialTag(in), 1), new ItemStack((ItemLike)output.get(out), MaterialTags.SMELTING_MULTI.getInt(in) * amount), 2.0f, 100).addCriterion("has_material_" + in.getId(), provider.hasSafeItem(output.getMaterialTag(out))).build(consumer, provider.fixLoc("gtlib", in.getId().concat("_" + input.getId() + "_to_" + output.getId())));
        GTCookingRecipeBuilder.smeltingRecipe(RecipeIngredient.of(input.getMaterialTag(in), 1), new ItemStack((ItemLike)output.get(out), MaterialTags.SMELTING_MULTI.getInt(in) * amount), 2.0f, 200).addCriterion("has_material_" + in.getId(), provider.hasSafeItem(output.getMaterialTag(out))).build(consumer, provider.fixLoc("gtlib", in.getId().concat("_" + input.getId() + "_to_" + output.getId() + "_smelting")));
    }
}

