/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.gui;

import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraftforge.common.extensions.IForgeMenuType;
import org.apache.commons.lang3.function.TriFunction;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.capability.IGuiHandler;
import org.gtreimagined.gtlib.gui.container.IGTContainer;
import org.gtreimagined.gtlib.registration.IGTObject;

public abstract class MenuHandler<T extends AbstractContainerMenu>
implements IGTObject {
    protected ResourceLocation loc;
    private MenuType<T> containerType;

    public MenuHandler(String domain, String id) {
        this.loc = new ResourceLocation(domain, id);
        GTAPI.register(MenuHandler.class, this);
        MenuType<T> type = this.getContainerType();
        GTAPI.register(MenuType.class, id, domain, type);
    }

    @Override
    public String getDomain() {
        return this.loc.m_135827_();
    }

    @Override
    public String getId() {
        return this.loc.m_135815_();
    }

    protected abstract T getMenu(IGuiHandler var1, Inventory var2, int var3);

    @MethodsReturnNonnullByDefault
    public final T menu(IGuiHandler source, Inventory playerInv, int windowId) {
        T t = this.getMenu(source, playerInv, windowId);
        if (!source.isRemote()) {
            ((IGTContainer)t).source().init();
        }
        return t;
    }

    @MethodsReturnNonnullByDefault
    public MenuType<T> getContainerType() {
        if (this.containerType == null) {
            this.containerType = MenuHandler.create(this::onContainerCreate);
        }
        return this.containerType;
    }

    static <T extends AbstractContainerMenu> MenuType<T> create(TriFunction<Integer, Inventory, FriendlyByteBuf, T> factory) {
        return IForgeMenuType.create((arg_0, arg_1, arg_2) -> factory.apply(arg_0, arg_1, arg_2));
    }

    public abstract T onContainerCreate(int var1, Inventory var2, FriendlyByteBuf var3);

    public String screenID() {
        return "default";
    }

    public String screenDomain() {
        return "gtlib";
    }
}

