/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.capability.machine;

import java.util.Optional;
import lombok.Generated;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.LazyOptional;
import org.gtreimagined.gtlib.Data;
import org.gtreimagined.gtlib.Ref;
import org.gtreimagined.gtlib.blockentity.BlockEntityBase;
import org.gtreimagined.gtlib.blockentity.BlockEntityMachine;
import org.gtreimagined.gtlib.capability.Dispatch;
import org.gtreimagined.gtlib.capability.IMachineHandler;
import org.gtreimagined.gtlib.machine.event.MachineEvent;
import org.gtreimagined.gtlib.util.Utils;
import org.gtreimagined.tesseract.TesseractCapUtils;
import org.gtreimagined.tesseract.api.hu.IHeatHandler;

public class DefaultHeatHandler
implements IHeatHandler,
Dispatch.Sided<IHeatHandler> {
    public final int heatCap;
    public final int temperaturesize;
    public final int maxInput;
    public final int maxOutput;
    protected int currentHeat;
    public final BlockEntityBase<?> tile;

    public DefaultHeatHandler(BlockEntityBase<?> tile, int heatCap, int maxInput, int maxOutput) {
        this.heatCap = heatCap;
        this.tile = tile;
        this.temperaturesize = 100;
        this.maxInput = maxInput;
        this.maxOutput = maxOutput;
    }

    public int insert(int heat, boolean simulate) {
        if (!this.canInput()) {
            return 0;
        }
        int insert = Math.min(this.maxInput, Math.min(this.heatCap - this.currentHeat, heat));
        return this.insertInternal(insert, simulate);
    }

    public int extract(int heat, boolean simulate) {
        if (!this.canOutput()) {
            return 0;
        }
        int extract = Math.min(this.maxOutput, Math.min(this.currentHeat, heat));
        return this.extractInternal(extract, simulate);
    }

    public int insertInternal(int heat, boolean simulate) {
        int insert = Math.min(this.heatCap - this.currentHeat, heat);
        if (!simulate) {
            this.add(insert);
        }
        return insert;
    }

    public int extractInternal(int heat, boolean simulate) {
        int extract = Math.min(this.currentHeat, heat);
        if (!simulate) {
            this.sub(extract);
        }
        return extract;
    }

    public boolean canInput() {
        return this.maxInput > 0;
    }

    public boolean canOutput() {
        return this.maxOutput > 0;
    }

    public boolean canInput(Direction direction) {
        return this.canInput();
    }

    public boolean canOutput(Direction direction) {
        return this.canOutput();
    }

    public long getMaxInsert() {
        return this.maxInput;
    }

    public long getMaxExtract() {
        return this.maxOutput;
    }

    protected void sub(int temp) {
        this.currentHeat -= temp;
        BlockEntityBase<?> blockEntityBase = this.tile;
        if (blockEntityBase instanceof IMachineHandler) {
            IMachineHandler machineHandler = (IMachineHandler)((Object)blockEntityBase);
            machineHandler.onMachineEvent(MachineEvent.HEAT_DRAINED, temp);
        }
    }

    protected void add(int temp) {
        this.currentHeat += temp;
        BlockEntityBase<?> blockEntityBase = this.tile;
        if (blockEntityBase instanceof IMachineHandler) {
            IMachineHandler machineHandler = (IMachineHandler)((Object)blockEntityBase);
            machineHandler.onMachineEvent(MachineEvent.HEAT_INPUTTED, temp);
        }
    }

    public int getTemperature() {
        return this.currentHeat / this.temperaturesize;
    }

    public void update(boolean active) {
        for (Direction dir : Ref.DIRS) {
            Optional handle;
            BlockEntity tile;
            if (!this.canOutput(dir) || (tile = this.tile.getCachedBlockEntity(dir)) == null || (handle = TesseractCapUtils.INSTANCE.getHeatHandler(tile, dir.m_122424_())).map(h -> !h.canInput(dir.m_122424_())).orElse(true).booleanValue()) continue;
            handle.ifPresent(eh -> Utils.transferHeat(this, eh));
        }
    }

    public int getHeat() {
        return this.currentHeat;
    }

    public int getHeatCap() {
        return this.heatCap;
    }

    @Override
    public LazyOptional<? extends IHeatHandler> forSide(Direction side) {
        BlockEntityBase<?> blockEntityBase = this.tile;
        if (blockEntityBase instanceof BlockEntityMachine) {
            BlockEntityMachine m = (BlockEntityMachine)blockEntityBase;
            if (side == null) {
                return LazyOptional.of(() -> this);
            }
            if (m.coverHandler.map(t -> t.get(side).getFactory() == Data.COVERHEAT).orElse(false).booleanValue()) {
                return LazyOptional.of(() -> this);
            }
            return LazyOptional.empty();
        }
        return LazyOptional.of(() -> this);
    }

    @Override
    public LazyOptional<? extends IHeatHandler> forNullSide() {
        return this.forSide(null);
    }

    public CompoundTag serialize(CompoundTag tag) {
        tag.m_128405_("mh", this.currentHeat);
        return tag;
    }

    public void deserialize(CompoundTag nbt) {
        this.currentHeat = nbt.m_128451_("mh");
    }

    @Generated
    public void setCurrentHeat(int currentHeat) {
        this.currentHeat = currentHeat;
    }
}

